<?php
/*     File: dsp_gedXMLImport.inc  Created: 10/11/2002
		By Matthew A Page
		for Genealogy Web Project
*/

// Variables to count what we process
$numPeople = 0;
$numMarriage = 0;
$numChristenings = 0;
$numBaptisms = 0;

//  Functions to work with the XML file

//  loop through nodes of $parent to get content
function get_content($parent)
{
	$nodes = $parent->children();
	while($node = array_shift($nodes))
		if ($node->type == XML_TEXT_NODE)
			return $node->content;
	return "";
}

//  loop through nodes of $parent to look for the tag $name
//   when we find $name, call get_content to get the text
function find_content($parent, $name)
{
	$nodes = $parent->children();
	while($node = array_shift($nodes))
		if($node->tagname == $name)
		return get_content($node);
	return "";
}

// loop through nodes of $parent until we find tag $name, return
//  attribute $attr
function find_attr($parent, $name, $attr)
{
	$nodes = $parent->children();
	while($node = array_shift($nodes))
		if($node->tagname == $name)
			return $node->get_attribute($attr);
	return "";
}

//  loop through $parent until we find node $name, return that node
function get_node($parent, $name)
{
	$nodes=$parent->children();
	while($node = array_shift($nodes))
	{
		if($node->tagname == $name)
			return $node;
	}
	return "";
}

//  Loop through each $Person in $Family and return Person->ID = $id
function getPerson($Family,$id)
{
	// get Person record with ID = id
	foreach ($Family as $Person)
	if ($Person->ID == $id)
		return $Person;
	return "";
}

// the next three functions are for adding information to already created people

//  find person with id=$ID and add $fid to their record as the family ID
//   (the family to which they belong as a child)
function addFamilyID(&$Peeps, $ID, $fid)
{
	for($i=0;$i<count($Peeps);$i++)
	{
		if ($Peeps[$i]->ID == $ID)
		{
			$Peeps[$i]->setFamIDChild($fid);
			break;
		}
	}
}

//  find person with id=$ID and add $fid as the fathers ID
function addFatherID(&$Peeps, $ID, $fid)
{
	for($i=0;$i<count($Peeps);$i++)
	{
		if ($Peeps[$i]->ID == $ID)
		{
			$Peeps[$i]->father = $fid;
			break;
		}
	}
}

//  find person with id=$ID and add $mid as the mothers ID
function addMotherID(&$Peeps, $ID, $mid)
{
	for($i=0;$i<count($Peeps);$i++)
	{
		if ($Peeps[$i]->ID == $ID)
		{
			$Peeps[$i]->mother = $mid;
			break;
		}
	}
}

//  for testing purposes, delete the records we are about to add

function deleteOldRecords()
{
	$genealogy = mysql_connect('localhost','genealogy','genealogy');
	if (!$genealogy) {die ("MySQL connection failed!");}
	mysql_select_db("genealogy",$genealogy);
	$deleteQry = mysql_query("DELETE from tblFamily where ID >= 5", $genealogy);
	$deleteQry = mysql_query("DELETE from tblPerson where ID >= 12", $genealogy);
}

//  the month formats in the XML doc come in all varieties, this converts the 
//   month from a text [jan, Jan, JAN, January, JANUARY] to a numeric 1,  if 
//   the month is already numeric, it just returns it as is.
function formatMonth($month)
{
	$month = trim($month);
	//print $month . "<br>";
	if (is_int($month)) return $month;
	$newMonth = strtoupper(substr($month,0,3));
	$monthNum = '';
	if($newMonth)
	{
		switch ($newMonth)
		{
			case 'JAN':
				$monthNum = '01';
				break;
			case 'FEB':
				$monthNum = '02';
				break;
			case 'MAR':
				$monthNum = '03';
				break;
			case 'APR':
				$monthNum = '04';
				break;
			case 'MAY':
				$monthNum = '05';
				break;
			case 'JUN':
				$monthNum = '06';
				break;
			case 'JUL':
				$monthNum = '07';
				break;
			case 'AUG':
				$monthNum = '08';
				break;
			case 'SEP':
				$monthNum = '09';
				break;
			case 'OCT':
				$monthNum = '10';
				break;
			case 'NOV':
				$monthNum = '11';
				break;
			case 'DEC':
				$monthNum = '12';
				break;
			default:
				$monthNum = '';
		}
	}
	return $monthNum;
}

// Set up our classes to store people and family information
class Person
{
	var $ID;
	var $Name;
	var $Gender;
	var $DeathStatus;
	var $mother;
	var $father;
	var $DOB;
	var $christening;
	var $death;
	var $familyIDchild;
	var $baptism;

	function setFamIDChild($fid)
	{
		$this->familyIDchild = $fid;
	}

	//  Might be useful to print out everything we have for someone
	function printPerson()
	{
		print "<br>ID = " . $this->ID . "<br>";
		print "Name = " . $this->Name . "<br>";
		print "Gender = " . $this->Gender . "<br>";
		print "DeathStatus = " . $this->DeathStatus . "<br>";
		print "mother = " . $this->mother . "<br>";
		print "father = " . $this->father . "<br>";
		print "DOB = " . $this->$DOB . "<br>";
		print "christening = " . $this->christening . "<br>";
		print "death = " . $this->death . "<br>";
		print "familyIDchild = " . $this->familyIDchild . "<br>";
		print "baptism = " . $this->baptism . "<br>";
	}
}

class Event
{
	var $ID;               // This families ID
	var $husbID;         // The husband/father of this family
	var $wifeID;         // The wife/mother of this family
	var $marriageDate;   // The marriage date of the husband and wife
	var $divorceDate;      // The divorce date (if any)

	//  Set given data for this family
	function setData($newID, $newhusbID, $newwifeID, $newmarriageDate)
	{
		$this->ID = $newID;
		$this->husbID = $newhusbID;
		$this->wifeID = $newwifeID;
		$this->marriageDate = $newmarriageDate;
	}

	// Might be useful to print out everything we have on this marriage
	function printEvent()
	{
		print "<br>In marriage " . $this->ID . ", " . $this->husbID . " married " . $this->wifeID . " on " . $this->marriageDate . "<br>";
	}
}

//  Open the XML document the person has chosen
$xmlDocFile = xmldocfile("includes/sample.xml");
if($xmlDocFile)
{
	$rootXMLFile = $xmlDocFile->root();
	$nodechildren = $rootXMLFile->children();
	$rootchildren = $rootXMLFile->children();

	$People = array();
	$Family = array();

	// delete the people we are about to add so we can start from a clean slate
	deleteOldRecords();

	// First go through and pull all the individual names and the info we want
	foreach($rootchildren as $rootchild)
	{
		if ($rootchild->tagname == "IndividualRec")
		{
			$IndivID =  $rootchild->get_attribute("Id");
			$IndivName = get_node($rootchild, "IndivName");
			if ($IndivName)
			{
				$GivenName = find_content($IndivName,"GivenName");
				$MaidenName = find_content($IndivName,"MaidenName");
				$SurName = find_content($IndivName, "SurName");
				$DeathStatus = find_content($rootchild, "DeathStatus");
				$Gender = find_content($rootchild, "Gender");
				$CompleteName = trim($GivenName) . " /";
				if( $Gender == "F" )  $CompleteName .= trim($MaidenName) . "/"; else $CompleteName .= trim($SurName). "/";
				$person = new Person;
				$person->ID = $IndivID;
				$person->Name = $CompleteName;
				$person->Gender = $Gender;
				$person->DeathStatus = $DeathStatus;
				$person->familyIDchild = "Bite me";
				array_push($People,$person);
				$numPeople++;
			}
		}

		if ($rootchild->tagname == "EventRec")
		{
			$EventID = $rootchild->get_attribute("Id");
			$EventType = $rootchild->get_attribute("Type");

			if ($EventType == "marriage")
			{
				$EventChildren = $rootchild->children();
				foreach($EventChildren as $Participant)
				{
					if ($Participant->tagname == "Participant")
					{
						$Role = find_content($Participant, "Role");
						$Id = find_attr($Participant, "Link", "Ref");

						if ($Role == 'husband') $husbFath = $Id;
						if ($Role == 'wife') $wifeMoth = $Id;
						if ($Role == 'child')
						{
							addFamilyID($People, $Id, $EventID);
							if ($husbFath) addFatherID($People, $Id, $husbFath);
							if ($wifeMoth) addMotherID($People, $Id, $wifeMoth);
						}
					}
				}
				$dateNode = get_node($rootchild,"Date");
				$newYear =  trim(find_content($dateNode,"Year"));
				$newMonth = formatMonth(trim(find_content($dateNode,"Month")));
				$newDay = trim(find_content($dateNode,"Day"));
				$EventDate = $newYear . "-" . $newMonth . "-" . $newDay;
				$event = new Event;
				$event->setData($EventID, $husbFath, $wifeMoth, $EventDate);
				array_push($Family,$event);
				$numMarriage++;
			}

			if ($EventType == "christening")
			{
				$EventChildren = $rootchild->children();
				foreach($EventChildren as $Participant)
				{
					if ($Participant->tagname == "Participant")
					{
						$Role = find_content($Participant, "Role");
						$Id = find_attr($Participant, "Link", "Ref");

						//print "Participant Role = $Role ID = $Id<br>";
						if ($Role == 'husband') $husbFath = $Id;
						if ($Role == 'wife') $wifeMoth = $Id;
					}
				}
				$dateNode = get_node($rootchild,"Date");
				if ($dateNode)
				{
					$newYear =  trim(find_content($dateNode,"Year"));
					$newMonth = formatMonth(trim(find_content($dateNode,"Month")));
					$newDay = trim(find_content($dateNode,"Day"));
					$EventDate = $newYear . "-" . $newMonth . "-" . $newDay;
					$newEventDate = date("Y-m-d",$EventDate);
				}
				$numChristening++;
			}

			if ($EventType == "baptism")
			{
				$EventChildren = $rootchild->children();
				foreach($EventChildren as $Participant)
				{
					if ($Participant->tagname == "Participant")
					{
						$Role = find_content($Participant, "Role");
						$Id = find_attr($Participant, "Link", "Ref");

						//print "Participant Role = $Role ID = $Id<br>";
						if ($Role == 'baptisee') $baptisee = $Id;
					}
				}
				$dateNode = get_node($rootchild,"Date");
				if ($dateNode)
				{
					$newYear =  trim(find_content($dateNode,"Year"));
					$newMonth = formatMonth(trim(find_content($dateNode,"Month")));
					$newDay = trim(find_content($dateNode,"Day"));
					$EventDate = $newYear . "-" . $newMonth . "-" . $newDay;
					$newEventDate = date("Y-m-d",$EventDate);
				}
				$numBaptism++;
			}
		}
	}

// Debug: Print out all People and Events
	foreach ($People as $Person)
	{
		$Person->printPerson();
	}

	foreach ($Family as $event)
	{
		$event->printEvent();
	}


	$newIDs = array();
	$newEvents = array();

	//  Insert information into Database
	foreach ($People as $Person)
	{
		// make two passes, one creates the person and gets their unique ID
		// the next adds all the rest of the data (along with the
		// unique id's of the parents, families and such...
		$insertQry = mysql_query("INSERT INTO tblPerson SET name='$Person->Name'", $genealogy);
		if (!$insertQry) { die ("insert Query failed!"); }
		// Now go back and grab the ID of the person we just created and add it to the newID array
		$getIDQry = mysql_query("SELECT ID FROM tblPerson WHERE name='$Person->Name'", $genealogy);
		if (!$getIDQry) { die ("getID Query failed!"); }
		$ref = mysql_fetch_row($getIDQry);
		//print $Person->ID . " " . $ref[0] . "<br>";
		$newIDs[$Person->ID] = $ref[0];
	}

	// add each event with the correct ID's from the first run
	foreach ($Family as $Event)
	{
		$tempHusbID = $newIDs[$Event->husbID];
		$tempWifeID = $newIDs[$Event->wifeID];
		$tempDateCreated = date("Y-m-d");
		$insertQry = mysql_query("INSERT INTO tblFamily SET husbID='$tempHusbID',wifeID='$tempWifeID',marriageDate='$Event->marriageDate', dateCreated='$tempDateCreated'", $genealogy);
		if (!$insertQry) { die ("insert Query failed!"); }
		$getIDQry = mysql_query("SELECT ID FROM tblFamily where husbID='$tempHusbID' AND wifeID='$tempWifeID'", $genealogy);
		if (!$getIDQry) { die ("getID Query failed!"); }
		$ref = mysql_fetch_row($getIDQry);
		$newEvents[$Event->ID] = $ref[0];
	}

	// Now go back through and add all the people data that we held off before

	foreach ($People as $Person)
	{
		$tempFatherID = $newIDs[$Person->father];
		$tempMotherID = $newIDs[$Person->mother];
		$tempFamID = $newEvents[$Person->familyIDchild];
		$tempPersonID = $newIDs[$Person->ID];
		$tempDateCreated = date("Y-m-d");

		$modifyQry = mysql_query("UPDATE tblPerson SET father='$tempFatherID',mother='$tempMotherID',familyIDchild='$tempFamID', gender='$Person->Gender',deceased='$Person->DeathStatus', DOB='$Person->DOB',christening='$Person->christening',death='$Person->death',dateCreated='$tempDateCreated', baptism='$Person->baptism' WHERE ID='$tempPersonID'", $genealogy);
		print "UPDATE tblPerson SET father='$tempFatherID',mother='$tempMotherID',familyIDchild='$tempFamID', gender='$Person->Gender',deceased='$Person->DeathStatus', DOB='$Person->DOB',christening='$Person->christening',death='$Person->death',dateCreated='$tempDateCreated', baptism='$Person->baptism' WHERE ID='$tempPersonID' <br>";
		if (!$modifyQry) { die ("modify Query failed!"); }
	}

	// print out statistics
	print "<table>";
	print "<tr><td colspan=2>Number of -</tr>";
	print "<tr><td></td><td>people records created - $numPeople</td><br>";
	print "<tr><td></td><td>marriage records created - $numMarriage</td><br>";
	print "<tr><td></td><td>christening records created - $numChristenings</td><br>";
	print "<tr><td></td><td>baptism records created - $numBaptims</td><br>";
	print "</table>";
}
else
{
	print "Could not load file.<br>";
}
