0	<?php
1	/*     File: dsp_gedXMLImport.inc  Created: 10/11/2002
2	      By Matthew A Page
3	      for Genealogy Web Project
4	*/
5	
6	// Variables to count what we process
7	$numPeople = 0;
8	$numMarriage = 0;
9	$numChristenings = 0;
10	$numBaptisms = 0;
11	
12	//  Functions to work with the XML file
13	
14	//  loop through nodes of $parent to get content
15	function get_content($parent)
16	{
17	   $nodes = $parent->children();
18	   while($node = array_shift($nodes))
19	      if ($node->type == XML_TEXT_NODE)
20	         return $node->content;
21	   return "";
22	}
23	
24	//  loop through nodes of $parent to look for the tag $name
25	//   when we find $name, call get_content to get the text
26	function find_content($parent, $name)
27	{
28	   $nodes = $parent->children();
29	   while($node = array_shift($nodes))
30	      if($node->tagname == $name)
31	      return get_content($node);
32	   return "";
33	}
34	
35	// loop through nodes of $parent until we find tag $name, return
36	//  attribute $attr
37	function find_attr($parent, $name, $attr)
38	{
39	   $nodes = $parent->children();
40	   while($node = array_shift($nodes))
41	      if($node->tagname == $name)
42	         return $node->get_attribute($attr);
43	   return "";
44	}
45	
46	//  loop through $parent until we find node $name, return that node
47	function get_node($parent, $name)
48	{
49	   $nodes=$parent->children();
50	   while($node = array_shift($nodes))
51	   {
52	      if($node->tagname == $name)
53	         return $node;
54	   }
55	   return "";
56	}
57	
58	//  Loop through each $Person in $Family and return Person->ID = $id
59	function getPerson($Family,$id)
60	{
61	   // get Person record with ID = id
62	   foreach ($Family as $Person)
63	   if ($Person->ID == $id)
64	      return $Person;
65	   return "";
66	}
67	
68	// the next three functions are for adding information to already created people
69	
70	//  find person with id=$ID and add $fid to their record as the family ID
71	//   (the family to which they belong as a child)
72	function addFamilyID(&$Peeps, $ID, $fid)
73	{
74	   for($i=0;$i<count($Peeps);$i++)
75	   {
76	      if ($Peeps[$i]->ID == $ID)
77	      {
78	         $Peeps[$i]->setFamIDChild($fid);
79	         break;
80	      }
81	   }
82	}
83	
84	//  find person with id=$ID and add $fid as the fathers ID
85	function addFatherID(&$Peeps, $ID, $fid)
86	{
87	   for($i=0;$i<count($Peeps);$i++)
88	   {
89	      if ($Peeps[$i]->ID == $ID)
90	      {
91	         $Peeps[$i]->father = $fid;
92	         break;
93	      }
94	   }
95	}
96	
97	//  find person with id=$ID and add $mid as the mothers ID
98	function addMotherID(&$Peeps, $ID, $mid)
99	{
100	   for($i=0;$i<count($Peeps);$i++)
101	   {
102	      if ($Peeps[$i]->ID == $ID)
103	      {
104	         $Peeps[$i]->mother = $mid;
105	         break;
106	      }
107	   }
108	}
109	
110	//  for testing purposes, delete the records we are about to add
111	
112	function deleteOldRecords()
113	{
114	   $genealogy = mysql_connect('localhost','genealogy','genealogy');
115	   if (!$genealogy) {die ("MySQL connection failed!");}
116	   mysql_select_db("genealogy",$genealogy);
117	   $deleteQry = mysql_query("DELETE from tblFamily where ID >= 5", $genealogy);
118	   $deleteQry = mysql_query("DELETE from tblPerson where ID >= 12", $genealogy);
119	}
120	
121	//  the month formats in the XML doc come in all varieties, this converts the 
122	//   month from a text [jan, Jan, JAN, January, JANUARY] to a numeric 1,  if 
123	//   the month is already numeric, it just returns it as is.
124	function formatMonth($month)
125	{
126	   $month = trim($month);
127	   //print $month . "<br>";
128	   if (is_int($month)) return $month;
129	   $newMonth = strtoupper(substr($month,0,3));
130	   $monthNum = '';
131	   if($newMonth)
132	   {
133	      switch ($newMonth)
134	      {
135	         case 'JAN':
136	            $monthNum = '01';
137	            break;
138	         case 'FEB':
139	            $monthNum = '02';
140	            break;
141	         case 'MAR':
142	            $monthNum = '03';
143	            break;
144	         case 'APR':
145	            $monthNum = '04';
146	            break;
147	         case 'MAY':
148	            $monthNum = '05';
149	            break;
150	         case 'JUN':
151	            $monthNum = '06';
152	            break;
153	         case 'JUL':
154	            $monthNum = '07';
155	            break;
156	         case 'AUG':
157	            $monthNum = '08';
158	            break;
159	         case 'SEP':
160	            $monthNum = '09';
161	            break;
162	         case 'OCT':
163	            $monthNum = '10';
164	            break;
165	         case 'NOV':
166	            $monthNum = '11';
167	            break;
168	         case 'DEC':
169	            $monthNum = '12';
170	            break;
171	         default:
172	            $monthNum = '';
173	      }
174	   }
175	   return $monthNum;
176	}
177	
178	// Set up our classes to store people and family information
179	class Person
180	{
181	   var $ID;
182	   var $Name;
183	   var $Gender;
184	   var $DeathStatus;
185	   var $mother;
186	   var $father;
187	   var $DOB;
188	   var $christening;
189	   var $death;
190	   var $familyIDchild;
191	   var $baptism;
192	
193	   function setFamIDChild($fid)
194	   {
195	      $this->familyIDchild = $fid;
196	   }
197	
198	   //  Might be useful to print out everything we have for someone
199	   function printPerson()
200	   {
201	      print "<br>ID = " . $this->ID . "<br>";
202	      print "Name = " . $this->Name . "<br>";
203	      print "Gender = " . $this->Gender . "<br>";
204	      print "DeathStatus = " . $this->DeathStatus . "<br>";
205	      print "mother = " . $this->mother . "<br>";
206	      print "father = " . $this->father . "<br>";
207	      print "DOB = " . $this->$DOB . "<br>";
208	      print "christening = " . $this->christening . "<br>";
209	      print "death = " . $this->death . "<br>";
210	      print "familyIDchild = " . $this->familyIDchild . "<br>";
211	      print "baptism = " . $this->baptism . "<br>";
212	   }
213	}
214	
215	class Event
216	{
217	   var $ID;               // This families ID
218	   var $husbID;         // The husband/father of this family
219	   var $wifeID;         // The wife/mother of this family
220	   var $marriageDate;   // The marriage date of the husband and wife
221	   var $divorceDate;      // The divorce date (if any)
222	
223	   //  Set given data for this family
224	   function setData($newID, $newhusbID, $newwifeID, $newmarriageDate)
225	   {
226	      $this->ID = $newID;
227	      $this->husbID = $newhusbID;
228	      $this->wifeID = $newwifeID;
229	      $this->marriageDate = $newmarriageDate;
230	   }
231	
232	   // Might be useful to print out everything we have on this marriage
233	   function printEvent()
234	   {
235	      print "<br>In marriage " . $this->ID . ", " . $this->husbID . " married " . $this->wifeID . " on " . $this->marriageDate . "<br>";
236	   }
237	}
238	
239	//  Open the XML document the person has chosen
240	$xmlDocFile = xmldocfile("includes/sample.xml");
241	if($xmlDocFile)
242	{
243	   $rootXMLFile = $xmlDocFile->root();
244	   $nodechildren = $rootXMLFile->children();
245	   $rootchildren = $rootXMLFile->children();
246	
247	   $People = array();
248	   $Family = array();
249	
250	   // delete the people we are about to add so we can start from a clean slate
251	   deleteOldRecords();
252	
253	   // First go through and pull all the individual names and the info we want
254	   foreach($rootchildren as $rootchild)
255	   {
256	      if ($rootchild->tagname == "IndividualRec")
257	      {
258	         $IndivID =  $rootchild->get_attribute("Id");
259	         $IndivName = get_node($rootchild, "IndivName");
260	         if ($IndivName)
261	         {
262	            $GivenName = find_content($IndivName,"GivenName");
263	            $MaidenName = find_content($IndivName,"MaidenName");
264	            $SurName = find_content($IndivName, "SurName");
265	            $DeathStatus = find_content($rootchild, "DeathStatus");
266	            $Gender = find_content($rootchild, "Gender");
267	            $CompleteName = trim($GivenName) . " /";
268	            if( $Gender == "F" )  $CompleteName .= trim($MaidenName) . "/"; else $CompleteName .= trim($SurName). "/";
269	            $person = new Person;
270	            $person->ID = $IndivID;
271	            $person->Name = $CompleteName;
272	            $person->Gender = $Gender;
273	            $person->DeathStatus = $DeathStatus;
274	            $person->familyIDchild = "Bite me";
275	            array_push($People,$person);
276	            $numPeople++;
277	         }
278	      }
279	
280	      if ($rootchild->tagname == "EventRec")
281	      {
282	         $EventID = $rootchild->get_attribute("Id");
283	         $EventType = $rootchild->get_attribute("Type");
284	
285	         if ($EventType == "marriage")
286	         {
287	            $EventChildren = $rootchild->children();
288	            foreach($EventChildren as $Participant)
289	            {
290	               if ($Participant->tagname == "Participant")
291	               {
292	                  $Role = find_content($Participant, "Role");
293	                  $Id = find_attr($Participant, "Link", "Ref");
294	
295	                  if ($Role == 'husband') $husbFath = $Id;
296	                  if ($Role == 'wife') $wifeMoth = $Id;
297	                  if ($Role == 'child')
298	                  {
299	                     addFamilyID($People, $Id, $EventID);
300	                     if ($husbFath) addFatherID($People, $Id, $husbFath);
301	                     if ($wifeMoth) addMotherID($People, $Id, $wifeMoth);
302	                  }
303	               }
304	            }
305	            $dateNode = get_node($rootchild,"Date");
306	            $newYear =  trim(find_content($dateNode,"Year"));
307	            $newMonth = formatMonth(trim(find_content($dateNode,"Month")));
308	            $newDay = trim(find_content($dateNode,"Day"));
309	            $EventDate = $newYear . "-" . $newMonth . "-" . $newDay;
310	            $event = new Event;
311	            $event->setData($EventID, $husbFath, $wifeMoth, $EventDate);
312	            array_push($Family,$event);
313	            $numMarriage++;
314	         }
315	
316	         if ($EventType == "christening")
317	         {
318	            $EventChildren = $rootchild->children();
319	            foreach($EventChildren as $Participant)
320	            {
321	               if ($Participant->tagname == "Participant")
322	               {
323	                  $Role = find_content($Participant, "Role");
324	                  $Id = find_attr($Participant, "Link", "Ref");
325	
326	                  //print "Participant Role = $Role ID = $Id<br>";
327	                  if ($Role == 'husband') $husbFath = $Id;
328	                  if ($Role == 'wife') $wifeMoth = $Id;
329	               }
330	            }
331	            $dateNode = get_node($rootchild,"Date");
332	            if ($dateNode)
333	            {
334	               $newYear =  trim(find_content($dateNode,"Year"));
335	               $newMonth = formatMonth(trim(find_content($dateNode,"Month")));
336	               $newDay = trim(find_content($dateNode,"Day"));
337	               $EventDate = $newYear . "-" . $newMonth . "-" . $newDay;
338	               $newEventDate = date("Y-m-d",$EventDate);
339	            }
340	            $numChristening++;
341	         }
342	
343	         if ($EventType == "baptism")
344	         {
345	            $EventChildren = $rootchild->children();
346	            foreach($EventChildren as $Participant)
347	            {
348	               if ($Participant->tagname == "Participant")
349	               {
350	                  $Role = find_content($Participant, "Role");
351	                  $Id = find_attr($Participant, "Link", "Ref");
352	
353	                  //print "Participant Role = $Role ID = $Id<br>";
354	                  if ($Role == 'baptisee') $baptisee = $Id;
355	               }
356	            }
357	            $dateNode = get_node($rootchild,"Date");
358	            if ($dateNode)
359	            {
360	               $newYear =  trim(find_content($dateNode,"Year"));
361	               $newMonth = formatMonth(trim(find_content($dateNode,"Month")));
362	               $newDay = trim(find_content($dateNode,"Day"));
363	               $EventDate = $newYear . "-" . $newMonth . "-" . $newDay;
364	               $newEventDate = date("Y-m-d",$EventDate);
365	            }
366	            $numBaptism++;
367	         }
368	      }
369	   }
370	
371	// Debug: Print out all People and Events
372	   foreach ($People as $Person)
373	   {
374	      $Person->printPerson();
375	   }
376	
377	   foreach ($Family as $event)
378	   {
379	      $event->printEvent();
380	   }
381	
382	
383	   $newIDs = array();
384	   $newEvents = array();
385	
386	   //  Insert information into Database
387	   foreach ($People as $Person)
388	   {
389	      // make two passes, one creates the person and gets their unique ID
390	      // the next adds all the rest of the data (along with the
391	      // unique id's of the parents, families and such...
392	      $insertQry = mysql_query("INSERT INTO tblPerson SET name='$Person->Name'", $genealogy);
393	      if (!$insertQry) { die ("insert Query failed!"); }
394	      // Now go back and grab the ID of the person we just created and add it to the newID array
395	      $getIDQry = mysql_query("SELECT ID FROM tblPerson WHERE name='$Person->Name'", $genealogy);
396	      if (!$getIDQry) { die ("getID Query failed!"); }
397	      $ref = mysql_fetch_row($getIDQry);
398	      //print $Person->ID . " " . $ref[0] . "<br>";
399	      $newIDs[$Person->ID] = $ref[0];
400	   }
401	
402	   // add each event with the correct ID's from the first run
403	   foreach ($Family as $Event)
404	   {
405	      $tempHusbID = $newIDs[$Event->husbID];
406	      $tempWifeID = $newIDs[$Event->wifeID];
407	      $tempDateCreated = date("Y-m-d");
408	      $insertQry = mysql_query("INSERT INTO tblFamily SET husbID='$tempHusbID',wifeID='$tempWifeID',marriageDate='$Event->marriageDate', dateCreated='$tempDateCreated'", $genealogy);
409	      if (!$insertQry) { die ("insert Query failed!"); }
410	      $getIDQry = mysql_query("SELECT ID FROM tblFamily where husbID='$tempHusbID' AND wifeID='$tempWifeID'", $genealogy);
411	      if (!$getIDQry) { die ("getID Query failed!"); }
412	      $ref = mysql_fetch_row($getIDQry);
413	      $newEvents[$Event->ID] = $ref[0];
414	   }
415	
416	   // Now go back through and add all the people data that we held off before
417	
418	   foreach ($People as $Person)
419	   {
420	      $tempFatherID = $newIDs[$Person->father];
421	      $tempMotherID = $newIDs[$Person->mother];
422	      $tempFamID = $newEvents[$Person->familyIDchild];
423	      $tempPersonID = $newIDs[$Person->ID];
424	      $tempDateCreated = date("Y-m-d");
425	
426	      $modifyQry = mysql_query("UPDATE tblPerson SET father='$tempFatherID',mother='$tempMotherID',familyIDchild='$tempFamID', gender='$Person->Gender',deceased='$Person->DeathStatus', DOB='$Person->DOB',christening='$Person->christening',death='$Person->death',dateCreated='$tempDateCreated', baptism='$Person->baptism' WHERE ID='$tempPersonID'", $genealogy);
427	      print "UPDATE tblPerson SET father='$tempFatherID',mother='$tempMotherID',familyIDchild='$tempFamID', gender='$Person->Gender',deceased='$Person->DeathStatus', DOB='$Person->DOB',christening='$Person->christening',death='$Person->death',dateCreated='$tempDateCreated', baptism='$Person->baptism' WHERE ID='$tempPersonID' <br>";
428	      if (!$modifyQry) { die ("modify Query failed!"); }
429	   }
430	
431	   // print out statistics
432	   print "<table>";
433	   print "<tr><td colspan=2>Number of -</tr>";
434	   print "<tr><td></td><td>people records created - $numPeople</td><br>";
435	   print "<tr><td></td><td>marriage records created - $numMarriage</td><br>";
436	   print "<tr><td></td><td>christening records created - $numChristenings</td><br>";
437	   print "<tr><td></td><td>baptism records created - $numBaptims</td><br>";
438	   print "</table>";
439	}
440	else
441	{
442	   print "Could not load file.<br>";
443	}
