<?php
/*
<fusedoc fuse="fbx_Switch.php">
	<responsibilities>
		I am the switch statement that handles the fuseaction, delegating work to various fuses.
	</responsibilities>
	<io>
		<in>
			<string name="$Fusebox['fuseaction']" />
			<string name="$Fusebox['circuit']" />
		</in>
	</io>	
</fusedoc>
*/

switch($Fusebox["fuseaction"]) 
{
	case "main":
		include("includes/dsp_main.inc");
		break;
	case "login":
		include("includes/dsp_login.inc");
		break;
	case "checkLogin":
		print "Checking login for $uid";
		include("queries/act_loginUser.inc");
		if ($authenticated) { header('Location: index.php?fuseaction=user.main');}
		break;
	case "loginFailed":
		include("includes/dsp_loginFailure.inc");
		break;
	case "logout":
		$authenticated = FALSE;
		include("includes/dsp_main.inc");
		break;
	case "news":
		include("includes/dsp_news.inc");
		break;
	case "statistics":
		include("includes/dsp_stats.inc");
		break;
	case "newuser":
		include("includes/dsp_newuser.inc");
		break;
	case "requestUserAccount":
		include("queries/qry_requestUserAccount.inc");
		break;
	case "search":
		include("includes/dsp_search.inc");
		break;
	case "family":
		include("includes/dsp_family.inc");
		break;
	case "users":
		include("includes/dsp_users.inc");
		break;
	case "person":
		include("includes/dsp_person.inc");
		break;
	case "help":
		include("includes/dsp_help.inc");
		break;
	case "guide":
		include("includes/dsp_guide.inc");
		break;
	case "faq":
		include("includes/dsp_faq.inc");
		break;
	case "Fusebox.defaultFuseaction":
		print "I received a fuseaction called <b>'" . $Fusebox["fuseaction"] . "'</b> that circuit <b>'" . $Fusebox["circuit"] . "'</b> handles.";
		include("includes/dsp_main.inc");
		break;
	default:
		print "I received a fuseaction called <b>'" . $Fusebox["fuseaction"] . "'</b> that circuit <b>'" . $Fusebox["circuit"] . "'</b> does not have a handler for.";
		break;
}

?>
