<?php
/*=================================================
	Project: phpGedView
	File: index.php
	Author: John Finlay
	Input Variables: $rootid
	Comments:
		Parses gedcom file and displays a pedigree tree.  Specify a $rootid to
		root the pedigree tree at a certain person with id = $rootid in the
		GEDCOM file.

	Change Log:
		5/30/02 - File Created
		6/12/02 - Fixed Netscape 6 popup div problem - Darn you netscape ;-)
					- Added ability to change the spacing between the boxes in the
					- config file.
		6/18/02 - Added user ability to specify border color on boxes
		9/24/02 - Added support for language files
===================================================*/
//global $parents;
//$parents = array();


//find_parents(8);
// -- include config file
require("config.php");
if ($view=="preview")
{
	$baseyoffset=$baseyoffset-200;
}
// -- print html header information
//print_header($lang["index_header"]);
?>

<script language="JavaScript">
// -- the following javascript functions are for the positioning and hide/show of
// -- DIV layers used in the display of the pedigree chart.
var show = false;
function MM_findObj(n, d) { //v4.01
var p,i,x;  if(!d) d=document; if((p=n.indexOf("?"))>0&&parent.frames.length) {
	d=parent.frames[n.substring(p+1)].document; n=n.substring(0,p);}
if(!(x=d[n])&&d.all) x=d.all[n]; for (i=0;!x&&i<d.forms.length;i++) x=d.forms[i][n];
for(i=0;!x&&d.layers&&i<d.layers.length;i++) x=MM_findObj(n,d.layers[i].document);
if(!x && d.getElementById) x=d.getElementById(n); return x;
}

function MM_showHideLayers() { //v6.0
var i,p,v,obj,args=MM_showHideLayers.arguments;
for (i=0; i<(args.length-2); i+=3) if ((obj=MM_findObj(args[i]))!=null) { v=args[i+2];
	if (obj.style) { obj=obj.style; v=(v=='show')?'visible':(v=='hide')?'hidden':v; }
	obj.visibility=v; }
}

	function togglechildrenbox() {
		if (show) {
			MM_showHideLayers('childbox', ' ', 'hide');
			show=false;
		}
		else {
			MM_showHideLayers('childbox', ' ', 'show');
			show=true;
		}
		return false;
	}

	arrows = new Array();
	arrows[0] = new Image();
	arrows[0].src = "images/larrow2.gif";
	arrows[1] = new Image();
	arrows[1].src = "images/rarrow2.gif";

	function swap_image(arrow, index) {
		arrowimg = document.getElementById(arrow);
		tmp = arrowimg.src;
		arrowimg.src = arrows[index].src;
		arrows[index].src = tmp;
	}

</script>

<?php
print "\n\t<h2>".$lang["gen_ped_chart"]."</h2>";
// -- open the gedcom file and read it into a string
//read_gedcom_file();

//-- if the $rootid is not already there then find the first person in the file and make him the root
if ((!isset($rootid)) || ($rootid=="")) {
	//-- allow users to overide default id in the config file.
	if (isset($PEDIGREE_ROOT_ID)) $rootid=$PEDIGREE_ROOT_ID;
	else {
		preg_match("/0 @(.*)@ INDI/", $fcontents, $match);
		$rootid = $match[1];
	}
}
// -- print the form to change the number of displayed generations
//if ($view!="preview") print "\n\t<form method=\"POST\">\n\t\t<input type=\"hidden\" name=\"rootid\" value=\"$rootid\">\n\t\t".$lang["view"]." <input type=\"text\" size=\"2\" name=\"PEDIGREE_GENERATIONS\" value=\"$PEDIGREE_GENERATIONS\"> ".$lang["generations"]."\n\t\t<input type=\"submit\" value=\"".$lang["view"]."\">\n\t\t</form>";

// -- the $treeid array will hold all of the individual ids to be displayed on the pedigree chart
// -- the id in position 0 is the root person.  The other positions are filled according to the following algorithm
// -- if an individual is at position $i then individual $i's father will occupy position ($i*2)+1 and $i's mother
// -- will occupy ($i*2)+2'
//global $parents;// = array();
$parents = array();
$treeid = array();
//print "<br> RootID = $rootid <br>";
$treeid[0]=$rootid;
// -- maximum size of the id array is 2^$PEDIGREE_GENERATIONS - 1
$PEDIGREE_GENERATIONS = 3;
$treesize = pow(2, (int)($PEDIGREE_GENERATIONS))-1;
// -- fill in the id array
for($i=0; $i<($treesize/2); $i++)
{
	//print "treeid = " . $treeid[$i];
	if ($treeid[$i])
	{
		//$famid = find_family_id($treeid[$i]);
		//if ($famid)
		//{
			//$parents = find_parents($famid);
			//$parents = find_parents($treeid[$i]);
		$userIdQry = mysql_query("SELECT father, mother FROM tblPerson where ID = '$treeid[$i]'", $genealogy);
		if (!$userIdQry) { die ("User Id Query failed!"); }
		$ref = mysql_fetch_row($userIdQry);
		$parents[0] = $ref[0];
		$parents[1] = $ref[1];
		//print " parents 0 = $parents[0], parents 1 = $parents[1]<br>";

			if ($parents)
			{
				//$treeid[($i*2)+1]=$parents["HUSB"];		// -- set father id
				//$treeid[($i*2)+2]=$parents["WIFE"];		// -- set mother id
				$treeid[($i*2)+1]=$parents[0];		// -- set father id
				$treeid[($i*2)+2]=$parents[1];		// -- set mother id
			}
		//}
		//else
		//{
			//$treeid[($i*2)+1]=false;		// -- father not found
			//$treeid[($i*2)+2]=false;		// -- mother not found
		//}
	}
	else
	{
		$treeid[($i*2)+1]=false;		// -- father not found
		$treeid[($i*2)+2]=false;		// -- mother not found
	}
}

/*	$bheight = 50;
	$byspacing = 50;
	$bwidth = 200;
	$bxspacing = 50;
*/
// -- this next section will create and position the DIV layers for the pedigree tree
$curgen = 1;			// -- variable to track which generation the algorithm is currently working on
$yoffset=1000;			// -- used to offset the position of each box as it is generated
$xoffset=1000;
$prevyoffset=0;		// -- used to track the y position of the previous box
// -- loop through all of id's in the array starting at the last and working to the first
for($i=($treesize-1); $i>=0; $i--) {
	// -- check to see if we have moved to the next generation
	if ($i < floor($treesize / (pow(2, $curgen)))) {
		$curgen++;
	}
	$prevyoffset = $yoffset;

	// -- calculate the yoffset				Position in the generation											Spacing between boxes										put child between parents
	$yoffset = $baseyoffset+(($i-pow(2, $PEDIGREE_GENERATIONS-$curgen)) * (($bheight+$byspacing) * pow(2, $curgen-1)))+((($bheight+$byspacing)/2)*pow(2,$curgen-1))+(($bheight+$byspacing) * pow(2, $curgen-1));
	// -- calculate the xoffset
	$xoffset = $basexoffset+ (($PEDIGREE_GENERATIONS - $curgen) * ($bwidth+$bxspacing));
	// -- if we are in the middle generations then we need to draw the connecting lines
	if (($curgen >2) && ($curgen < $PEDIGREE_GENERATIONS)) {
		if ($i %2 ==1) {
			print "<div id=\"line$i\" style=\"position:absolute; left:".($xoffset-1)."px; top:".($yoffset+$bheight/2)."px; \"><img src=\"images/vline.gif\" width=3 height=".($prevyoffset-$yoffset)."></div>";
		}
	}
	// -- draw the box
	print "\n\t\t<div id=\"box$i\" style=\"position:absolute; left:".$xoffset."px; top:".$yoffset."px; width:".$bwidth."px; height:".$bheight."px;  \">";
	print "\n\t\t\t<table cellspacing=0 cellpadding=0><tr><td>";
	if (($curgen >2) && ($curgen < $PEDIGREE_GENERATIONS))
	{
		print "\n\t\t\t<img src=\"images/hline.gif\" align=left hspace=0 vspace=0>";
		print "\n\t\t\t</td><td valign=top>";
	}
	print "\n\t\t\t<table bgcolor=\"$BOXFILLCOLOR\" border=1 bordercolor=\"$BOXBORDERCOLOR\" cellspacing=0 width=$bwidth height=$bheight><tr><td valign=\"top\">";
	print_pedigree_person($treeid[$i]);
	print "\n\t\t\t</td></tr></table>";
	if (($curgen==1) &&(find_family_id($treeid[$i])))
	{
		$did = 1;
		if ($i > ($treesize/2) + ($treesize/4)-1) $did++;
		print "\n\t\t\t\t</td><td><a href=\"index.php?fuseaction=main.search&PEDIGREE_GENERATIONS=$PEDIGREE_GENERATIONS&searchFor=".$treeid[$did]."\" onmouseover=\"swap_image('arrow$i',1);\" onmouseout=\"swap_image('arrow$i',1);\"><img id=\"arrow$i\" src=\"images/rarrow.gif\" border=\"0\"></a>";
	}
	print "\n\t\t\t</td></tr></table>\n\t\t</div>";
}
// -- print left arrow for decendants so that we can move down the tree
$yoffset += ($bheight / 2);
$famid = find_sfamily_id($rootid);
if ($famid) {
	print "\n\t\t<div id=\"childarrow\" style=\"position:absolute; left:0px; top:".$yoffset."px; width:10px; height:10px; \">";
	print "\n\t\t\t<a href=\"#\" onclick=\"return togglechildrenbox();\" onmouseover=\"swap_image('larrow',0);\" onmouseout=\"swap_image('larrow',0);\"><img id=\"larrow\" src=\"images/larrow.gif\" border=\"0\"></a>";
	print "\n\t\t</div>";
	$yoffset += ($bheight / 2);
	print "\n\t\t<div id=\"childbox\" style=\"position: absolute; left:".$xoffset."px; top:".$yoffset."px; width:".$bwidth."px; height:".$bheight."px; visibility: hidden;\">";
	print "\n\t\t\t<table bgcolor=\"$BOXFILLCOLOR\" border=1 bordercolor=\"$BOXBORDERCOLOR\" cellspacing=0 width=$bwidth height=$bheight><tr><td>";
	//$famrec = find_family_record($famid);
	//if ($famrec) {
		$num = preg_match_all("/1\s*CHIL\s*@(.*)@/", $famrec, $smatch,PREG_SET_ORDER);
		$num = 2;

		//$genealogy = mysql_pconnect('localhost','genealogy','genealogy');
		//if (!$genealogy) {die ("MySQL connection failed!");}
		//mysql_select_db("genealogy",$genealogy);

	$nameQry = mysql_query("SELECT ID, name FROM tblPerson WHERE mother = '$rootid' or father = '$rootid'", $genealogy);
		if (!$nameQry) { die ("User name Query failed!"); }
		//$ref = mysql_fetch_row($nameQry);
	//$name = $ref[0];
				$ref = mysql_fetch_row($nameQry);
		//for($i=0; $i<$num; $i++)

		if ($ref) print "Children:<br>";
		while ($ref)
		{
			//$pid = $smatch[$i][1];
			$pid = $ref[0];
			$name = $ref[1];
			print "\n\t\t\t\t&nbsp&nbsp&nbsp<a href=\"index.php?fuseaction=main.search&PEDIGREE_GENERATIONS=$PEDIGREE_GENERATIONS&searchFor=$pid\"><font class=\"name\"> ";
			//$name = get_person_name($rootid);
			//$name = rtrim($name);
			print $name;
			print "<br></font></a>";
			$ref = mysql_fetch_row($nameQry);
		}
	//}
	print "\n\t\t\t</td></tr></table>";
	print "\n\t\t</div>";
}
// -- print html footer
$yoffset = ($yoffset*2)-(2*$baseyoffset)+100;
print "\n\t\t<div id=\"footerbox\" style=\"position:absolute; left:0px; top:".$yoffset."px; width:100%;  \">";
$without_close=true;
//print_footer();
print "\n\t</div>\n</body>\n</html>";


?>
