#!/usr/bin/perl
# Setup for cookies and MySQL access
  use CGI;
  use DBI;
  use CGI::Carp  qw( fatalsToBrowser );
  $query=new CGI;
  my $db_handler=DBI->connect("DBI:mysql:test:localhost","mysql","");

#Main
  print $query->header;
  &PrintHeadings;
  if ($query->cookie('Admin'))
    {
      print $query->start_html(-title=>"Admin Tools--Add New Member Account");
      $AdminNo=$query->cookie('Admin');

      #Retrieve and process cgi information
      $action=$query->param('action');
      if ($action eq "Add")
        {
          &InitializeCgiData;
          $action="Insert";
          &PrintGetMemberInfo;
        }
      elsif ($action eq "Insert")
        {
          $error=0;
          &GetMemberCgiData;
          &ValidateMemberCgiData;
          if ($error==0)
            {
              &InsertMemberCgiData;
              if ($error==0)
                {
                  &PrintComplete;
                }
            }
        }
      elsif ($action eq "Edit")
        {
          &SelectMemberCgiData;
          $action="Update";
          &PrintGetMemberInfo;
        }
      elsif ($action eq "Update")
        {
          $error=0;
          &GetMemberCgiData;
          &ValidateMemberCgiData;
          if ($error==0)
            {
              &UpdateMemberCgiData;
              if ($error==0)
                {
                  &PrintComplete;
                }
            }
        }
      else
        {
          #This should never occur unless someone is running their own buggy cgi
          &PrintInvalidActionError;
        }
    }
  else
    {
      &PrintNotAuthorized;
    }
  &PrintClosingTags;
  $db_handler->disconnect;
        
sub PrintHeadings
  {
    print "<HTML>\n";
    print "  <HEAD>\n";
    print "    <TITLE>\n";
    print "      Admin Tools--Add New Member\n";
    print "    </TITLE>\n";
    print "  </HEAD>\n";
    print "  <BODY BACKGROUND=\"/AdminTools/stone.gif\">\n";
    print "    <DIV ALIGN=\"CENTER\">\n";
    print "      <IMG SRC=\"/AdminTools/Logo.gif\" WIDTH=\"384\" HEIGHT=\"54\">\n";
    print "      <BR>\n";
    print "      <HR WIDTH=\"93%\" COLOR=\"GRAY\">\n";
    print "      <BR>\n";
    print "      <BR>\n";
    print "      <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=4>\n";
  }
 
sub InitializeCgiData
  {
    #Set the CGI variables used by the program
    $FirstName="";
    $LastName="";
    $Plain="";
    $Email="";
    $CertNo="";
    $Street="";
    $City="";
    $State="";
    $Zip="";
    $HomePhone="";
    $WorkPhone="";
    $CellPhone="";
    $Pager="";
    $CertType="None";
    $Airplane="";
    $Glider="";
    $Rotorcraft="";
    $LTA="";
    $SingleEngine="";
    $MultiEngine="";
    $Land="";
    $Sea="";
    $Instrument="";
    $HP="";
    $Complex="";
    $Tailwheel="";
    $TotalTime=0;
  }

sub SelectMemberCgiData
  {
    #Retrieve Member Data
    $MemberNo=$query->param('MemberNo');
    $sql="Select FirstName, LastName, EMail, CertNo, Street, City, State, Zip, HomePhone, WorkPhone, CellPhone, Pager from Members where (MemberNo=$MemberNo)";
    &OpenDBHandle;
    ($FirstName, $LastName, $Email, $CertNo, $Street, $City, $State, $Zip, $HomePhone, $WorkPhone, $CellPhone, $Pager)=$statement_handler->fetchrow();
    $Plain="";
    $statement_handler->finish;
 
    #Retrieve Certificate Data
    if ($CertNo > 0)
      {
        $sql="Select CertType, Airplane, Glider, Rotorcraft, LTA, SingleEngine, MultiEngine, Land, Sea, Instrument, HP, Complex, Tailwheel, TotalTime from PilotCert where (CertNo=\"$CertNo\")";
        &OpenDBHandle;
        ($CertType, $Airplane, $Glider, $Rotorcraft, $LTA, $SingleEngine, $MultiEngine, $Land, $Sea, $Instrument, $HP, $Complex, $Tailwheel, $TotalTime)=$statement_handler->fetchrow();
        $statement_handler->finish;
        
        $Airplane=&DB2String($Airplane);
        $Glider=&DB2String($Glider);
        $Rotorcraft=&DB2String($Rotorcraft);
        $LTA=&DB2String($LTA);
        $SingleEngine=&DB2String($SingleEngine);
        $MultiEngine=&DB2String($MultiEngine);
        $Land=&DB2String($Land);
        $Sea=&DB2String($Sea);
        $Instrument=&DB2String($Instrument);
        $HP=&DB2String($HP);
        $Complex=&DB2String($Complex);
        $Tailwheel=&DB2String($Tailwheel);
      }
    else
      {
        $CertType="None";
        $Airplane="";
        $Glider="";
        $Rotorcraft="";
        $LTA="";
        $SingleEngine="";
        $MultiEngine="";
        $Land="";
        $Sea="";
        $Instrument="";
        $HP="";
        $Complex="";
        $Tailwheel="";
        $TotalTime=0;
      }
  }

sub DB2String
  {
    if ($_[0]==1)
      {
        return("CHECKED");
      }
    else
      {
        return("");
      }
  }

sub PrintGetMemberInfo
  {
    print "        Membership Application:<BR>\n";
    print "      </FONT>\n";
    print "      <TABLE BORDER=1 CELLSPACING=0 WIDTH=75% CELLPADDING=4>\n";
    print "        <TR>\n";
    print "          <TD ALIGN=\"CENTER\">\n";
    print "            <FORM ACTION=\"/cgi-bin/AdminTools/AddEditMember.pl\" METHOD=\"post\">\n";
    print "              <TABLE BORDER=0 WIDTH=95%>\n";
    print "                <TR>\n";
    print "                  <TD>\n";
    print "                    <FONT FACE=\"Tahoma\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                      <B>\n";
    print "                        Name:\n";
    print "                      </B>\n";
    print "                    </FONT>\n";
    print "                    <TABLE BORDER=1 CELLSPACING=0 WIDTH=\"100%\">\n";
    print "                      <TR>\n";
    print "                        <TD>\n";
    print "                          <FONT FACE=\"Tahoma\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                            <B>\n";
    print "                              First Name:\n";
    print "                            </B>\n";
    print "                          </FONT>\n";
    print "                        </TD>\n";
    print "                        <TD>\n";
    print "                          <FONT FACE=\"Tahoma\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                            <B>\n";
    print "                              Last Name:\n";
    print "                            </B>\n";
    print "                          </FONT>\n";
    print "                        </TD>\n";
    print "                      </TR>\n";
    print "                      <TR>\n";
    print "                        <TD>\n";
    print "                          <INPUT TYPE=\"text\" NAME=\"FirstName\" SIZE=20 MAXLENGTH=20 VALUE=\"$FirstName\">\n";
    print "                        </TD>\n";
    print "                        <TD>\n";
    print "                          <INPUT TYPE=\"text\" NAME=\"LastName\" SIZE=20 MAXLENGTH=20 VALUE=\"$LastName\">\n";
    print "                        </TD>\n";
    print "                      </TR>\n";
    print "                    </TABLE>\n";
    print "                  </TD>\n";
    print "                  <TD ALIGN=\"CENTER\">\n";
    print "                    <BR>\n";
    print "                    <TABLE BORDER=1 CELLSPACING=0 WIDTH=\"100%\">\n";
    print "                      <TR>\n";
    print "                        <TD>\n";
    print "                          <FONT FACE=\"Tahoma\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                            <B>\n";
    print "                              Password:\n";
    print "                            </B>\n";
    print "                          </FONT>\n";
    print "                        </TD>\n";
    print "                      </TR>\n";
    print "                      <TR>\n";
    print "                        <TD>\n";
    print "                          <INPUT TYPE=\"password\" NAME=\"Password\" SIZE=20 MAXLENGTH=20 VALUE=\"$Plain\">\n";
    print "                        </TD>\n";
    print "                      </TR>\n";
    print "                    </TABLE>\n";
    print "                  </TD>\n";
    print "                  <TD ALIGN=\"RIGHT\">\n";
    print "                    <BR>\n";
    print "                    <TABLE BORDER=1 CELLSPACING=0 WIDTH=\"100%\">\n";
    print "                      <TR>\n";
    print "                        <TD>\n";
    print "                          <FONT FACE=\"Tahoma\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                            E-Mail Address:\n";
    print "                          </FONT>\n";
    print "                        </TD>\n";
    print "                      </TR>\n";
    print "                      <TR>\n";
    print "                        <TD>\n";
    print "                          <INPUT TYPE=\"text\" NAME=\"E-mail\" SIZE=35 MAXLENGTH=50 VALUE=\"$Email\">\n";
    print "                        </TD>\n";
    print "                      </TR>\n";
    print "                    </TABLE>\n";
    print "                  </TD>\n";
    print "                </TR>\n";
    print "                <TR>\n";
    print "                </TR>\n";
    print "                <TR>\n";
    print "                  <TD COLSPAN=2>\n";
    print "                    <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                      Address:\n";
    print "                    </FONT>\n";
    print "                    <TABLE BORDER=1 CELLSPACING=0 WIDTH=\"100%\">\n";
    print "                      <TR>\n";
    print "                        <TD>\n";
    print "                          <FONT FACE=\"Tahoma\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                            Street:\n";
    print "                          </FONT>\n";
    print "                        </TD>\n";
    print "                        <TD>\n";
    print "                          <INPUT TYPE=\"text\" NAME=\"Street\" SIZE=30 MAXLENGTH=30 VALUE=\"$Street\">\n";
    print "                        </TD>\n";
    print "                      </TR>\n";
    print "                      <TR>\n";
    print "                        <TD>\n";
    print "                          <FONT FACE=\"Tahoma\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                            City:\n";
    print "                          </FONT>\n";
    print "                        </TD>\n";
    print "                        <TD>\n";
    print "                          <INPUT TYPE=\"text\" NAME=\"City\" SIZE=30 MAXLENGTH=30 VALUE=\"$City\">\n";
    print "                        </TD>\n";
    print "                        <TD>\n";
    print "                          <FONT FACE=\"Tahoma\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                            State:\n";
    print "                          </FONT>\n";
    print "                        </TD>\n";
    print "                        <TD>\n";
    print "                          <SELECT NAME=\"State\">\n";
    if ($State ne "")
      {
        print "                            <OPTION VALUE=\"$State\">$State\n";
      }
    print "                            <OPTION VALUE=\"AL\">Alabama\n";
    print "                            <OPTION VALUE=\"AK\">Alaska\n";
    print "                            <OPTION VALUE=\"AZ\">Arizona\n";
    print "                            <OPTION VALUE=\"AR\">Arkansas\n";
    print "                            <OPTION VALUE=\"CA\">California\n";
    print "                            <OPTION VALUE=\"CO\">Colorado\n";
    print "                            <OPTION VALUE=\"CT\">Connecticut\n";
    print "                            <OPTION VALUE=\"DE\">Delaware\n";
    print "                            <OPTION VALUE=\"DC\">Washington, D.C.\n";
    print "                            <OPTION VALUE=\"FL\">Florida\n";
    print "                            <OPTION VALUE=\"GA\">Georgia\n";
    print "                            <OPTION VALUE=\"HI\">Hawaii\n";
    print "                            <OPTION VALUE=\"ID\">Idaho\n";
    print "                            <OPTION VALUE=\"IL\">Illinois\n";
    print "                            <OPTION VALUE=\"IN\">Indiana\n";
    print "                            <OPTION VALUE=\"IA\">Iowa\n";
    print "                            <OPTION VALUE=\"KS\">Kansas\n";
    print "                            <OPTION VALUE=\"KY\">Kentucky\n";
    print "                            <OPTION VALUE=\"LA\">Louisiana\n";
    print "                            <OPTION VALUE=\"ME\">Maine\n";
    print "                            <OPTION VALUE=\"MD\">Maryland\n";
    print "                            <OPTION VALUE=\"MA\">Massachusetts\n";
    print "                            <OPTION VALUE=\"MI\">Michigan\n";
    print "                            <OPTION VALUE=\"MN\">Minnesota\n";
    print "                            <OPTION VALUE=\"MS\">Mississippi\n";
    print "                            <OPTION VALUE=\"MO\">Missouri\n";
    print "                            <OPTION VALUE=\"MT\">Montana\n";
    print "                            <OPTION VALUE=\"NE\">Nebraska\n";
    print "                            <OPTION VALUE=\"NV\">Nevada\n";
    print "                            <OPTION VALUE=\"NH\">New Hampshire\n";
    print "                            <OPTION VALUE=\"NJ\">New Jersey\n";
    print "                            <OPTION VALUE=\"NM\">New Mexico\n";
    print "                            <OPTION VALUE=\"NY\">New York\n";
    print "                            <OPTION VALUE=\"NC\">North Carolina\n";
    print "                            <OPTION VALUE=\"ND\">North Dakota\n";
    print "                            <OPTION VALUE=\"OH\">Ohio\n";
    print "                            <OPTION VALUE=\"OK\">Oklahoma\n";
    print "                            <OPTION VALUE=\"OR\">Oregon\n";
    print "                            <OPTION VALUE=\"PA\">Pennsylvania\n";
    print "                            <OPTION VALUE=\"RI\">Rhode Island\n";
    print "                            <OPTION VALUE=\"SC\">South Carolina\n";
    print "                            <OPTION VALUE=\"SD\">South Dakota\n";
    print "                            <OPTION VALUE=\"TN\">Tennessee\n";
    print "                            <OPTION VALUE=\"TX\">Texas\n";
    print "                            <OPTION VALUE=\"UT\">Utah\n";
    print "                            <OPTION VALUE=\"VT\">Vermont\n";
    print "                            <OPTION VALUE=\"VA\">Virginia\n";
    print "                            <OPTION VALUE=\"WA\">Washington\n";
    print "                            <OPTION VALUE=\"WV\">West Virginia\n";
    print "                            <OPTION VALUE=\"WI\">Wisconsin\n";
    print "                            <OPTION VALUE=\"WY\">Wyoming\n";
    print "                          </SELECT>\n";
    print "                        </TD>\n";
    print "                        <TD>\n";
    print "                          <FONT FACE=\"Tahoma\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                            Zip:\n";
    print "                          </FONT>\n";
    print "                        </TD>\n";
    print "                        <TD>\n";
    print "                          <INPUT TYPE=\"text\" NAME=\"Zip\" SIZE=5 MAXLENGTH=5 VALUE=\"$Zip\">\n";
    print "                        </TD>\n";
    print "                      </TR>\n";
    print "                    </TABLE>\n";
    print "                  </TD>\n";
    print "                  <TD>\n";
    print "                    <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                      Phone:\n";
    print "                    </FONT>\n";
    print "                    <TABLE BORDER=1 CELLSPACING=0 WIDTH=\"100%\">\n";
    print "                      <TR>\n";
    print "                        <TD>\n";
    print "                          <FONT FACE=\"Tahoma\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                            Home:\n";
    print "                          </FONT>\n";
    print "                        </TD>\n";
    print "                        <TD>\n";
    print "                          <INPUT TYPE=\"text\" NAME=\"HomePhone\" SIZE=10 MAXLENGTH=10 VALUE=\"$HomePhone\">\n";
    print "                        </TD>\n";
    print "                        <TD>\n";
    print "                          <FONT FACE=\"Tahoma\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                            Work:\n";
    print "                          </FONT>\n";
    print "                        </TD>\n";
    print "                        <TD>\n";
    print "                          <INPUT TYPE=\"text\" NAME=\"WorkPhone\" SIZE=10 MAXLENGTH=10 VALUE=\"$WorkPhone\">\n";
    print "                        </TD>\n";
    print "                      </TR>\n";
    print "                      <TR>\n";
    print "                        <TD>\n";
    print "                          <FONT FACE=\"Tahoma\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                            Cell:\n";
    print "                          </FONT>\n";
    print "                        </TD>\n";
    print "                        <TD>\n";
    print "                          <INPUT TYPE=\"text\" NAME=\"CellPhone\" SIZE=10 MAXLENGTH=10 VALUE=\"$CellPhone\">\n";
    print "                        </TD>\n";
    print "                        <TD>\n";
    print "                          <FONT FACE=\"Tahoma\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                            Pager:\n";
    print "                          </FONT>\n";
    print "                        </TD>\n";
    print "                        <TD>\n";
    print "                          <INPUT TYPE=\"text\" NAME=\"Pager\" SIZE=10 MAXLENGTH=10 VALUE=\"$Pager\">\n";
    print "                        </TD>\n";
    print "                      </TR>\n";
    print "                    </TABLE>\n";
    print "                  </TD>\n";
    print "                </TR>\n";
    print "              </TABLE>\n";
    print "              <BR>\n";
    print "              <TABLE BORDER=0 WIDTH=100%>\n";
    print "                <TR>\n";
    print "                  <TD>\n";
    print "                    <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                      <B>\n";
    print "                        Certificate:\n";
    print "                      </B>\n";
    print "                      <BR>\n";
    print "                    </FONT>\n";
    print "                    <TABLE BORDER=1 CELLSPACING=0 WIDTH=\"100%\">\n";
    print "                      <TR>\n";
    print "                        <TD>\n";
    print "                          <FONT FACE=\"Tahoma\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                            <B>\n";
    print "                              Certificate Number:\n";
    print "                            </B>\n";
    print "                          </FONT>\n";
    print "                        </TD>\n";
    print "                      </TR>\n";
    print "                      <TR>\n";
    print "                        <TD>\n";
    print "                          <INPUT TYPE=\"text\" NAME=\"CertNo\" SIZE=9 MAXLENGTH=9 VALUE=\"$CertNo\">\n";
    print "                          <FONT FACE=\"Tahoma\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                            (zero for none)\n";
    print "                          </FONT>\n";
    print "                        </TD>\n";
    print "                      </TR>\n";
    print "                      <TR>\n";
    print "                        <TD>\n";
    print "                          <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                            <B>\n";
    print "                              Type:\n";
    print "                            </B>\n";
    print "                          </FONT>\n";
    print "                        </TD>\n";
    print "                      </TR>\n";
    print "                      <TR>\n";
    print "                        <TD>\n";
    print "                          <SELECT NAME=\"CertType\">\n";
    if ($CertType ne "")
      {
        print "                            <OPTION VALUE=\"$CertType\">$CertType\n";
      }
    print "                            <OPTION VALUE=\"None\">None\n";
    print "                            <OPTION VALUE=\"Student\">Student\n";
    print "                            <OPTION VALUE=\"Recreational\">Recreational\n";
    print "                            <OPTION VALUE=\"Private\">Private\n";
    print "                            <OPTION VALUE=\"Commercial\">Commercial\n";
    print "                            <OPTION VALUE=\"CFI\">CFI/CFII\n";
    print "                            <OPTION VALUE=\"ATP\">ATP\n";
    print "                          </SELECT>\n";
    print "                        </TD>\n";
    print "                      </TR>\n";
    print "                    </TABLE>\n";
    print "                  </TD>\n";
    print "                  <TD VALIGN=\"TOP\">\n";
    print "                    <FONT FACE=\"Tahoma\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                      Categories:\n";
    print "                      <BR>\n";
    print "                    </FONT>\n";
    print "                    <TABLE BORDER=1 CELLSPACING=0 WIDTH=\"100%\">\n"; 
    print "                      <TR>\n";
    print "                        <TD>\n";
    print "                          <FONT FACE=\"Tahoma\" COLOR=\"NAVY\" SIZE=2>\n";
                                       #The checkboxes use an unconventional method of setting the default
                                       #value.  The "CHECKED" attribute signifies that the checkbox should,
                                       #by default, be checked.  If the checkbox should not be checked, then
                                       #the "CHECKED" attribute should be omitted.  By setting the
                                       #appropriate variable ($Airplane, $Glider, etc.) to either "" (for
                                       #unchecked) or "CHECKED" (for checked), the Perl script generates a
                                       #checkbox with either a default unchecked, or a default checked
                                       #value, as defined by the variable.
    print "                            <INPUT TYPE=\"checkbox\" NAME=\"Airplane\" VALUE=1 $Airplane>Airplane\n";
    print "                            <BR>\n";
    print "                            <INPUT TYPE=\"checkbox\" NAME=\"Glider\" VALUE=1 $Glider>Glider\n";
    print "                            <BR>\n";
    print "                            <INPUT TYPE=\"checkbox\" NAME=\"Rotorcraft\" VALUE=1 $Rotorcraft>Rotorcraft\n";
    print "                            <BR>\n";
    print "                            <INPUT TYPE=\"checkbox\" NAME=\"LTA\" VALUE=1 $LTA>Lighter-Than-Air\n";
    print "                          </FONT>\n";
    print "                        </TD>\n";
    print "                      </TR>\n";
    print "                    </TABLE>\n";
    print "                  </TD>\n";
    print "                  <TD VALIGN=\"TOP\">\n";
    print "                    <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                      Ratings:\n";
    print "                      <BR>\n";
    print "                    </FONT>\n";
    print "                    <TABLE BORDER=1 CELLSPACING=0 WIDTH=\"100%\">\n";
    print "                      <TR>\n";
    print "                        <TD>\n";
    print "                          <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                            <INPUT TYPE=\"checkbox\" NAME=\"SingleEngine\" VALUE=1 $SingleEngine>Single-Engine\n";
    print "                            <BR>\n";
    print "                            <INPUT TYPE=\"checkbox\" NAME=\"MultiEngine\" VALUE=1 $MultiEngine>Multi-Engine\n";
    print "                            <BR>\n";
    print "                            <INPUT TYPE=\"checkbox\" NAME=\"Land\" VALUE=1 $Land>Land\n";
    print "                            <BR>\n";
    print "                            <INPUT TYPE=\"checkbox\" NAME=\"Sea\" VALUE=1 $Sea>Sea\n";
    print "                            <BR>\n";
    print "                            <INPUT TYPE=\"checkbox\" NAME=\"Instrument\" VALUE=1 $Instrument>Instrument\n";
    print "                          </FONT>\n";
    print "                        </TD>\n";
    print "                      </TR>\n";
    print "                    </TABLE>\n";
    print "                  </TD>\n";
    print "                  <TD VALIGN=\"TOP\">\n";
    print "                    <FONT FACE=\"Tahoma\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                      Endorsements:\n";
    print "                      <BR>\n";
    print "                    </FONT>\n";
    print "                    <TABLE BORDER=1 CELLSPACING=0 WIDTH=\"100%\">\n";
    print "                      <TR>\n";
    print "                        <TD>\n";
    print "                          <FONT FACE=\"Tahoma\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                            <INPUT TYPE=\"checkbox\" NAME=\"HP\" VALUE=1 $HP>High-Performance\n";
    print "                            <BR>\n";
    print "                            <INPUT TYPE=\"checkbox\" NAME=\"Complex\" VALUE=1 $Complex>Complex\n";
    print "                            <BR>\n";
    print "                            <INPUT TYPE=\"checkbox\" NAME=\"Tailwheel\" VALUE=1 $Tailwheel>Tailwheel\n";
    print "                          </FONT>\n";
    print "                        </TD>\n";
    print "                      </TR>\n";
    print "                    </TABLE>\n";
    print "                  </TD>\n";
    print "                  <TD VALIGN=\"TOP\">\n";
    print "                    <FONT FACE=\"Tahoma\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                      Total Time:\n";
    print "                    </FONT>\n";
    print "                    <TABLE BORDER=1 CELLSPACING=0 WIDTH=\"100%\">\n";
    print "                      <TR>\n";
    print "                        <TD>\n";
    print "                          <INPUT TYPE=\"text\" NAME=\"TotalTime\" SIZE=6 MAXLENGTH=6 VALUE=$TotalTime>\n";
    print "                        </TD>\n";
    print "                      </TR>\n";
    print "                    </TABLE>\n";
    print "                  </TD>\n";
    print "                </TR>\n";
    print "                <TR>\n";
    print "                  <TD>\n";
    print "                    <FONT FACE=\"Tahoma\" COLOR=\"NAVY\" SIZE=1>\n";
    print "                      Items in\n";
    print "                      <B>\n";
    print "                        bold face\n";
    print "                      </B>\n";
    print "                      are required.\n";
    print "                    </FONT>\n";
    print "                  </TD>\n";
    print "                  <TD>\n";
    print "                  </TD>\n";
    print "                  <TD>\n";
    print "                  </TD>\n";
    print "                  <TD ALIGN=\"RIGHT\" COLSPAN=2>\n";
    print "                    <INPUT TYPE=\"reset\" NAME=\"reset\">\n";
    print "                    <INPUT TYPE=\"submit\" NAME=\"submit\">\n";
    print "                    <INPUT TYPE=\"hidden\" NAME=\"action\" VALUE=\"$action\">\n";
    print "                  </TD>\n";
    print "                </TR>\n";
    print "                <TR>\n";
    print "                </TR>\n";
    print "              </TABLE>\n";
    print "            </FORM>\n";
    print "          </TD>\n";
    print "        </TR>\n";
    print "      </TABLE>\n";
  }

sub GetMemberCgiData
  {
    #Get the information created by the PrintGetMemberInfo subroutine
    $FirstName=$query->param('FirstName');
    $LastName=$query->param('LastName');
    $Plain=$query->param('Password');
    $Email=$query->param('Email');
    $CertNo=$query->param('CertNo');
    $Street=$query->param('Street');
    $City=$query->param('City');
    $State=$query->param('State');
    $Zip=$query->param('Zip');
    $HomePhone=$query->param('HomePhone');
    $WorkPhone=$query->param('WorkPhone');
    $CellPhone=$query->param('CellPhone');
    $Pager=$query->param('Pager');
    $CertType=$query->param('CertType');
    $Airplane=$query->param('Airplane');
    $Glider=$query->param('Glider');
    $Rotorcraft=$query->param('Rotorcraft');
    $LTA=$query->param('LTA');
    $SingleEngine=$query->param('SingleEngine');
    $MultiEngine=$query->param('MultiEngine');
    $Land=$query->param('Land');
    $Sea=$query->param('Sea');
    $Instrument=$query->param('Instrument');
    $HP=$query->param('HP');
    $Complex=$query->param('Complex');
    $Tailwheel=$query->param('Tailwheel');
    $TotalTime=$query->param('TotalTime');
  }

sub ValidateMemberCgiData
  {
    #Validation Routines
    if ($Airplane eq "")
      {
        $Airplane = 0;
      }
    if ($Glider eq "")
      {
        $Glider = 0;
      }
    if ($Rotorcraft eq "")
      {
        $Rotorcraft = 0;
      }
    if ($LTA eq "")
      {
        $LTA = 0;
      }
    if ($SingleEngine eq "")
      {
        $SingleEngine = 0;
      }
    if ($MultiEngine eq "")
      {
        $MultiEngine = 0;
      }
    if ($Land eq "")
      {
        $Land = 0;
      }
    if ($Sea eq "")
      {
        $Sea = 0;
      }
    if ($Instrument eq "")
      {
        $Instrument = 0;
      }
    if ($HP eq "")
      {
        $HP = 0;
      }
    if ($Complex eq "")
      {
        $Complex = 0;
      }
    if ($Tailwheel eq "")
      {
        $Tailwheel = 0;
      }
    if ($TotalTime eq "")
      {
        $TotalTime = 0;
      }
  }

sub InsertMemberCgiData
  {
    #Inserts data retrieved by GetMemberCgiData into the database

    #Verify that the user does not already exist in the database...
    $error=0;
    $sql="Select MemberNo from Members where ((LastName=\"$LastName\") and (FirstName=\"$FirstName\"))";
    &OpenDBHandle;
    ($error)=$statement_handler->fetchrow();
    $statement_handler->finish;
 
    if ($error==0)
      {
        #...encrypt the password...
        chomp($Plain);
        chomp($UserName="$FirstName $LastName");
        $Encrypt=crypt($Plain, $UserName);

        #...and insert the data into the database
        $sql="Insert into Members values (null, \"$Email\", \"$LastName\", \"$FirstName\", \"$CertNo\", \"$Street\", \"$City\", \"$State\", \"$Zip\", \"$HomePhone\", \"$WorkPhone\", \"$CellPhone\", \"$Pager\", \"1\", \"$Encrypt\")";
        &OpenDBHandle;
        $statement_handler=$db_handler->prepare($sql);
        $statement_handler->finish; 
        #Verify that the certificate number does not already exist in the database...
        if ($CertNo > 0)
          {
            $error=0;
            $sql="Select CertNo from PilotCert where (CertNo=\"$CertNo\")";
            &OpenDBHandle;
            ($error)=$statement_handler->fetchrow();
            $statement_handler->finish;

            if ($error==0)
              {
                $sql="Insert into PilotCert values (\"$CertNo\", \"$CertType\", $Airplane, $Glider, $Rotorcraft, $LTA, $SingleEngine, $MultiEngine, $Land, $Sea, $Instrument, $HP, $Complex, $Tailwheel, $TotalTime)";
                &OpenDBHandle;
                $statement_handler=$db_handler->prepare($sql);
                $statement_handler->finish;
              }
            else
              {
                print "        Pilot Certificate Number $CertNo already exists in the database...skipping.\n";
                print "        <BR>\n";
                print "        <BR>\n";
                print "      </FONT>\n";
              }
          }
      }
    else
      {
        #...and print an error message, because 1) the user or 2) the Pilot Certificate # already exists.
        $sql="Update Members set CertNo=\"0\" where ((LastName=\"$LastName\") and (FirstName=\"$FirstName\"))";
        &OpenDBHandle;
        $statement_handler=$db_handler->prepare($sql);
        $statement_handler->finish;
        print "        Error--Either $FirstName $LastName or Pilot Certificate Number $CertNo already exists in the database!\n";
        print "        <BR>\n";
        print "        <BR>\n";
        print "        Return to \n";
        print "        <A HREF=\"/cgi-bin/AdminTools/Home.pl\">\n";
        print "          Admin Tools main menu\n";
        print "        </A>\n";
        print "        <BR>\n";
        print "        or\n";
        print "        <BR>\n";
        print "        <A HREF=\"/cgi-bin/AdminTools/ManageMembers.pl\">\n";
        print "          Member Management menu.\n";
        print "        </A>\n";
        print "      </FONT>\n";
      }
  }
 
sub UpdateMemberCgiData
  {
    #Updates data retrieved by GetMemberCgiData in the database

    #Verify that the user already exists in the database...
    $error=0;
    $MemberNo="";
    $sql="Select MemberNo from Members where ((LastName=\"$LastName\") and (FirstName=\"$FirstName\"))";
    &OpenDBHandle;
    ($MemberNo)=$statement_handler->fetchrow();
    $statement_handler->finish;
    if ($MemberNo=="")
      {
        $error=1;
      }
 
    if ($error==0)
      {
        #...and update the data in the database
        if ($Plain eq "")
          {
            $sql="Update Members set EMail=\"$Email\", LastName=\"$LastName\", FirstName=\"$FirstName\", CertNo=\"$CertNo\", Street=\"$Street\", City=\"$City\", State=\"$State\", Zip=\"$Zip\", HomePhone=\"$HomePhone\", WorkPhone=\"$WorkPhone\", CellPhone=\"$CellPhone\", Pager=\"$Pager\" where (MemberNo=$MemberNo)";
          }
        else
          {
            #Encrypt the password
            chomp($Plain);
            chomp($UserName="$FirstName $LastName");
            $Encrypt=crypt($Plain, $UserName);

            $sql="Update Members set EMail=\"$Email\", LastName=\"$LastName\", FirstName=\"$FirstName\", CertNo=\"$CertNo\", Street=\"$Street\", City=\"$City\", State=\"$State\", Zip=\"$Zip\", HomePhone=\"$HomePhone\", WorkPhone=\"$WorkPhone\", CellPhone=\"$CellPhone\", Pager=\"$Pager\", Pass=\"$Encrypt\" where (MemberNo=$MemberNo)";
          }
        &OpenDBHandle;
        $statement_handler=$db_handler->prepare($sql);
        $statement_handler->finish; 
        #Update the certificate if the number already exists in the database or insert it if it doesn't
        if ($CertNo > 0)
          {
            $error=0;
            $sql="Select CertNo from PilotCert where (CertNo=\"$CertNo\")";
            &OpenDBHandle;
            ($error)=$statement_handler->fetchrow();
            $statement_handler->finish;

            if ($error==0)
              {
                $sql="Insert into PilotCert values (\"$CertNo\", \"$CertType\", $Airplane, $Glider, $Rotorcraft, $LTA, $SingleEngine, $MultiEngine, $Land, $Sea, $Instrument, $HP, $Complex, $Tailwheel, $TotalTime)";
                &OpenDBHandle;
                $statement_handler=$db_handler->prepare($sql);
                $statement_handler->finish;
              }
            else
              {
                $sql="Update PilotCert set CertType=\"$CertType\", Airplane=$Airplane, Glider=$Glider, Rotorcraft=$Rotorcraft, LTA=$LTA, SingleEngine=$SingleEngine, MultiEngine=$MultiEngine, Land=$Land, Sea=$Sea, Instrument=$Instrument, HP=$HP, Complex=$Complex, Tailwheel=$Tailwheel, TotalTime=$TotalTime where CertNo=\"$CertNo\"";
              }
            &OpenDBHandle;
            $statement_handler=$db_handler->prepare($sql);
            $statement_handler->finish;
          }
        #$error is modified several times above.  If the script has gotten this far, everything is ok.  
        $error=0;
      }
    else
      {
        #...and print an error message, because the user does not exist in the database (shouldn't happen).
        print "        Error--Cannot find Member Number $MemberNo in the database!\n";
        print "        <BR>\n";
        print "        <BR>\n";
        print "      </FONT>\n";
        $error=1;
      }
  }
 

sub PrintComplete
  {
    #Addition/modification of the new user has been completed.  Inform the Administrator.
    print "        Database Changes Complete.<BR>\n";
    print "      </FONT>\n";
    print "      <TABLE BORDER=0 CELLSPACING=0 WIDTH=75% CELLPADDING=4>\n";
    print "        <TR>\n";
    print "          <TD ALIGN=\"CENTER\">\n";
    print "            <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=3>\n";
    print "              $FirstName $LastName with Pilot Certificate Number $CertNo has been";
    if ($action eq "Insert")
      {
        print "              inserted into";
      }
    else
      {
        print "              updated in";
      }
    print "              the database.\n";
    print "              <BR>\n";
    print "              <BR>\n";
    print "              Return to \n";
    print "              <A HREF=\"/cgi-bin/AdminTools/Home.pl\">\n";
    print "                Admin Tools main menu\n";
    print "              </A>\n";
    print "              <BR>\n";
    print "              or\n";
    print "              <BR>\n";
    print "              <A HREF=\"/cgi-bin/AdminTools/ManageMembers.pl\">\n";
    print "                Member Management menu.\n";
    print "              </A>\n";
    print "            </FONT>\n";
    print "          </TD>\n";
    print "        </TR>\n";
    print "      </TABLE>\n";
  }

sub PrintInvalidActionError
  {
    #Prints an error message if someone (a hacker, most likely) is using a faulty cgi script
    print "        Warning--faulty CGI script detected.  These attempts, including the source IP address,\n";
    print "        <B>\n";
    print "          are\n";
    print "        </B>\n";
    print "        logged by the HTTP server.\n";
    print "        <BR>\n";
    print "        <BR>\n";
    print "        Unauthorized access of this server is a violation of law, and\n";
    print "        <B>\n";
    print "          will\n";
    print "        </B>\n";
    print "        be investigated and reported to the proper authorities, including your ISP, the FBI and local law enforcement agencies.\n"; 
    print "      </FONT>\n";
  }

sub PrintNotAuthorized
  {
    print "        I'm sorry--You must sign in before accessing this page.\n";
    print "        <BR>\n";
    print "        Please\n";
    print "        <A HREF=\"/AdminTools/Login.html\">\n";
    print "          sign in.\n";
    print "        </A>\n";
    print "      </FONT>\n";
  }

sub PrintClosingTags
  {
    #Prints HTML code common to all pages that closes the page
    print "      <BR>\n";
    print "      <BR>\n";
    print "      <BR>\n";
    print "      <TABLE BORDER=0 WIDTH=85%>\n";
    print "        <TR>\n";
    print "          <TD ALIGN=\"LEFT\">\n";
    print "            <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=2>\n";
    print "              907-555-1234\n";
    print "            </FONT>\n";
    print "          </TD>\n";
    print "          <TD ALIGN=\"RIGHT\">\n";
    print "            <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=2>\n";
    print "              <A HREF=\"mailto: contact@cfc.org\">\n";
    print "                contact@cfc.org\n";
    print "              </A>\n";
    print "            </FONT>\n";
    print "          </TD>\n";
    print "        </TR>\n";
    print "      </TABLE>\n";
    print "      <BR>\n";
    print "      <BR>\n";
    print "      <FONT FACE=\"TAHOMA\" SIZE=1 COLOR=\"NAVY\">\n";
    print "        Copyright &#169; 2002 Cumulogranite Flying Club\n";
    print "        <BR>\n";
    print "        <A HREF=\"/CS470/Merrill.gif\">\n";
    print "          1234 Merrill Field Dr.\n";
    print "        </A>\n";
    print "        , Anchorage, AK 99501\n";
    print "      </FONT>\n";
    print "    </DIV>\n";
    print "  </BODY>\n";
    print "</HTML>\n";
  }

sub OpenDBHandle
  {
    #Opens a handle to the MySQL Database
    $statement_handler=$db_handler->prepare($sql);
    if (!defined $statement_handler)
      {
        die('Cannot connect to the database');
      }
    else
      {
        $statement_handler->execute;
      }
  }
