#!/usr/bin/perl
# Setup for cookies and MySQL access
  use CGI;
  use DBI;
  use CGI::Carp  qw( fatalsToBrowser );
  $query=new CGI;
  my $db_handler=DBI->connect("DBI:mysql:test:localhost","mysql","");

#Main
  print $query->header;
  &PrintHeadings;
  if ($query->cookie('Admin'))
    {
      print $query->start_html(-title=>"Admin Tools--Add New Member Account");
      $AdminNo=$query->cookie('Admin');

      #Retrieve and process cgi information
      $action=$query->param('action');
      if ($action eq "")
        {
          &PrintMenu;
        }
      elsif ($action eq "Add")
        {
          $error=0;
          &GetCgiData;
          &ValidateCgiData;
          if ($error==0)
            {
              &InsertCFI;
              if ($error==0)
                {
                  &PrintComplete;
                }
              else
                {
                  &PrintUpdateError;
                }
            }
          else
            {
              &PrintValidationError;
            }
        }
      elsif ($action eq "Remove")
        {
          $error=0;
          &GetCgiData;
          &ValidateCgiData;
          if ($error==0)
            {
              &RemoveCFI;
              if ($error==0)
                {
                  &PrintComplete;
                }
              else
                {
                  &PrintUpdateError;
                }
            }
          else
            {
              &PrintValidationError;
            }
        }
      else
        {
          #Should never happen--indicates probable hack attempt with 3rd party CGI script
          &PrintCGIError;
        }
      &PrintClosingTags;
      $db_handler->disconnect;
    }
  else
    {
      &PrintAuthorizationError;
    }

sub PrintHeadings
  {
    print "<HTML>\n";
    print "  <HEAD>\n";
    print "    <TITLE>\n";
    print "      Admin Tools--Manage Instructors\n";
    print "    </TITLE>\n";
    print "  </HEAD>\n";
    print "  <BODY BACKGROUND=\"/AdminTools/stone.gif\">\n";
    print "    <DIV ALIGN=\"CENTER\">\n";
    print "      <IMG SRC=\"/AdminTools/Logo.gif\" WIDTH=\"384\" HEIGHT=\"54\">\n";
    print "      <BR>\n";
    print "      <HR WIDTH=\"93%\" COLOR=\"GRAY\">\n";
    print "      <BR>\n";
    print "      <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=4>\n";
  }

sub PrintMenu
  {
    print "        Manage Flight Instructors\n";
    print "      </FONT>\n";
    print "      <FORM ACTION=\"/cgi-bin/AdminTools/ManageInstructors.pl\" METHOD=\"POST\">\n";
    print "        <TABLE BORDER=1 WIDTH=\"93%\">\n";
    print "          <TR>\n";
    print "            <TD>\n";
    print "              <DIV ALIGN=\"CENTER\">\n";
    print "                <INPUT TYPE=\"radio\" NAME=\"action\" VALUE=\"Remove\">\n";
    print "                Remove Instructor:\n";
    print "                <SELECT NAME=\"CFI\">\n";
    $sql="Select FirstName, LastName, InstructorNo from Members, CFIs where (CFIs.InstructorNo=Members.MemberNo) order by LastName, FirstName asc";
    &OpenDBHandle;
    my $CFIs="";
    while (($FirstName, $LastName, $InstructorNo)=$statement_handler->fetchrow())
      {
        print "                 <OPTION VALUE=\"$InstructorNo\">$LastName, $FirstName\n";
        if ($CFIs eq "")
          {
            $CFIs="$InstructorNo";
          }
        else
          {
            $CFIs="$CFIs, $InstructorNo";
          }
      }
    $statement_handler->finish;
    print "                </SELECT>\n";
    print "              </DIV>\n";
    print "            </TD>\n";
    print "            <TD>\n";
    print "              <DIV ALIGN=\"CENTER\">\n";
    print "                <INPUT TYPE=\"radio\" NAME=\"action\" VALUE=\"Add\">\n";
    print "                Add Instructor:\n";
    print "                <SELECT NAME=\"Member\">\n";
    $sql="Select FirstName, LastName, MemberNo from Members, PilotCert where ((Members.CertNo=PilotCert.CertNo) and ((CertType=\"CFI\") or (CertType=\"ATP\")) and not (Members.MemberNo in ($CFIs))) order by LastName, FirstName asc";
    &OpenDBHandle;
    while (($FirstName, $LastName, $MemberNo)=$statement_handler->fetchrow())
      {
        print "                 <OPTION VALUE=\"$MemberNo\">$LastName, $FirstName\n";
      }
    $statement_handler->finish;
    print "                </SELECT>\n";
    print "              </DIV>\n";
    print "            </TD>\n";
    print "          </TR>\n";
    print "          <TR>\n";
    print "            <TD>\n";
    print "              <BR>\n";
    print "            </TD>\n";
    print "            <TD>\n";
    print "              <DIV ALIGN=\"CENTER\">\n";
    print "                <TABLE BORDER=1 WIDTH=\"100%\">\n";
    print "                  <TR>\n";
    print "                    <TD>\n";
    print "                      Instruction Given:\n";
    print "                      <INPUT TYPE=\"TEXT\" NAME=\"InstructionGiven\" SIZE=5 MAXSIZE=5>\n";
    print "                    </TD>\n";
    print "                  </TR>\n";
    print "                  <TR>\n";
    print "                    <TD>\n";
    print "                      Instructor's Comments:\n";
    print "                      <BR>\n";
    print "                      <TEXTAREA NAME=\"Comments\" COLS=42 ROWS=6></TEXTAREA>\n";
    print "                    </TD>\n";
    print "                  </TR>\n";
    print "                </TABLE>\n";
    print "              </DIV>\n";
    print "            </TD>\n";
    print "          <TR>\n";
    print "            <TD ALIGN=\"RIGHT\" COLSPAN=2>\n";
    print "              <DIV ALIGN=\"RIGHT\">\n";
    print "                <INPUT TYPE=\"reset\" NAME=\"reset\">\n";
    print "                <INPUT TYPE=\"submit\" NAME=\"submit\">\n";
    print "              </DIV>\n";
    print "            </TD>\n";
    print "          </TR>\n";
    print "        </TABLE>\n";
    print "      </FORM>\n";
  }

sub GetCgiData
  {
    #Retrieve data passed to the program from the web page
    if ($action eq "Add")
      {
        $MemberNo=$query->param('Member');
        $InstructionGiven=$query->param('InstructionGiven');
        $Comments=$query->param('Comments');
      }
    elsif ($action eq "Remove")
      {
        $MemberNo=$query->param('CFI');
      }
  }

sub ValidateCgiData
  {
    #Insert validation scripts here
  }

sub PrintValidationError
  {
    print "        I'm sorry--the data returned by the CGI script was not valid.  Please return to the\n";
    print "        <A HREF=\"/cgi-bin/AdminTools/ManageInstructors.pl\">\n";
    print "          Instructor Management\n";
    print "        </A>\n";
    print "        page, and try again.\n";
    print "        <BR>\n";
  }

sub InsertCFI
  {
    #Insert members into the CFIs table
    #First, verify that the member exists in the database
    $sql="Select MemberNo from Members where (MemberNo=$MemberNo)";
    &OpenDBHandle;
    ($error)=$statement_handler->fetchrow();
    $statement_handler->finish;
    
    if ($error > 0)
      {
        #The member exists, so verify that the member is not already an instructor
        $error=0;
        $sql="Select InstructorNo from CFIs where (InstructorNo=$MemberNo)";
        &OpenDBHandle;
        ($error)=$statement_handler->fetchrow();
        $statement_handler->finish;
        
        if ($error==0)
          {
            #The member is not already a CFI, so add him/her to the list of CFIs
            $sql="Insert into CFIs values ($MemberNo, $InstructionGiven, \"$Comments\")";
            &OpenDBHandle;
            $statement_handler=$db_handler->prepare($sql);
            $statement_handler->finish;
          }
      } 
  }

sub RemoveCFI
  {
    #Remove CFI from the CFIs table
    #First, verify that the member exists in the CFIs table

    $sql="Select InstructorNo from CFIs where (InstructorNo=$MemberNo)";
    &OpenDBHandle;
    ($error)=$statement_handler->fetchrow();
    $statement_handler->finish;

    if ($error > 0)
      {
        #The member exists in the CFIs table, so remove him/her
        $sql="Delete from CFIs where (InstructorNo=$MemberNo)";
        &OpenDBHandle;
        $statement_handler=$db_handler->prepare($sql);
        $statement_handler->finish;
        $error=0;
      }
    else
      {
        $error=1;
      }
  }

sub PrintUpdateError
  {
    if ($action eq "Add")
      {
        print "        Error--unable to insert the data into the database.  Verify that the user does exist in the Members table and that the user does not already exist in the CFIs table.\n";
      }
    elsif ($action eq "Remove")
      {
        print "        Error--unable to remove the data from the database.  Verify that the user already exists in the CFIs table.\n";
      }
    print "        <BR>\n";
  }

sub PrintComplete
  {
    print "        Done!  Changes to the database have been completed.\n";
    print "        <BR>\n";
  }

sub PrintAuthorizationError
  {
    print "        I'm sorry--this page is restricted to CFC Administrators, only.\n";
    print "        <BR>\n";
    print "        <BR>\n";
    print "        Please\n";
    print "        <A HREF=\"/AdminTools/Login.html\">\n";
    print "          sign in\n";
    print "        </A>\n";
    print "        to access this page.\n";
    print "        <BR>\n";
    print "      </FONT>\n";
    print "      <BR>\n";
    print "      <BR>\n";
    print "      <BR>\n";
    print "      <FONT FACE=\"TAHOMA\" SIZE=1 COLOR=\"NAVY\">\n";
    print "        Copyright &#169; 2002 Cumulogranite Flying Club\n";
    print "        <BR>\n";
    print "        <A HREF=\"/CS470/Merrill.gif\">\n";
    print "          1234 Merrill Field Dr.\n";
    print "        </A>\n";
    print "        , Anchorage, AK 99501\n";
    print "      </FONT>\n";
    print "    </DIV>\n";
    print "  </BODY>\n";
    print "</HTML>\n";
  }

sub PrintClosingTags
  {
    #Print common closing elements
    print "      <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=3>\n";
    print "        <BR>\n";
    print "        Return to \n";
    print "        <A HREF=\"/cgi-bin/AdminTools/Home.pl\">\n";
    print "          Admin Tools main menu\n";
    print "        </A>\n";
    print "        <BR>\n";
    print "        or\n";
    print "        <BR>\n";
    print "        <A HREF=\"/cgi-bin/AdminTools/ManageInstructors.pl\">\n";
    print "          Instructor Management menu.\n";
    print "        </A>\n";
    print "      </FONT>\n";
    print "      <BR>\n";
    print "      <BR>\n";
    print "      <BR>\n";
    print "      <FONT FACE=\"TAHOMA\" SIZE=1 COLOR=\"NAVY\">\n";
    print "        Copyright &#169; 2002 Cumulogranite Flying Club\n";
    print "        <BR>\n";
    print "        <A HREF=\"/CS470/Merrill.gif\">\n";
    print "          1234 Merrill Field Dr.\n";
    print "        </A>\n";
    print "        , Anchorage, AK 99501\n";
    print "      </FONT>\n";
    print "    </DIV>\n";
    print "  </BODY>\n";
    print "</HTML>\n";
  }

sub PrintCGIError
  {
    #Error Message to Hacker routine
    print "        Error--you should not have been able to reach this subroutine unless you are creating your
own scripts to access the database.  Please be advised that this server is for use by authorized users, and ha
cking attempts may be considered a violation of the law.  This server logs all incoming connections, and conti
nued abuse will result in notification to the proper authorities, to include your ISP, the FBI and local law e
nforcement, as applicable.\n";
    print "<BR>\n";
    print "Please LEAVE NOW!\n";
    print "<BR>\n";
    print "<BR>\n";
  }

sub OpenDBHandle
  {
    #Opens a handle to the MySQL Database
    $statement_handler=$db_handler->prepare($sql);
    if (!defined $statement_handler)
      {
        die('Cannot connect to the database');
      }
    else
      {
        $statement_handler->execute;
      }
  }
