#!/usr/bin/perl

use CGI;
use DBI;
use CGI::Carp qw( fatalsToBrowser );

# global declarations
my $db_handler = DBI->connect("DBI:mysql:test:localhost","mysql","");

$query=new CGI;

$sql="Select * from AircraftData order by MakeModel, NNo";

&GenerateTopOfPage;
&GenerateResults;
&GenerateClosingTags;

sub GenerateTopOfPage
  {
    print $query->header;
    print "<HTML>\n";
    print "  <HEAD>\n";
    print "    <TITLE>\n";
    print "      Cumulogranite Flying Club--Aircraft Data Summary\n";
    print "    </TITLE>\n";
    print "  </HEAD>\n";
    print "  <BODY BACKGROUND=\"../CGITest/Pulse.gif\" BGPROPERTIES=\"FIXED\">\n";
    print "    <DIV ALIGN=\"CENTER\">\n";
    print "      <IMG SRC=\"../CGITest/Logo.gif\" WIDTH=384 HEIGHT=54>\n";
    print "      <BR>\n";
    print "      <FONT FACE=\"Tahoma\" COLOR=\"WHITE\">\n";
    print "        <H1>\n";
    print "          Aircraft Data Summary\n";
    print "        </H1>\n";
    print "      </FONT><P>\n";
  }

sub GenerateResults
  {
    $statement_handler=$db_handler->prepare($sql);
    if (!defined $statement_handler)
      {
        die "Cannot connect to database--exciting.\n";
      }
    else
      {
        $statement_handler->execute;
      }

    while (($nno, $year, $makemodel, $category, $class, $hp, $complex, $tailwheel, $enginesize, $fuelcapacity, $ifrvfr, $daynight, $minpq, $emptyweight, $grossweight, $arm, $rate, $status, $imageurl) = $statement_handler->fetchrow())
      {
        print "        <HR WIDTH=\"95%\" ALIGN=\"CENTER\" COLOR=\"GRAY\">\n";
        print "        <BR>\n";
        print "        <BR>\n";
        print "        <FONT FACE=\"Tahoma\" COLOR=\"WHITE\">\n";
        print "          $nno $year $makemodel\n";
        print "        </FONT>\n";
        print "        <BR>\n";
        print "        <TABLE BORDER=1 CELLSPACING=0 WIDTH=92% SIZE=2>\n";
        print "          <TR>\n";
        print "            <TD>\n";
        print "              <DIV ALIGN=\"CENTER\">\n";
        print "                <FONT FACE=\"Tahoma\" COLOR=\"WHITE\" SIZE=2>\n";
        print "                  <B>\n";
        print "                    Category\n";
        print "                  </B>\n";
        print "                </FONT>\n";
        print "              </DIV>\n";
        print "            </TD>\n";
        print "            <TD>\n";
        print "              <DIV ALIGN=\"CENTER\">\n";
        print "                <FONT FACE=\"Tahoma\" COLOR=\"WHITE\" SIZE=2>\n";
        print "                  <B>\n";
        print "                    Class\n";
        print "                  </B>\n";
        print "                </FONT>\n";
        print "              </DIV>\n";
        print "            </TD>\n";
        print "            <TD>\n";
        print "              <DIV ALIGN=\"CENTER\">\n";
        print "                <FONT FACE=\"Tahoma\" COLOR=\"WHITE\" SIZE=2>\n";
        print "                  <B>\n";
        print "                    High-Performance\n";
        print "                  </B>\n";
        print "                </FONT>\n";
        print "              </DIV>\n";
        print "            </TD>\n";
        print "            <TD>\n";
        print "              <DIV ALIGN=\"CENTER\">\n";
        print "                <FONT FACE=\"Tahoma\" COLOR=\"WHITE\" SIZE=2>\n";
        print "                  <B>\n";
        print "                    Complex\n";
        print "                  </B>\n";
        print "                </FONT>\n";
        print "              </DIV>\n";
        print "            </TD>\n";
        print "            <TD>\n";
        print "              <DIV ALIGN=\"CENTER\">\n";
        print "                <FONT FACE=\"Tahoma\" COLOR=\"WHITE\" SIZE=2>\n";
        print "                  <B>\n";
        print "                    Tailwheel\n";
        print "                  </B>\n";
        print "                </FONT>\n";
        print "              </DIV>\n";
        print "            </TD>\n";
        print "            <TD>\n";
        print "              <DIV ALIGN=\"CENTER\">\n";
        print "                <FONT FACE=\"Tahoma\" COLOR=\"WHITE\" SIZE=2>\n";
        print "                  <B>\n";
        print "                    IFR/VFR Certification\n";
        print "                  </B>\n";
        print "                </FONT>\n";
        print "              </DIV>\n";
        print "            </TD>\n";
        print "            <TD>\n";
        print "              <DIV ALIGN=\"CENTER\">\n";
        print "                <FONT FACE=\"Tahoma\" COLOR=\"WHITE\" SIZE=2>\n";
        print "                  <B>\n";
        print "                    Day/Night Certification\n";
        print "                  </B>\n";
        print "                </FONT>\n";
        print "              </DIV>\n";
        print "            </TD>\n";
        print "            <TD>\n";
        print "              <DIV ALIGN=\"CENTER\">\n";
        print "                <FONT FACE=\"Tahoma\" COLOR=\"WHITE\" SIZE=2>\n";
        print "                  <B>\n";
        print "                    Rental Rate\n";
        print "                  </B>\n";
        print "                </FONT>\n";
        print "              </DIV>\n";
        print "            </TD>\n";
        print "            <TD>\n";
        print "              <DIV ALIGN=\"CENTER\">\n";
        print "                <FONT FACE=\"Tahoma\" COLOR=\"WHITE\" SIZE=2>\n";
        print "                  <B>\n";
        print "                    Flight Status\n";
        print "                  </B>\n";
        print "                </FONT>\n";
        print "              </DIV>\n";
        print "            </TD>\n";
        print "          </TR>\n";

        print "          <TR>\n";
        print "            <TD>\n";
        print "              <DIV ALIGN=\"CENTER\">\n";
        print "                <FONT FACE=\"Tahoma\" COLOR=\"WHITE\" SIZE=2>\n";
        print "                  $category\n";
        print "                </FONT>\n";
        print "              </DIV>\n";
        print "            </TD>\n";
        print "            <TD>\n";
        print "              <DIV ALIGN=\"CENTER\">\n";
        print "                <FONT FACE=\"Tahoma\" COLOR=\"WHITE\" SIZE=2>\n";
        print "                  $class\n";
        print "                </FONT>\n";
        print "              </DIV>\n";
        print "            </TD>\n";
        if ($hp==0)
          {
            print "            <TD>\n";
            print "              <DIV ALIGN=\"CENTER\">\n";
            print "                <FONT FACE=\"Tahoma\" COLOR=\"WHITE\" SIZE=2>\n";
            print "                  No\n";
            print "                </FONT>\n";
            print "              </DIV>\n";
            print "            </TD>\n";
          }
        else
          {
            print "            <TD>\n";
            print "              <DIV ALIGN=\"CENTER\">\n";
            print "                <FONT FACE=\"Tahoma\" COLOR=\"WHITE\" SIZE=2>\n";
            print "                  Yes\n";
            print "                </FONT>\n";
            print "              </DIV>\n";
            print "            </TD>\n";
          }
        if ($complex==0)
          {
            print "            <TD>\n";
            print "              <DIV ALIGN=\"CENTER\">\n";
            print "                <FONT FACE=\"Tahoma\" COLOR=\"WHITE\" SIZE=2>\n";
            print "                  No\n";
            print "                </FONT>\n";
            print "              </DIV>\n";
            print "            </TD>\n";
          }
        else
          {
            print "            <TD>\n";
            print "              <DIV ALIGN=\"CENTER\">\n";
            print "                <FONT FACE=\"Tahoma\" COLOR=\"WHITE\" SIZE=2>\n";
            print "                  <BR>\n";
            print "                  Yes\n";
            print "                </FONT>\n";
            print "              </DIV>\n";
            print "`           </TD>\n";
          }
        if ($tailwheel==0)
          {
            print "            <TD>\n";
            print "              <DIV ALIGN=\"CENTER\">\n";
            print "                <FONT FACE=\"Tahoma\" COLOR=\"WHITE\" SIZE=2>\n";
            print "                  No\n";
            print "                </FONT>\n";
            print "              </DIV>\n";
            print "            </TD>\n";
          }
        else
          {
            print "            <TD>\n";
            print "              <DIV ALIGN=\"CENTER\">\n";
            print "                <FONT FACE=\"Tahoma\" COLOR=\"WHITE\" SIZE=2>\n";
            print "                  Yes\n";
            print "                </FONT>\n";
            print "              </DIV>\n";
            print "            </TD>\n";
          }
        print "            <TD>\n";
        print "              <DIV ALIGN=\"CENTER\">\n";
        print "                <FONT FACE=\"Tahoma\" COLOR=\"WHITE\" SIZE=2>\n";
        print "                  $ifrvfr\n";
        print "                </FONT>\n";
        print "              </DIV>\n";
        print "            </TD>\n";
        print "            <TD>\n";
        print "              <DIV ALIGN=\"CENTER\">\n";
        print "                <FONT FACE=\"Tahoma\" COLOR=\"WHITE\" SIZE=2>\n";
        print "                  $daynight\n";
        print "                </FONT>\n";
        print "              </DIV>\n";
        print "            </TD>\n";
        print "            <TD>\n";
        print "              <DIV ALIGN=\"CENTER\">\n";
        print "                <FONT FACE=\"Tahoma\" COLOR=\"WHITE\" SIZE=2>\n";
        print "                  \$$rate per hour\n";
        print "                </FONT>\n";
        print "              </DIV>\n";
        print "            </TD>\n";
        print "            <TD>\n";
        print "              <DIV ALIGN=\"CENTER\">\n";
        print "                <FONT FACE=\"Tahoma\" COLOR=\"WHITE\" SIZE=2>\n";
        print "                  $status\n";
        print "                </FONT>\n";
        print "              </DIV>\n";
        print "            </TD>\n";
        print "          </TR>\n";
        print "        </TABLE><P>\n";
        
        print "        <TABLE BORDER=1 CELLSPACING=0 WIDTH=92% SIZE=2>\n";
        print "          <TR>\n";
        print "            <TD>\n";
        print "              <DIV ALIGN=\"CENTER\">\n";
        print "                <FONT FACE=\"Tahoma\" COLOR=\"WHITE\" SIZE=2>\n";
        print "                  <B>\n";
        print "                    Engine Size\n";
        print "                  </B>\n";
        print "                </FONT>\n";
        print "              </DIV>\n";
        print "            </TD>\n";
        print "            <TD>\n";
        print "              <DIV ALIGN=\"CENTER\">\n";
        print "                <FONT FACE=\"Tahoma\" COLOR=\"WHITE\" SIZE=2>\n";
        print "                  <B>\n";
        print "                    Fuel Capacity\n";
        print "                  </B>\n";
        print "                </FONT>\n";
        print "              </DIV>\n";
        print "            </TD>\n";
        print "            <TD>\n";
        print "              <DIV ALIGN=\"CENTER\">\n";
        print "                <FONT FACE=\"Tahoma\" COLOR=\"WHITE\" SIZE=2>\n";
        print "                  <B>\n";
        print "                    Empty Weight\n";
        print "                  </B>\n";
        print "                </FONT>\n";
        print "              </DIV>\n";
        print "            </TD>\n";
        print "            <TD>\n";
        print "              <DIV ALIGN=\"CENTER\">\n";
        print "                <FONT FACE=\"Tahoma\" COLOR=\"WHITE\" SIZE=2>\n";
        print "                  <B>\n";
        print "                    Gross Weight\n";
        print "                  </B>\n";
        print "                </FONT>\n";
        print "              </DIV>\n";
        print "            </TD>\n";
        print "            <TD>\n";
        print "              <DIV ALIGN=\"CENTER\">\n";
        print "                <FONT FACE=\"Tahoma\" COLOR=\"WHITE\" SIZE=2>\n";
        print "                  <B>\n";
        print "                    Useful Load\n";
        print "                  </B>\n";
        print "                </FONT>\n";
        print "              </DIV>\n";
        print "            </TD>\n";
        print "            <TD>\n";
        print "              <DIV ALIGN=\"CENTER\">\n";
        print "                <FONT FACE=\"Tahoma\" COLOR=\"WHITE\" SIZE=2>\n";
        print "                  <B>\n";
        print "                    Arm\n";
        print "                  </B>\n";
        print "                </FONT>\n";
        print "              </DIV>\n";
        print "            </TD>\n";
        print "            <TD>\n";
        print "              <DIV ALIGN=\"CENTER\">\n";
        print "                <FONT FACE=\"Tahoma\" COLOR=\"WHITE\" SIZE=2>\n";
        print "                  <B>\n";
        print "                    Moment\n";
        print "                  </B>\n";
        print "                </FONT>\n";
        print "              </DIV>\n";
        print "            </TD>\n";
        print "          </TR>\n";
        print "          <TR>\n";
        print "            <TD>\n";
        print "              <DIV ALIGN=\"CENTER\">\n";
        print "                <FONT FACE=\"Tahoma\" COLOR=\"WHITE\" SIZE=2>\n";
        print "                  $enginesize H.P.\n";
        print "                </FONT>\n";
        print "              </DIV>\n";
        print "            </TD>\n";
        print "            <TD>\n";
        print "              <DIV ALIGN=\"CENTER\">\n";
        print "                <FONT FACE=\"Tahoma\" COLOR=WHITE SIZE=2>\n";
        print "                  $fuelcapacity Gal.\n";
        print "                </FONT>\n";
        print "              </DIV>\n";
        print "            </TD>\n";
        print "            <TD>\n";
        print "              <DIV ALIGN=\"CENTER\">\n";
        print "                <FONT FACE=\"Tahoma\" COLOR=\"WHITE\" SIZE=2>\n";
        print "                  $emptyweight Lbs.\n";
        print "                </FONT>\n";
        print "              </DIV>\n";
        print "            </TD>\n";
        print "            <TD>\n";
        print "              <DIV ALIGN=\"CENTER\">\n";
        print "                <FONT FACE=\"Tahoma\" COLOR=\"WHITE\" SIZE=2>\n";
        print "                  $grossweight Lbs.\n";
        print "                </FONT>\n";
        print "              </DIV>\n";
        print "            </TD>\n";
        $usefulload = $grossweight - $emptyweight;
        print "            <TD>\n";
        print "              <DIV ALIGN=\"CENTER\">\n";
        print "                <FONT FACE=\"Tahoma\" COLOR=\"WHITE\" SIZE=2>\n";
        print "                  $usefulload Lbs.\n";
        print "                </FONT>\n";
        print "              </DIV>\n";
        print "            </TD>\n";
        print "            <TD>\n";
        print "              <DIV ALIGN=\"CENTER\">\n";
        print "                <FONT FACE=\"Tahoma\" COLOR=\"WHITE\" SIZE=2>\n";
        print "                  $arm inches\n";
        print "                </FONT>\n";
        print "              </DIV>\n";
        print "            </TD>\n";
        $moment = $emptyweight * $arm;
        print "            <TD>\n";
        print "              <DIV ALIGN=\"CENTER\">\n";
        print "                <FONT FACE=\"Tahoma\" COLOR=\"WHITE\" SIZE=2>\n";
        print "                  $moment Lb. In.\n";
        print "                </FONT>\n";
        print "              </DIV>\n";
        print "            </TD>\n";
        print "          </TR>\n";
        print "        </TABLE>\n";
        print "        <BR>\n";
        print "        <BR>\n";
        if ($imageurl ne "")
          {
             print "        <IMG SRC=\"/CS470/$imageurl\" BORDER=1 WIDTH=300>\n";
             print "        <BR>\n";
             print "        <BR>\n";
             print "        <BR>\n";
          }
        else
          {
             print "        <FONT FACE=\"Tahoma\" COLOR=\"WHITE\" SIZE=2>\n";
             print "          Sorry--image not available\n";
             print "        </FONT>\n";
             print "        <BR>\n";
             print "        <BR>\n";
             print "        <BR>\n";
          }
      }

    $statement_handler->finish;
    $db_handler->disconnect;
  }

sub GenerateClosingTags
  {
    print "    </DIV>\n";
    print "  </BODY>\n";
    print "</HTML>\n";
  }
