package fortytwo.client;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JButton;
import javax.swing.JTextArea;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;

/**
 * <p>Title: Forty Two Unlimited</p>
 * <p>Description: Texas Forty Two Game</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: 42Unlimited</p>
 * @author Nathaniel Normandin
 * @version 0.00.01
 */

import java.util.Vector;
import java.awt.*;
import fortytwo.network.*;

public class ChatPanel extends Panel implements ChatListener {
  private GridBagLayout gbLayout_Chat = new GridBagLayout( );
  private JScrollPane jSP_Chat = new JScrollPane();
  private JScrollPane jSP_OnlinePlayers;
  private JTextField jTF_ChatToSend = new JTextField();
  private JButton jButton_Send = new JButton();
  private JTextArea jTA_Chat = new JTextArea();
  private JList jList_OnlinePlayers = new JList();
  private JLabel jLabel_OnlinePlayers = new JLabel();
  private Vector vector_Players = new Vector();

  private String username;

  public ChatPanel() {
    ClientMessageManager.getInstance().addChatListener(this);
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  public void welcomePlayerReceived( WelcomePlayer welcomePlayer) {
    jTA_Chat.append( "You are connected.\n" );
    jButton_Send.setEnabled(true);
    jTF_ChatToSend.setEditable(true);
  }

  public void disconnectReceived() {
    jTA_Chat.append( "You are disconnected\n" );
    jButton_Send.setEnabled(false);
    jTF_ChatToSend.setEditable(false);
    jList_OnlinePlayers.setListData( new Vector() );
  }

  public void lobbyChatReceived( LobbyChat lobbyChat ) {
    if ( lobbyChat.getChat() == null )
      ;
    else {
      jTA_Chat.append(lobbyChat.getUsername() + ": " + lobbyChat.getChat() + "\n");
      jTA_Chat.setCaretPosition(jTA_Chat.getText().length());
    }
  }

  public void privateMessageReceived(String user, String message) {
    jTA_Chat.append( "PRIVATE MESSAGE FROM " + user + ": " + message + "\n" );
    jTA_Chat.setCaretPosition(jTA_Chat.getText().length());
  }

  public void lobbyChatListReceived ( LobbyChatList lobbyChatList ) {
    System.out.print("Lobby Chat List received: ");
    vector_Players = lobbyChatList.getChatList();
    for ( int i = 0; i < vector_Players.size(); i ++ ){
      System.out.print( (String) vector_Players.get(i) );
    }
    jList_OnlinePlayers.setListData(vector_Players);
  }

  public void setUsername( String tempUsername ) {
    username = tempUsername;
  }

  private void jbInit() throws Exception {
    this.setFont(new java.awt.Font("Dialog", 0, 11));
    //this.setLocale(java.util.Locale.getDefault());
    this.setLayout(gbLayout_Chat);
    jSP_Chat.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
    jSP_Chat.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
    //jSP_Chat.setAlignmentX((float) 0.5);
    jSP_Chat.setMinimumSize(new Dimension(300, 250));
    jSP_Chat.setPreferredSize(new Dimension(300, 250));
    jButton_Send.setEnabled(false);
    jButton_Send.setMaximumSize(new Dimension(83, 23));
    jButton_Send.setMinimumSize(new Dimension(65, 23));
    jButton_Send.setPreferredSize(new Dimension(65, 23));
    jButton_Send.setActionCommand("Send Chat");
    jButton_Send.setHorizontalTextPosition(SwingConstants.CENTER);
    jButton_Send.setMargin(new Insets(1, 1, 1, 1));
    jButton_Send.setText("Send Chat");
    jButton_Send.addActionListener(new jButton_Send_ActionListener());
    jTA_Chat.setFont(new java.awt.Font("Dialog", 0, 11));
    jTA_Chat.setText("Welcome to 42Unlimited\n");
    jTA_Chat.setLineWrap(true);
    jTA_Chat.setWrapStyleWord(true);
    jTA_Chat.setEditable(false);
    jTF_ChatToSend.setMinimumSize(new Dimension(220, 20));
    jTF_ChatToSend.setPreferredSize(new Dimension(220, 20));
    jTF_ChatToSend.setMargin(new Insets(1, 1, 1, 1));
    jTF_ChatToSend.setEditable(false);
    jTF_ChatToSend.addActionListener(new jButton_Send_ActionListener());
    //jTF_ChatToSend.setText("");
    jList_OnlinePlayers.setFont(new java.awt.Font("Arial", 0, 11));
    jList_OnlinePlayers.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    jList_OnlinePlayers.setVisibleRowCount(20);
    jList_OnlinePlayers.setListData(vector_Players);

    jSP_OnlinePlayers = new JScrollPane( jList_OnlinePlayers );
    jSP_OnlinePlayers.setMinimumSize(new Dimension(75, 200));
    jSP_OnlinePlayers.setPreferredSize(new Dimension(100, 200));
    jLabel_OnlinePlayers.setFont(new java.awt.Font("Arial Narrow", 1, 11));
    jLabel_OnlinePlayers.setMaximumSize(new Dimension(69, 70));
    jLabel_OnlinePlayers.setMinimumSize(new Dimension(69, 70));
    jLabel_OnlinePlayers.setPreferredSize(new Dimension(69, 70));
    //jLabel_OnlinePlayers.setLabelFor(jList_OnlinePlayers);
    jLabel_OnlinePlayers.setText("Players Online:");
    jLabel_OnlinePlayers.setVerticalAlignment(javax.swing.SwingConstants.BOTTOM);
    jLabel_OnlinePlayers.setVerticalTextPosition(javax.swing.SwingConstants.CENTER);
    this.add(jSP_Chat,                  new GridBagConstraints(0, 0, 2, 2, 0.0, 0.0
            ,GridBagConstraints.NORTHWEST, GridBagConstraints.NONE, new Insets(4, 4, 4, 4), 2, 2));
    jSP_Chat.getViewport().add(jTA_Chat, null);
    this.add(jTF_ChatToSend,                 new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.SOUTHWEST, GridBagConstraints.BOTH, new Insets(4, 4, 4, 4), 2, 2));
    this.add(jButton_Send,            new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.SOUTH, GridBagConstraints.NONE, new Insets(4, 4, 4, 4), 2, 2));
    this.add(jSP_OnlinePlayers,                new GridBagConstraints(2, 1, 1, 2, 0.0, 0.0
            ,GridBagConstraints.SOUTHEAST, GridBagConstraints.NONE, new Insets(0, 4, 4, 4), 2, 2));
    this.add(jLabel_OnlinePlayers,            new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.SOUTH, GridBagConstraints.NONE, new Insets(4, 4, 4, 4), 2, 2));
  }

  public class jButton_Send_ActionListener implements ActionListener {

    public void actionPerformed ( ActionEvent event ) {
      String chatToSend = jTF_ChatToSend.getText();
      jTF_ChatToSend.setText("");
      if ( !(chatToSend.equals("") || chatToSend == null) )
        ClientMessageManager.getInstance().lobbyChat( new LobbyChat ( username, chatToSend ) );
    }
  }
}
