package fortytwo.network;

/**
 * <p>Title: Forty Two Unlimited</p>
 * <p>Description: Texas Forty Two Game</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: 42Unlimited</p>
 * @author Nathaniel Normandin
 * @version 0.00.01
 */

import java.util.StringTokenizer;

public class JoinTable extends Message {
  public static final String type = "21";
  private int iTableNum;

  public JoinTable( Message oMessage ) {
    setMessage( oMessage.getMessage() );
    grabTableNum();
  }

  public JoinTable( int iTableNumtemp ) {
    setMessage( type + DELIMITER + iTableNumtemp );
    iTableNum = iTableNumtemp;
  }

  public int getTableNumber() {
    return iTableNum;
  }

  private void grabTableNum() {
    StringTokenizer oTokenizer = new StringTokenizer( getMessage(), DELIMITER );
    if ( oTokenizer.countTokens() == 2 ) {
      String header = oTokenizer.nextToken();
      iTableNum = new Integer( oTokenizer.nextToken() ).intValue();
    }
  }

}
