package fortytwo.network;

/**
 * <p>Title: Forty Two Unlimited</p>
 * <p>Description: Texas Forty Two Game</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: 42Unlimited</p>
 * @author Nathaniel Normandin
 * @version 0.00.01
 */

import java.util.Vector;
import java.util.StringTokenizer;


public class LoadTable extends Message {
  public static final String type = "30";
  private Rules m_oRules;
  private Vector m_oPlayers;
  private Vector m_oDominos;
  private int m_iDealer;

  public LoadTable( Message oMessage ) {
    setMessage( oMessage.getMessage() );
    grabLoadTable();
  }

  public LoadTable( Vector oPlayers, Rules oRules, Vector oDominos, int iDealer ) {
    String sMessage;
    sMessage = type + DELIMITER;
    for ( int i = 0; i < oPlayers.size(); i ++ ) {
      String oPlayer = (String) oPlayers.get( i );
      sMessage += oPlayer + DELIMITER;
    }
    sMessage += oRules.getRulesAsString() + DELIMITER;
    for ( int i = 0; i < oDominos.size(); i ++ ){
      String oDomino = ( String ) oDominos.get( i );
      sMessage += oDomino + DELIMITER;
    }
    sMessage += iDealer;
    setMessage( sMessage );
    m_oPlayers = oPlayers;
    m_oRules = oRules;
    m_oDominos = oDominos;
    m_iDealer = iDealer;
  }

  public void grabLoadTable() {
    StringTokenizer oTokenizer = new StringTokenizer( getMessage(), DELIMITER );
    if ( oTokenizer.countTokens() >= 13 ) {
      String header = oTokenizer.nextToken();
      m_oPlayers = new Vector(4);
      m_oPlayers.add(0, oTokenizer.nextToken() );
      m_oPlayers.add(1, oTokenizer.nextToken() );
      m_oPlayers.add(2, oTokenizer.nextToken() );
      m_oPlayers.add(3, oTokenizer.nextToken() );
      String sRules = oTokenizer.nextToken();
      m_oRules = new Rules( );
      m_oRules.setRulesFromString( sRules );
      m_oDominos = new Vector( 7 );
      m_oDominos.add( oTokenizer.nextToken());
      m_oDominos.add( oTokenizer.nextToken());
      m_oDominos.add( oTokenizer.nextToken());
      m_oDominos.add( oTokenizer.nextToken());
      m_oDominos.add( oTokenizer.nextToken());
      m_oDominos.add( oTokenizer.nextToken());
      m_oDominos.add( oTokenizer.nextToken());
      m_iDealer = new Integer( oTokenizer.nextToken() ).intValue();

    }
  }

  public Rules getRules() {
    return m_oRules;
  }

  public Vector getPlayers() {
    return m_oPlayers;
  }

  public Vector getDominos() {
    return m_oDominos;
  }

  public int getDealer() {
    return m_iDealer;
  }
}
