package fortytwo.network;

/**
 * <p>Title: Forty Two Unlimited</p>
 * <p>Description: Texas Forty Two Game</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: 42Unlimited</p>
 * @author Nathaniel Normandin
 * @version 0.00.01
 */
import java.util.Vector;
import java.util.StringTokenizer;
import fortytwo.testserver.Table;
import fortytwo.testserver.Player;

public class LobbyTableList extends Message
{
  public static final String type = "6";
  public static final String DELIMITER2 = "'";
  public static final String DELIMITER3 = " ";

  Vector lobbyTableList;

  // client side maipulation
  public LobbyTableList( Message oMessage ) {
    setMessage( oMessage.getMessage() );
    grabLobbyTableList();
  }

  // Server side manipulation
  public LobbyTableList(Vector tableList) {
    lobbyTableList = tableList;
    String tempMessage = type + DELIMITER;
    synchronized( tableList ) {
      for (int i=0; i < tableList.size(); i ++ ) {
        Table oTable = (Table) tableList.get(i);
        tempMessage += oTable.getTableNumber() + DELIMITER2;

        // get the rules
        tempMessage += oTable.getRules().getRulesAsString() +  DELIMITER2;

        // get the players
        Vector players = oTable.getPlayerNames();
        for ( int j = 0; j < players.size(); j ++ ) {
          tempMessage += (String) players.get(j) + DELIMITER3;
        }
        tempMessage += DELIMITER;
      }
    }
    setMessage( tempMessage );
  }

  private void grabLobbyTableList () {
    lobbyTableList = new Vector();
    StringTokenizer tokenizer = new StringTokenizer( getMessage(), DELIMITER );

    String oTableToAdd = null;

    if ( tokenizer.countTokens() >= 2 ) {
      String header = tokenizer.nextToken();
      while ( tokenizer.hasMoreTokens() ) {
        StringTokenizer oTokenizer2 = new StringTokenizer( tokenizer.nextToken(), DELIMITER2 );
        if ( oTokenizer2.countTokens() == 3 ) {
          oTableToAdd = oTokenizer2.nextToken() + " | ";
          oTableToAdd += oTokenizer2.nextToken() + " | ";
          oTableToAdd += oTokenizer2.nextToken();
        }
        if ( oTableToAdd != null ) {
          lobbyTableList.add(oTableToAdd);
          oTableToAdd = null;
        }
      }
    }
  }

  public Vector getLobbyTableList() {
    return lobbyTableList;
  }
}
