package fortytwo.network;

/**
 * <p>Title: Forty Two Unlimited</p>
 * <p>Description: Texas Forty Two Game</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: 42Unlimited</p>
 * @author Nathaniel Normandin
 * @version 0.00.01
 */

import java.util.StringTokenizer;

public class Message {

  private String message;

  public static final String DELIMITER = "`";

  public Message( ) {
  }

  public Message( String tempMessage ) {
    message = tempMessage;
  }

  public Message( String header, String data ) {
    message = header + DELIMITER + data;
  }

  public String getHeader() {
    StringTokenizer tokenizer = new StringTokenizer( message, DELIMITER );
    if ( tokenizer.hasMoreTokens() )
      return tokenizer.nextToken();
    else
      return null;
  }

  public void setMessage( Message tempMessage ) {
    setMessage( tempMessage.getMessage() );
  }

  public void setMessage ( String tempMessage ) {
    message = tempMessage;
  }

  public void setMessage ( String header, String data ) {

    message = header + DELIMITER + data;
  }

  public String getMessage () {
    return message;
  }

}
