package fortytwo.network;

/**
 * <p>Title: Forty Two Unlimited</p>
 * <p>Description: Texas Forty Two Game</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: 42Unlimited</p>
 * @author Nathaniel Normandin
 * @version 0.00.01
 */
import java.util.StringTokenizer;


public class Play extends Message {

  /**
   * The value uniquely identifying a Play Message
   */
  public static final String type = "50";

  /**
   * The position of the player that made the Play
   */
  private int m_iPosition;

  /**
   * Is true if the domino is currently the leading domino in the trick
   */
  private boolean m_bIsLeading;

  /**
   * The left side of the domino's value
   */
  private int m_iLeft;

  /**
   * The right side of the domino's value
   */
  private int m_iRight;

  /**
   * constructs the Play using the given message.  Note, it calls the grabPlay
   * method to break the message into its parts
   * @param oMessage Message
   */
  public Play( Message oMessage ) {
    setMessage( oMessage.getMessage() );
    grabPlay();
  }

  public Play( int iPosition, boolean bIsLeading, int iLeft, int iRight) {
    m_iPosition = iPosition;
    m_bIsLeading = bIsLeading;
    m_iLeft = iLeft;
    m_iRight = iRight;

    String sMessage = type + DELIMITER;
    sMessage += m_iPosition + DELIMITER;
    sMessage += m_bIsLeading + DELIMITER;
    sMessage += m_iLeft + DELIMITER;
    sMessage += m_iRight;

    setMessage( sMessage );

  }

  /**
   * Takes the message and tokenizes it into its parts.
   */
  public void grabPlay() {
    StringTokenizer oTokenizer = new StringTokenizer( getMessage(), DELIMITER );
    if ( oTokenizer.countTokens() == 5 )
    {
      String header = oTokenizer.nextToken();
      m_iPosition = new Integer(oTokenizer.nextToken()).intValue();
      m_bIsLeading = oTokenizer.nextToken().equals( "true" );
      m_iLeft = new Integer( oTokenizer.nextToken() ).intValue();
      m_iRight = new Integer( oTokenizer.nextToken() ).intValue();
    }
  }

}
