package fortytwo.network;

/**
 * <p>Title: Forty Two Unlimited</p>
 * <p>Description: Texas Forty Two Game</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: 42Unlimited</p>
 * @author Nathaniel Normandin
 * @version 0.00.01
 */
import java.util.StringTokenizer;

public class PlayerLogin extends Message {

  public static final String type = "3";
  private String username;
  private String password;

  public PlayerLogin ( Message tempMessage ) {
    setMessage( tempMessage.getMessage() );
    getPlayerLogin();
  }

  public PlayerLogin( String user, String pass ) {
    username = user;
    password = pass;
    setMessage( type + DELIMITER + username + DELIMITER + password );
  }

  public void getPlayerLogin() {
    StringTokenizer tokenizer = new StringTokenizer( getMessage(), DELIMITER );
    String header = "";
    if ( tokenizer.countTokens() == 3 ) {
      header = tokenizer.nextToken();
      username = tokenizer.nextToken();
      password = tokenizer.nextToken();
    }
  }

  public String getUsername () {
    return username;
  }

  public String getPassword() {
    return password;
  }


}
