package fortytwo.network;

/**
 * <p>Title: Forty Two Unlimited</p>
 * <p>Description: Texas Forty Two Game</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: 42Unlimited</p>
 * @author Nathaniel Normandin
 * @version 0.00.01
 */

import java.util.StringTokenizer;

public class TableChat extends Message {
  public static final String type = "11";

  String m_oUsername;
  String m_oChat;

  public TableChat( Message tempMessage ) {
    setMessage( tempMessage.getMessage() );
    grabTableChat();
  }

  public TableChat( String oUsername, String oChat ) {
    setMessage( type + DELIMITER + oUsername + DELIMITER + oChat );
    m_oUsername = oUsername;
    m_oChat = oChat;
  }

  private void grabTableChat () {
    StringTokenizer oTokenizer = new StringTokenizer( getMessage(), DELIMITER );
    if ( oTokenizer.countTokens() >= 3 ) {
      String oHeader = oTokenizer.nextToken();
      m_oUsername = oTokenizer.nextToken();
      m_oChat = oTokenizer.nextToken();
      while ( oTokenizer.hasMoreTokens() ) {
        m_oChat += DELIMITER + oTokenizer.nextToken();
      }
    }
  }

  public String getUsername() {
    return m_oUsername;
  }

  public String getChat() {
    return m_oChat;
  }

}
