package fortytwo.server;

/**
 * <p>Title: Forty Two Unlimited</p>
 * <p>Description: Texas Forty Two Game</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: 42Unlimited</p>
 * @author Nathaniel Normandin
 * @version 0.00.01
 */

import java.util.Vector;
import java.util.Collections;

// DominoSet is a class containing a Vector of dominos.  It contains methods
// to operate on this vector by shuffling and other.
public class DominoSet {

  // the set of dominos
  private Vector domino;

  // Constructor.  It creates the DominoSet by adding all the Domino to the
  // Vector.
  public DominoSet() {
    for ( int i = 0; i <= 6; i ++ ){
      for ( int j = 0; j <= i; j ++ ) {
        Domino tempDomino = new Domino( i, j );
        domino.add( tempDomino );
      }
    }
  }

  // shuffle() shuffles the indicies of the Vector as to give a different order
  // for the purposes of playing the game.
  public void shuffleSet() {
    Collections.shuffle( domino );
    Collections.shuffle( domino );
  }

  // remove( int, int ) removes the Domino with the left and right amounts of dots
  // on it. It returns true if added successfully.
  public boolean remove( int left, int right ) {
    Domino tempDom = new Domino ( left, right );
    return domino.remove( tempDom );
  }

  // add ( int, int ) adds the Domino with the left and right amounts of dots on
  // it. It returns true if added successfully.
  public boolean add ( int left, int right ) {
    Domino tempDom = new Domino ( left, right );
    return domino.add ( tempDom );
  }

  public Domino pop() {
    if ( domino.size() >= 1 )
      return (Domino) domino.remove(domino.size() - 1);
    else
      return null;
  }

  public void push( Domino oDomino) {
    domino.add( oDomino );
  }

  public Domino get( int i ) {
    return (Domino) domino.get( i );
  }

  public int size() {
    return domino.size();
  }
}
