package fortytwo.server;

/**
 * <p>Title: Forty Two Unlimited</p>
 * <p>Description: Texas Forty Two Game</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: 42Unlimited</p>
 * @author Nathaniel Normandin
 * @version 0.00.01
 */
import java.util.Vector;
import java.net.Socket;
import java.net.ServerSocket;
import java.io.IOException;

public class Lobby extends Thread /*implements LobbyListener*/ {

  public static final int SERVER_PORT = 5432;
  public static final int MAX_CONNECTIONS = 200;

  public Vector player;
  public Vector table;

  private boolean keepOnline = true;
  private ServerSocket serverSocket;
  public MessageListener messageListener;

  public Lobby( MessageListener tempMessageListener ) {
    super ( "42Unlimited Server" );
    tempMessageListener.messageReceived( "Lobby Initializing..." );
    try {
      serverSocket = new ServerSocket(SERVER_PORT, MAX_CONNECTIONS);
      messageListener = tempMessageListener;
      messageListener.messageReceived( "Lobby set up on port " + SERVER_PORT );
      messageListener.messageReceived( "Lobby accepting up to " + MAX_CONNECTIONS + " concurrent connections" );
    }
    catch ( IOException ioException ) {
      // **** ERROR HANDLING NEEDS TO BE ADJUSTED
      ioException.printStackTrace();
      System.exit(1);
      // **** ERROR HANDLING NEEDS TO BE ADJUSTED
    }
  }

  public void run() {
    messageListener.messageReceived( "Lobby constantly listening for new connections..." );
    while ( keepOnline ) {
      try {
        Socket tempSocket = serverSocket.accept();
        messageListener.messageReceived( "Connection Received from " + tempSocket.getInetAddress() );
        player.add( new Player ( tempSocket, this ) );
      }
      catch (IOException ioException ) {
        System.out.print("Error accepting connection from a client ");
        ioException.printStackTrace();
        System.exit(1);
      }
    }
  }
}
