package fortytwo.server;

/**
 * <p>Title: Forty Two Unlimited</p>
 * <p>Description: Texas Forty Two Game</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: 42Unlimited</p>
 * @author Nathaniel Normandin
 * @version 0.00.01
 */

import java.util.Vector;
import java.net.Socket;
import java.io.DataOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import fortytwo.network.*;

public class Player extends Thread {

  // a String containing the username of the Player.
  public String username;

  // a String containing the password of the Player.
  public String password;

  // a boolean representing if the player is logged in or not.
  public boolean logged_In = false;

  // an int containg the rank of the Player.
  public int rank;

  // a Table representing the table the Player is currently a member of.
  private Table table;

  // a Vector representing the Dominos in the player's hand.
  public Vector hand;

  // networking streams & sockets
  public Socket connection;
  private DataInputStream input;
  private DataOutputStream output;

  // a Lobby to represent the main lobby.
  private Lobby lobby;

  // Player's constructor.  It initializes the hand setting the capacity to
  // 7 ( the total number of Dominos allowed )
  public Player( Socket tempSocket, Lobby tempLobby ) {
    super (  tempSocket.getInetAddress().toString() );
    connection = tempSocket;
    try {
      input = new DataInputStream ( connection.getInputStream() );
      output = new DataOutputStream ( connection.getOutputStream() );
    }
    catch ( IOException ioException ) {
      // **** TODO: FIX ERROR HANDLING
      ioException.printStackTrace();
      System.exit(1);
      // **** FIX ERROR HANDLING
    }
    lobby = tempLobby;
    hand = new Vector( 7 );
  }

  public Player ( String tempUser ) {
    username = tempUser;
  }

  public void login() {
    while ( !logged_In ) {
      try {
        String tempInput = input.readUTF();
        lobby.messageListener.messageReceived( "Message Received from " + connection.getInetAddress());
        Message tempMessage = new Message( tempInput );
        lobby.messageListener.messageReceived( tempMessage.getMessage() );
        if ( tempMessage.getHeader().equals(PlayerLogin.type) ) {
          lobby.messageListener.messageReceived( "Processing Login for " + connection.getInetAddress());
          processLogin( tempMessage );
        }
        else {
          // **** TODO: Error Handling

          // **** TODO: Error Handling
        }
      }
      catch ( IOException ioException) {
        // **** TODO: Fix Error Handling
        ioException.printStackTrace();
        System.exit( 1 );
        // **** TODO: Fix Error Handling
      }
    }
  }

  public void processLogin ( Message loginMessage ) {
    PlayerLogin playerLogin = new PlayerLogin( loginMessage );
    username = playerLogin.getUsername();
    password = playerLogin.getPassword();
    lobby.messageListener.messageReceived( connection.getInetAddress() + " is attemtping to login as " + username);
    if ( true ) {
      logged_In = true;
      lobby.messageListener.messageReceived( connection.getInetAddress() + " logged in as " + username );
      WelcomePlayer tempWelcomePlayer = new WelcomePlayer( "Welcome " + username );
      try {
        output.writeUTF(tempWelcomePlayer.getMessage());
      }
      catch ( IOException ioException ) {
        // **** TODO: Error Handling
        ioException.printStackTrace();
        System.exit(1);
        // **** TODO: Error Handling
      }
    }
    else {

    }
  }

  public void run() {
    while ( logged_In ) {
      try {
        String tempInput = input.readUTF();
        lobby.messageListener.messageReceived( "Message Received from " + username);
        Message tempMessage = new Message( tempInput );
        lobby.messageListener.messageReceived( tempMessage.getMessage() );

      }
      catch ( IOException ioException ) {
        // **** TODO: Error Handling
        ioException.printStackTrace();
        System.exit(1);
        // **** TODO: Error Handling
      }
    }
  }

  // joinTable( Table ) sets the player's instance of table to the one
  // passed.
  public void joinTable ( Table tempTable ) {
    table = tempTable;
  }

  // leaveTable() sets the player's instance of table to null.
  public void leaveTable () {
    table = null;
  }

  // isAtTable() returns true if the Player is currently at a Table. It returns
  // false otherwise.
  public boolean isAtTable() {
    if ( table == null )
      return false;
    else
      return true;
  }

  // equals( Player ) returns true if the player passed is the same as this player.
  public boolean equals ( Player tempPlayer ) {
    if ( connection == null )
      return username.equals( tempPlayer.username );
    else
      return connection.getInetAddress().toString( ).equals( tempPlayer.connection.getInetAddress().toString() );
  }

  // addDominoTohand ( Domino ) adds the domino to the players hand. If the Domino
  // is added successfully, then it returns true. Otherwise it returns false.
  public boolean addDominoToHand ( Domino tempDomino ) {
    // if the hand already has 7 dominos then return false.
    if ( hand.size() < 7 ){
      if ( !hand.contains( tempDomino ) )
        hand.add( tempDomino );
      return true;
    }
    else
      return false;
  }

  // clearHand() removes all Domino from the hand.
  public void clearHand() {
    hand.clear();
  }

  // removeDominoFromHand( Domino ) removes the Domino from the Player's
  // hand. It returns true if successful and false otherwise.
  public void removeDominoFromHand ( Domino tempDomino ) {
    // if the hand has nothing in ignore.
    if ( hand.size() > 0 ) {
      // if the hand contains the domino, remove the domino.
      if ( hand.contains(tempDomino) )
        hand.remove(tempDomino);
    }
  }

}
