package fortytwo.server;

import javax.swing.*;
import java.awt.*;

/**
 * <p>Title: Forty Two Unlimited</p>
 * <p>Description: Texas Forty Two Game</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: 42Unlimited</p>
 * @author Nathaniel Normandin
 * @version 0.00.01
 */
import javax.swing.SwingUtilities;

public class ServerGUI extends JFrame {

  private BorderLayout borderLayout1 = new BorderLayout();
  private JMenuBar menuBar = new JMenuBar();
  private JMenu menu_File = new JMenu();
  private JMenuItem mItem_Start = new JMenuItem();
  private JMenuItem mItem_Stop = new JMenuItem();
  private JMenu menu_Edit = new JMenu();
  private JMenu menu_Help = new JMenu();
  private JMenuItem mItem_About = new JMenuItem();
  private JMenuItem mItem_Exit = new JMenuItem();
  private JScrollPane sp_DisplayArea = new JScrollPane();
  private JTextArea ta_DisplayArea = new JTextArea();
  private JLabel lbl_Progress = new JLabel();
  private MessageListener messageListener;
  private Lobby lobby;


  public ServerGUI() {
    try {
      jbInit();
    }
    catch(Exception ex) {
      ex.printStackTrace();
    }
    messageListener = new MyMessageListener();
    lobby = new Lobby( messageListener );
    lobby.start();
    lbl_Progress.setText( "Lobby running");
  }

  void jbInit() throws Exception {
    this.getContentPane().setBackground(SystemColor.control);
    this.setDefaultCloseOperation(EXIT_ON_CLOSE);
    this.setEnabled(true);
    this.setFont(new java.awt.Font("Arial", 1, 12));
    this.setLocale(java.util.Locale.getDefault());
    //this.setJMenuBar(menuBar);
    this.setResizable(false);
    this.setTitle("42Unlimited");
    this.setSize(650, 500);
    borderLayout1.setHgap(1);
    borderLayout1.setVgap(1);
    this.getContentPane().setLayout(borderLayout1);
    menu_File.setText("File");
    mItem_Start.setText("Start");
    mItem_Stop.setText("Stop");
    menu_Edit.setText("Edit");
    menu_Help.setText("Help");
    mItem_About.setText("About");
    sp_DisplayArea.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
    sp_DisplayArea.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
    sp_DisplayArea.setMaximumSize(new Dimension(620, 420));
    sp_DisplayArea.setMinimumSize(new Dimension(600, 400));
    sp_DisplayArea.setOpaque(true);
    sp_DisplayArea.setPreferredSize(new Dimension(610, 410));
    sp_DisplayArea.setRequestFocusEnabled(false);
    sp_DisplayArea.setVerifyInputWhenFocusTarget(true);
    ta_DisplayArea.setMinimumSize(new Dimension(15, 15));
    ta_DisplayArea.setPreferredSize(new Dimension(600, 400));
    ta_DisplayArea.setEditable(false);
    ta_DisplayArea.setMargin(new Insets(5, 5, 5, 5));
    ta_DisplayArea.setText("Server initializing...");
    ta_DisplayArea.setCaretPosition(ta_DisplayArea.getText().length());
    ta_DisplayArea.setLineWrap(true);
    ta_DisplayArea.setTabSize(5);
    lbl_Progress.setMaximumSize(new Dimension(600, 15));
    lbl_Progress.setMinimumSize(new Dimension(600, 15));
    lbl_Progress.setPreferredSize(new Dimension(600, 15));
    lbl_Progress.setRequestFocusEnabled(false);
    lbl_Progress.setText("Server initializing...");
    mItem_Exit.setText("Exit");
    menuBar.add(menu_File);
    menuBar.add(menu_Edit);
    menuBar.add(menu_Help);
    menu_File.add(mItem_Start);
    menu_File.add(mItem_Stop);
    menu_File.addSeparator();
    menu_File.add(mItem_Exit);
    menu_Help.add(mItem_About);
    this.getContentPane().add(menuBar, BorderLayout.NORTH);
    this.getContentPane().add(sp_DisplayArea, BorderLayout.CENTER);
    this.getContentPane().add(lbl_Progress,  BorderLayout.SOUTH);
    sp_DisplayArea.getViewport().add(ta_DisplayArea, null);
    this.setVisible(true);
  }

  public static void main(String[] args) {
    ServerGUI serverGUI = new ServerGUI();
  }

  public void writeText ( String text ) {
    messageListener.messageReceived( text );
  }

  public void writelnText ( String text ) {
    String tempText = text + "\n";
    messageListener.messageReceived( tempText );
  }

  private class MessageDisplayer implements Runnable {
    private String message;

    // MessageDisplayer constructor
    public MessageDisplayer( String tempMessage ) {
      message = tempMessage;
    }

    public void run() {
      // append new messages
      ta_DisplayArea.append( message + "\n" );

      // move caret to end of ta_DisplayArea
      ta_DisplayArea.setCaretPosition( ta_DisplayArea.getText().length() );
    }
  }

  public class MyMessageListener implements MessageListener {
    public void messageReceived ( String message ) {
      SwingUtilities.invokeLater ( new MessageDisplayer ( message ) );
    }
  }
}
