package fortytwo.testserver;

/**
 * <p>Title: Forty Two Unlimited</p>
 * <p>Description: Texas Forty Two Game</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: 42Unlimited</p>
 * @author Nathaniel Normandin
 * @version 0.00.01
 */
import java.util.Vector;
import java.net.ServerSocket;
import java.net.Socket;
import java.io.IOException;
import fortytwo.network.*;

public class Lobby extends Thread implements LobbyListener{

  public static int SERVER_PORT = 5432;
  public static int MAX_CONNECTIONS = 200;

  private Vector vector_ConnectedPlayers;
  private Vector vector_ChatList;

  private Vector vector_Tables;
  private int tableIterator;

  private ServerSocket serverSocket;
  private boolean keepOnline = true;
  private boolean isConnected = false;

  private MessageListener messageListener;
  private ServerMessageManager messageManager;



  public Lobby( MessageListener tempMessageListener, int port, int connections ) {
    super("42Unlimited Server");
    SERVER_PORT = port;
    MAX_CONNECTIONS = connections;
    tableIterator = 0;
    messageManager = new ServerMessageManager();
    messageManager.addLobbyListener( this );
    vector_ConnectedPlayers = new Vector();
    vector_Tables = new Vector();
    vector_ChatList = new Vector();
    messageListener = tempMessageListener;
    messageListener.messageReceived("Lobby Initializing...");
    try {
      serverSocket = new ServerSocket(SERVER_PORT, MAX_CONNECTIONS);
      messageListener.messageReceived("Lobby set up on port " + SERVER_PORT);
      messageListener.messageReceived("Lobby accepting up to " + MAX_CONNECTIONS +
                                      " concurrent connections" );
      keepOnline = true;
      isConnected = true;
    }
    catch (IOException ioException) {
      messageListener.messageReceived( "Port " + SERVER_PORT + " is already in use.");
      keepOnline = false;
    }
  }

  public void lobbyChatReceived( LobbyChat lobbyChat ) {
    for( int i=0; i < vector_ConnectedPlayers.size(); i++ ){
      Player oPlayer = ( Player ) vector_ConnectedPlayers.get( i );
      oPlayer.lobbyChat( lobbyChat );
    }
  }

  public void removePlayer( Player player ) {
    synchronized (vector_ChatList) {
      vector_ChatList.remove(player.getUsername());
    }
    synchronized( vector_ConnectedPlayers ) {
      vector_ConnectedPlayers.remove(player);
      if ( vector_ChatList.size() > 0 ) {
        for (int i = 0; i < vector_ConnectedPlayers.size(); i++) {
          Player oPlayer = (Player) vector_ConnectedPlayers.get(i);
          oPlayer.lobbyChatList(new LobbyChatList(vector_ChatList));
        }
      }
    }
  }

  public void addChatUser( String username ) {
    synchronized( vector_ChatList ) {
      if (!vector_ChatList.contains(username)) {
        vector_ChatList.add(username);
        synchronized( vector_ConnectedPlayers ) {
          for (int i = 0; i < vector_ConnectedPlayers.size(); i++) {
            Player oPlayer = (Player) vector_ConnectedPlayers.get(i);
            oPlayer.lobbyChatList(new LobbyChatList(vector_ChatList));
          }
        }
        synchronized (vector_ConnectedPlayers) {
          for (int i = 0; i < vector_ConnectedPlayers.size(); i++) {
            Player oPlayer = (Player) vector_ConnectedPlayers.get(i);
            oPlayer.lobbyTableList(new LobbyTableList(vector_Tables));
          }
        }
      }
    }
  }

  public void createTable( CreateTable createTable, Player player ) {
    tableIterator ++;
    String username = player.getUsername();
    Rules rules = createTable.getRules();
    synchronized( vector_Tables ) {
      vector_Tables.add(new Table(tableIterator, player, rules, messageListener, this));
    }

    synchronized( vector_ConnectedPlayers ) {
      for ( int i = 0; i < vector_ConnectedPlayers.size(); i++ ) {
        Player oPlayer = (Player) vector_ConnectedPlayers.get(i);
        oPlayer.lobbyTableList( new LobbyTableList( vector_Tables ) );
      }
    }
  }

  public void joinTable( JoinTable joinTable, Player player ) {
    int iTableNum = joinTable.getTableNumber();
    for ( int i = 0; i < vector_Tables.size(); i++ ){
     Table oTableTemp = (Table) vector_Tables.get(i);
     if ( oTableTemp.getTableNumber() == iTableNum ) {
       synchronized (oTableTemp) {
         if (oTableTemp.isFull()) {
           // case where table is already full.
         }
         else if (player.isAtTable()) {
           // case where player is already at a table
         }
         else {
           oTableTemp.addPlayer(player);
         }
       }
       synchronized (vector_ConnectedPlayers) {
         for (int j = 0; j < vector_ConnectedPlayers.size(); j++) {
           Player oPlayer = (Player) vector_ConnectedPlayers.get(j);
           oPlayer.lobbyTableList(new LobbyTableList(vector_Tables));
         }
       }
       break;
     }
    }
  }

  public boolean isConnected() {
    return isConnected;
  }


  public void run() {

    while ( keepOnline ) {
      try {
        Socket tempSocket = serverSocket.accept();
        vector_ConnectedPlayers.add( new Player ( tempSocket, messageListener, this ) );
        messageListener.messageReceived( "Connection received from " + tempSocket.getInetAddress() );
      }
      catch ( IOException ioException ) {
        System.out.println( "Error accepting messages from clients " );
      }
    }
  }

  public void closeLobby() {
    if ( !serverSocket.isClosed() ) {
      try {

        synchronized (vector_ConnectedPlayers) {
          for (int i = 0; i < vector_ConnectedPlayers.size(); i++) {
            Player oPlayer = (Player) vector_ConnectedPlayers.get(i);
            oPlayer.disconnect();
          }
        }

        keepOnline = false;
        serverSocket.close();
        messageListener.messageReceived( "Lobby stopped." );
        isConnected = false;
      }
      catch (IOException ioException) {
        messageListener.messageReceived("Error closing lobby... ");
        System.out.println("Error closing lobby (closing serverSocket) ");
        ioException.printStackTrace();
      }
    }
  }

  /**
   * removeTable
   *
   * @param oTable Table
   */
  public void removeTable(Table oTable) {
    synchronized( vector_Tables ) {
      if ( vector_Tables.contains( oTable ) )
        vector_Tables.remove( oTable );
    }
  }

}
