package fortytwo.testserver;

import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import java.awt.image.BufferedImage;

/**
 * <p>Title: Forty Two Unlimited</p>
 * <p>Description: Texas Forty Two Game</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: 42Unlimited</p>
 * @author Nathaniel Normandin
 * @version 0.00.01
 */
import javax.swing.SwingUtilities;

public class ServerGUI extends JFrame {

  private MessageListener messageListener = null;
  private Lobby lobby;
  private int port = Lobby.SERVER_PORT;
  private int connections = Lobby.MAX_CONNECTIONS;

  ///////////////////////////////////
  // GUI COMPONENTS
  // main panel for creation of the contentPane
  private JPanel jPanel_main;

  // JMenuBar and components
  private JMenuBar jMB_menuBar;
  private JMenu jMenu_File, jMenu_Edit, jMenu_Help;
  private JMenuItem jMI_Start, jMI_Stop, jMI_Exit, jMI_Clear, jMI_Connections, jMI_Port, jMI_About;

  // ScrollPane and TextArea for displaying all messages
  private JScrollPane jSP_messageArea;
  private JTextArea jTA_messageArea;
  // GUI COMPONENTS END
  ////////////////////////////////////

  public ServerGUI() {
    init();
  }

  public void init() {

    if ( messageListener == null )
      messageListener = new MyMessageListener();
    jPanel_main = new JPanel( new BorderLayout() );
    jPanel_main.setSize( 500, 500 );
    initMenu();
    initMessageArea();
    this.setTitle( "42Unlimited Server");
    this.setContentPane( jPanel_main );
    this.setSize( 500, 400 );
    this.setDefaultCloseOperation(EXIT_ON_CLOSE);
    this.setVisible( true );
  }

  private void initMenu() {
    jMB_menuBar = new JMenuBar();

    jMenu_File = new JMenu( "File" );
    jMenu_Edit = new JMenu( "Edit" );
    jMenu_Help = new JMenu( "Help" );

    jMI_Start = new JMenuItem( "Start" );
    jMI_Start.addActionListener( new StartActionListener() );
    jMI_Start.setEnabled(true);
    jMI_Stop = new JMenuItem( "Stop" );
    jMI_Stop.addActionListener( new StopActionListener() );
    jMI_Stop.setEnabled(false);
    jMI_Exit = new JMenuItem( "Exit" );
    jMI_Exit.addActionListener( new ExitActionListener( this ));

    jMI_Clear = new JMenuItem( "Clear Screen" );
    jMI_Clear.addActionListener( new ClearActionListener() );
    jMI_Connections = new JMenuItem( "Change Max Connections" );
    jMI_Connections.addActionListener( new ConnectionsActionListener() );
    jMI_Port = new JMenuItem( "Change Port" );
    jMI_Port.addActionListener( new PortActionListener() );

    jMI_About = new JMenuItem( "About" );

    jMenu_File.add( jMI_Start );
    jMenu_File.add( jMI_Stop );
    jMenu_File.addSeparator();
    jMenu_File.add( jMI_Exit );

    jMenu_Edit.add( jMI_Clear );
    jMenu_Edit.add( jMI_Port );
    jMenu_Edit.add( jMI_Connections );

    jMenu_Help.add( jMI_About );

    jMB_menuBar.add( jMenu_File );
    jMB_menuBar.add( jMenu_Edit );
    jMB_menuBar.add( jMenu_Help );

    jPanel_main.add( jMB_menuBar, BorderLayout.NORTH );

  }

  public void initMessageArea() {
    jTA_messageArea = new JTextArea("");
    jSP_messageArea = new JScrollPane( jTA_messageArea,
                                       JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED,
                                       JScrollPane.HORIZONTAL_SCROLLBAR_NEVER );
    jSP_messageArea.setSize( 500, 375 );
    jPanel_main.add( jSP_messageArea, BorderLayout.CENTER );
  }

  private class StartActionListener implements ActionListener {
    public void actionPerformed( ActionEvent event ) {
      lobby = new Lobby( messageListener, port, connections );
      if ( lobby.isConnected() ) {
        messageListener.messageReceived( "starting lobby..." );
        lobby.start();
        jMI_Start.setEnabled(false);
        jMI_Stop.setEnabled(true);
        jMI_Port.setEnabled(false);
        jMI_Connections.setEnabled(false);
      }
    }
  }

  private class StopActionListener implements ActionListener {
    public void actionPerformed( ActionEvent event ) {
      if ( lobby != null ) {
        lobby.closeLobby();
        if ( !lobby.isConnected() ) {
          jMI_Start.setEnabled(true);
          jMI_Stop.setEnabled(false);
          jMI_Port.setEnabled(true);
          jMI_Connections.setEnabled(true);
        }
      }
      else {
        jMI_Start.setEnabled(true);
        jMI_Stop.setEnabled(false);
        jMI_Port.setEnabled(true);
        jMI_Connections.setEnabled(true);
      }

    }
  }


  private class ExitActionListener implements ActionListener {
    private JFrame adaptee;
    public ExitActionListener ( JFrame tempAdaptee ) {
      adaptee = tempAdaptee;
    }
    public void actionPerformed( ActionEvent event ) {
      if ( lobby != null )
        if ( lobby.isConnected() )
          lobby.closeLobby();
      System.exit( 0 );
    }
  }


  private class ClearActionListener implements ActionListener {
    public void actionPerformed(ActionEvent event) {
      messageListener.clearReceived();
    }
  }

  private class ConnectionsActionListener implements ActionListener {
    public void actionPerformed( ActionEvent event ) {
      String tempConnections = JOptionPane.showInputDialog( "Set the Max Connections",
                                                            new Integer(lobby.MAX_CONNECTIONS).toString() );
      if ( tempConnections != null )
        connections = new Integer(tempConnections).intValue();
    }

  }

  private class PortActionListener implements ActionListener {
    public void actionPerformed(ActionEvent event) {
      String tempPort = JOptionPane.showInputDialog( "Set the server Port", new Integer(lobby.SERVER_PORT).toString() );
      if ( tempPort != null )
        port = new Integer(tempPort).intValue();
    }
  }


  private class MessageDisplayer implements Runnable {
    private String message;

    // MessageDisplayer constructor
    public MessageDisplayer( String tempMessage ) {
      message = tempMessage;
    }

    public void run() {
      // append new messages
      jTA_messageArea.append( message + "\n" );

      // move caret to end of ta_DisplayArea
      jTA_messageArea.setCaretPosition( jTA_messageArea.getText().length() );
    }
  }

  private class MessageClearer implements Runnable {
    public void run() {
      jTA_messageArea.setText( "" );
    }
  }

  public class MyMessageListener implements MessageListener {
    public void messageReceived ( String message ) {
      SwingUtilities.invokeLater ( new MessageDisplayer ( message ) );
    }

    public void clearReceived () {
      SwingUtilities.invokeLater( new MessageClearer () );
    }
  }

  public static void main ( String[] args ) {
    ServerGUI server = new ServerGUI();
  }
}
