/***
 * game.cpp
 * 10-14-02
 * Nathan Freeburg
 *
 * Implements the game member functions declared in game.h.
 */

#include <iostream.h>
#include <fstream.h>
#include <math.h>
#include <stdlib.h>
#include <time.h>
#include "globals.h"
#include "board.h"
#include "heuristicai.h"
#include "hybridai.h"
#include "game.h"

/***
 * public Game()
 *
 * Constructor for the Game class.  Sets the first turn to
 * player A.
 */
Game::Game()
{
	whoseturn = PLAYER_A;
	players[0] = 1;
	players[1] = 2;
	for(int i=0;i<NUM_PIECES;i++)
		hasMoved[i]=false;
	aiplayer1.setPlayer(PLAYER_A);
	aiplayer2.setPlayer(PLAYER_B);

	fout.open("output.dat",ios::out);
}

/***
 * private void initPieces()
 *
 * This method allows interactively setting the spaces on the board.
 * It would not be used during normal game play, but to set up
 * special situations for testing.
 */
void Game::initPieces()
{
	ofstream dummy("dummy.out",ios::out);
	char answer;
	int x,y;
	int str;
	gameBoard.showBoard(dummy);
	cout << "\n\nAdd a city? (y/n): ";
	cin >> answer;
	while((answer == 'y') || (answer == 'Y'))
	{
		cout << "\n\tEnter x and y coordinates of new city: ";
		cin >> x >> y;
		gameBoard.setCity(x,y);
		gameBoard.showBoard(dummy);
		cout << "\n\nAdd a city? (y/n): ";
		cin >> answer;
	}
	gameBoard.showBoard(dummy);
	cout << "\n\nAdd a piece? (y/n): ";
	cin >> answer;
	while((answer == 'y') || (answer == 'Y'))
	{
		cout << "\nAdd a piece for which side? (a/b): ";
		cin >> answer;
		cout << "\nEnter the strength for the piece: (1-9): ";
		cin >> str;
		cout << "\nEnter the x and y coordinates of the new piece: ";
		cin >> x >> y;
		if ((answer == 'a') || (answer == 'A'))
		{
			gameBoard.setPiece(PLAYER_A, str, x,y);
		}
		else
		{
			gameBoard.setPiece(PLAYER_B, str, x,y);
		}
		gameBoard.showBoard(dummy);
		cout << "\n\nAdd a piece? (y/n): ";
		cin >> answer;
	}

	return;
}

/***
 * private void initPieces(int p,int c)
 *
 * This method initializes the spaces of the board for gameplay.  It
 * places p units for each side and c total cities.
 */
void Game::initPieces(int p, int c)
{
	srand(time(0));

	int x,y,i;
	for(i=0;i<c;i++)
	{
		x = rand() % BOARD_DIM;
		y = rand() % BOARD_DIM;
		gameBoard.setCity(x,y);
	}
	for(i=0;i<p;i++)
	{
		x = rand() % BOARD_DIM;
		y = rand() % BOARD_DIM;
		while((gameBoard.pieceAt(x,y)!=0)||(gameBoard.cityAt(x,y)))
		{
			x = rand() % BOARD_DIM;
			y = rand() % BOARD_DIM;
		}
		gameBoard.setPiece(PLAYER_A,3+(i%4),x,y);
		x = rand() % BOARD_DIM;
		y = rand() % BOARD_DIM;
		while((gameBoard.pieceAt(x,y)!=0)||(gameBoard.cityAt(x,y)))
		{
			x = rand() % BOARD_DIM;
			y = rand() % BOARD_DIM;
		}
		gameBoard.setPiece(PLAYER_B,3+(i%4),x,y);
	}
}

/***
 * public void startGame()
 *
 * This method begins the game.  It prompts the user to choose between
 * manual or automatic setup, calls the appropriate initialization method,
 * and begins a loop to process turns until the game is over.
 */
void Game::startGame()
{
	int answer;
	cout << "\nManual or automatic game setup?\n\t1. Manual\n\t2. Automatic\n";
	cin >> answer;
	if (answer == 1)
	{
		initPieces();
	}
	else
	{
		initPieces(NUM_PIECES,NUM_CITIES);
	}

	char winner;
	cout << "\nPlayer A goes first." << endl;
	while(!gameBoard.gameOver(winner))
	{
		processTurn();
	}
	gameBoard.showBoard(fout);
	if(winner == 0) {
		cout << "\n\nDraw!" << endl;
		fout << "\n\nDraw!" << endl;
	}
	else {
		cout << "\n\nPlayer " << winner << " wins!!!" << endl;
		fout << "\n\nPlayer " << winner << " wins!!!" << endl;
	}
	cin.get();
}

void Game::processTurn()
{
	int turnPlayer;
	if(whoseturn == PLAYER_A)
		turnPlayer = 0;
	else turnPlayer = 1;
	Move theMove;
	char answer;
	gameBoard.showBoard(fout);

	if(players[turnPlayer] == 0)
	{
		cout << "\nTurn for Player " << whoseturn;
		cout << "\nMove a piece? ";
		cin >> answer;
		while((answer == 'y')||(answer == 'Y'))
		{
			theMove = getMove();
			applyMove(theMove);
			gameBoard.showBoard(fout);
			cout << "\nMove another piece? ";
			cin >> answer;
		}
	}
	else if(players[turnPlayer]==1)
	{
		Move* theMoves;
		theMoves = aiplayer1.getBestMove(gameBoard);
		for(int i=0;i<NUM_PIECES;i++)
		{
			cout <<theMoves[i].x1<<' '<<theMoves[i].y1<<' '<<theMoves[i].x2<<' '<<theMoves[i].y2<<endl;
			fout <<theMoves[i].x1<<' '<<theMoves[i].y1<<' '<<theMoves[i].x2<<' '<<theMoves[i].y2<<endl;
			if(theMoves[i].x1>=0)
				applyMove(theMoves[i]);
		}
	}
	else if(players[turnPlayer]==2)
	{
		Move* theMoves;
		theMoves = aiplayer2.getBestMove(gameBoard);
		for(int i=0;i<NUM_PIECES;i++)
		{
			cout <<theMoves[i].x1<<' '<<theMoves[i].y1<<' '<<theMoves[i].x2<<' '<<theMoves[i].y2<<endl;
			fout <<theMoves[i].x1<<' '<<theMoves[i].y1<<' '<<theMoves[i].x2<<' '<<theMoves[i].y2<<endl;
			if(theMoves[i].x1>=0)
				applyMove(theMoves[i]);
		}
	}

	if(turnPlayer) whoseturn = PLAYER_A;
	else whoseturn = PLAYER_B;
	for(int i=0;i<NUM_PIECES;i++)
		hasMoved[i] = false;
}

/***
 * private bool isValidMove(Move m)
 *
 * Tests the move m for validity within the rules of the game.
 */
bool Game::isValidMove(Move m)
{
	if(gameBoard.isValid(m.x1,m.y1,m.x2,m.y2,whoseturn))
		return hasMoved[abs(gameBoard.pieceAt(m.x1,m.y1))];
	else return false;
}

/***
 * private Move getMove()
 *
 * Interactively gets a move from the user.  Checks the move
 * for validity and returns the move.
 */
Move Game::getMove()
{
	Move m;
	cout << "\nMove which piece? ";
	cin >> m.x1 >> m.y1;
	cout << "\nMove to where? ";
	cin >> m.x2 >> m.y2;
	char answer = 'y';
	while(!isValidMove(m))
	{
		cout << "\nInvalid move!  Try again? ";
		cin >> answer;
		if((answer!='y')&&(answer!='Y'))
		{
			m.x1 = m.x2 = m.y1 = m.y2 = -1;
			return m;
		}
		cout << "\nMove which piece? ";
		cin >> m.x1 >> m.y1;
		cout << "\nMove to where? ";
		cin >> m.x2 >> m.y2;
	}
	return m;
}

/***
 * private void applyMove(Move m)
 *
 * This method takes a Move as a parameter and calls the Board class
 * makeMove() method with the elements of the move.
 */
void Game::applyMove(Move m)
{
	if(gameBoard.pieceAt(m.x1,m.y1)!=0)
		hasMoved[abs(gameBoard.pieceAt(m.x1,m.y1))-1] = true;
	gameBoard.makeMove(m.x1,m.y1,m.x2,m.y2);
}
