/***
 * game.h
 * 10-14-02
 * Nathan Freeburg
 *
 * Declarations for the game class.
 */

#ifndef _GAME_H
#define _GAME_H


class Game{
public:
	Game();

	void startGame();


private:
	void initPieces();		// Initialize starting positions and cities interactively.
	void initPieces(int p, int c);	// Initialize starting postions and cities randomly.
	void processTurn();
	bool isValidMove(Move);
	Move getMove();
	void applyMove(Move);

	Board gameBoard;
	char whoseturn;
	int players[2];			// Tracks whether each player is a human or computer player.
	bool hasMoved[NUM_PIECES];
	HeuristicAI aiplayer1;
	HybridAI aiplayer2;

	ofstream fout;
};

#endif