/***
 * hybridai.h
 * 11-06-02
 * Nathan Freeburg
 *
 * Declaration of the HybridAI class.
 */

#ifndef _HYBRID_AI
#define _HYBRID_AI

class HybridAI
{
public:
	HybridAI();
	HybridAI(char);

	Move* getBestMove(const Board);
	void setPlayer(char);

private:
	int calculateValue(const Board, char);
	int maxValue(const Board,int,int,int,int, Move&);
	int minValue(const Board,int,int,int,int, Move&);

	int getMinVal(Board,int,int,int,int, Move&, int,int,int,int);
	int getMaxVal(Board,int,int,int,int, Move&, int,int,int,int);
	void getStrategy(const Board);

	char mySide;
	Move chosen[NUM_PIECES][MAX_DEPTH+1];
	Move* bestMoves;
	int tgtDCity[2];
	int tgtACity[2];
	int tgtUnit[2];
	int target[2];
};

#endif