enum side {TOP, BOTTOM, LEFT, RIGHT};

class Matrix {

  public:

    Matrix();
    Matrix(int x, int y);
    Matrix(Matrix &a);
    ~Matrix();

    void print();
    void write_to_file(ofstream &outfile);
    void input_from_file(ifstream &infile);
    int get_m();
    int get_n();
    float value(int i, int j);
    void set(float x, int i, int j);
    void zero();
    Matrix & trim_ghost_nodes();
    void attachmatrix(Matrix &attachment, side s);
    Matrix & submatrix(int x1, int y1, int x2, int y2);
    Matrix & splice(Matrix &b);
    Matrix & getcolumn(int y);
    Matrix & getrow(int x);
    void prependcolumn(Matrix &col);
    void prependrow(Matrix &row);
    void appendcolumn(Matrix &col);
    void appendrow(Matrix &row);
    void replacecolumn(Matrix &col, int y);
    void replacerow(Matrix &row, int x);
    void sendmatrix(int targetproc);
    void rcvmatrix(int sourceproc);
    Matrix & operator=(Matrix &a);
    Matrix & operator-(Matrix &b);
    Matrix & operator+(Matrix &b);

  private:

    float ** array;
    int m;
    int n;

    void allocate();
    void deallocate();

};

Matrix::Matrix() {

  array = NULL;

  m = -1;
  n = -1;

}

Matrix::Matrix(int x, int y) {

  m = x;
  n = y;

  allocate();

}

Matrix::Matrix(Matrix &a) {

  m = a.m;
  n = a.n;

  array = new (float *)[m];
  for(int i = 0; i < m; i++) {
    array[i] = new float[n];
    for(int j = 0; j < n; j++) array[i][j] = a.array[i][j];
  }

}

Matrix::~Matrix() {

  deallocate();

}

void Matrix::print() {

  cout.setf(ios::showpoint);

  for(int i = 0; i < m; i++) {
    for(int j = 0; j < n; j++) cout << array[i][j] << ' ';
    cout << endl;
  }

}

void Matrix::write_to_file(ofstream &outfile) {

  outfile.setf(ios::showpoint);

  for(int i = 0; i < m; i++) {
    outfile << array[i][0];
    for(int j = 1; j < n; j++) outfile << ' ' << array[i][j];
    outfile << endl;
  }

}

void Matrix::input_from_file(ifstream &infile) {

  char * t;
  Matrix temp(1024, 1024);
  char sbuffer[1024];
  int i, j;

  deallocate();

  for(i = 1; !infile.eof() && infile.peek() != '\n'; i++) { // for each line
    if(infile.getline(sbuffer, sizeof(sbuffer)) == 0) break; // get the whole line
    int j = 1;
    t = strtok(sbuffer, " "); // get an entry
    if(t != NULL) temp.set(atof(t), i, j++); // set value in matrix, increment j
    while((t = strtok(NULL, " ")) != NULL) temp.set(atof(t), i, j++); // do same for all entries on line
    if(n == -1) n = j-1; // if n was not yet set, set it
    else if(n != j-1) {cout << "Invalid input array!" << endl; exit(0);} // if n does not match previous lines
//    temp.set(0, i, 1);
//    temp.set(0, i, n);
  }

  if(infile.peek() == '\n') infile.get();

//  for(int j = 1; j <= n; j++) temp.set(0, 1, j);
//  for(int j = 1; j <= n; j++) temp.set(0, i, j);

  m = i-1;

  // now stick it in a matrix of the correct size
  array = new (float *)[m];
  for(int i = 0; i < m; i++) {
    array[i] = new float[n];
    for(int j = 0; j < n; j++) array[i][j] = temp.value(i+1, j+1);
  }

}

int Matrix::get_m() {

  return m;

}

int Matrix::get_n() {

  return n;

}

float Matrix::value(int i, int j) {

  return array[i-1][j-1];

}

void Matrix::set(float x, int i, int j) {

  array[i-1][j-1] = x;

}

void Matrix::zero() {

  for(int i = 0; i < m; i++) {
    for(int j = 0; j < n; j++) array[i][j] = 0;
  }

}

Matrix & Matrix::trim_ghost_nodes() {

  return submatrix(2, 2, m-1, n-1);

}

void Matrix::attachmatrix(Matrix &attachment, side s) {

  switch (s) {
    case TOP: for(int j = attachment.get_m(); j <= 1; j--) prependrow(attachment.getrow(j)); break;
    case BOTTOM: for(int j = 1; j <= attachment.get_m(); j++) appendrow(attachment.getrow(j)); break;
    case LEFT: for(int i = attachment.get_n(); i <= 1; i--) prependcolumn(attachment.getcolumn(i)); break;
    case RIGHT: for(int i = 1; i <= attachment.get_n(); i++) appendcolumn(attachment.getcolumn(i)); break;
  }

}

Matrix & Matrix::submatrix(int x1, int y1, int x2, int y2) {

  Matrix * sub = new Matrix(x2-x1+1, y2-y1+1);

  for(int i = x1; i <= x2; i++) {
    for(int j = y1; j <= y2; j++) {
      sub->set(array[i-1][j-1], i-x1+1, j-y1+1);
    }
  }

  return (*sub);

}

Matrix & Matrix::splice(Matrix &b) {

  Matrix * attached = new Matrix(m, n + b.n);

  for(int i = 1; i <= m; i++) {
    for(int j = 1; j <= n; j++) {
      attached->set(array[i-1][j-1], i, j);
    }
    for(int j = 1; j <= b.n; j++) {
      attached->set(b.array[i-1][j-1], i, j+n);
    }
  }

  return (*attached);

}

Matrix & Matrix::getcolumn(int y) {

  return submatrix(1, y, m, y);

}

Matrix & Matrix::getrow(int x) {

  return submatrix(x, 1, x, n);

}

void Matrix::prependcolumn(Matrix &col) {

  float buffer[n];

  for(int i = 0; i < m; i++) {
    memcpy(buffer, array[i], sizeof(float) * n);
    array[i] = new float[n+1];
    memcpy(array[i]+1, buffer, sizeof(float) * n);
    array[i][0] = col.array[i][0];
  }

  n++;

}

void Matrix::prependrow(Matrix &row) {

  float * buffer[m];

  memcpy(buffer, array, sizeof(float *) * m);
  array = new (float *)[m+1];
  memcpy(array+1, buffer, sizeof(float *) * m);
  array[0] = new float[n];

  for(int j = 0; j < n; j++) {
    array[0][j] = row.array[0][j];
  }

  m++;

}

void Matrix::appendcolumn(Matrix &col) {

  float buffer[n];

  for(int i = 0; i < m; i++) {
    memcpy(buffer, array[i], sizeof(float) * n);
    array[i] = new float[n+1];
    memcpy(array[i], buffer, sizeof(float) * n);
    array[i][n] = col.array[i][0];
  }

  n++;

}

void Matrix::appendrow(Matrix &row) {

  float * buffer[m];

  memcpy(buffer, array, sizeof(float *) * m);
  array = new (float *)[m+1];
  memcpy(array, buffer, sizeof(float *) * m);
  array[m] = new float[n];

  for(int j = 0; j < n; j++) {
    array[m][j] = row.array[0][j];
  }

  m++;

}

void Matrix::replacecolumn(Matrix &col, int y) {

  for(int i = 1; i <= col.m; i++) {
    array[i-1][y-1] = col.array[i-1][0];
  }

}

void Matrix::replacerow(Matrix &row, int x) {

  for(int j = 1; j <= row.n; j++) {
    array[x-1][j-1] = row.array[0][j-1];
  }

}

void Matrix::sendmatrix(int targetproc) {

  MPI_Send(&m, 1, MPI_INT, targetproc, 1, MPI_COMM_WORLD);
  MPI_Send(&n, 1, MPI_INT, targetproc, 2, MPI_COMM_WORLD);

  for(int i = 1; i <= m; i++) {
    for(int j = 1; j <= n; j++) {
      MPI_Send(&(array[i-1][j-1]), 1, MPI_DOUBLE_PRECISION, targetproc, i*n+j, MPI_COMM_WORLD);
    }
  }

}

void Matrix::rcvmatrix(int sourceproc) {

  MPI_Status status;

  deallocate();

  MPI_Recv(&m, 1, MPI_INT, sourceproc, 1, MPI_COMM_WORLD, &status);
  MPI_Recv(&n, 1, MPI_INT, sourceproc, 2, MPI_COMM_WORLD, &status);

  allocate();

  for(int i = 1; i <= m; i++) {
    for(int j = 1; j <= n; j++) {
      MPI_Recv(&(array[i-1][j-1]), 1, MPI_DOUBLE_PRECISION, sourceproc, i*n+j, MPI_COMM_WORLD, &status);
    }
  }

}

Matrix & Matrix::operator+(Matrix &b) {

  Matrix * c = new Matrix(m, n);

  for(int i = 0; i < m; i++) {
    for(int j = 0; j < n; j++) {
      c->array[i][j] = array[i][j] + b.array[i][j];
    }
  }

  return *c;

}

Matrix & Matrix::operator-(Matrix &b) {

  Matrix * c = new Matrix(m, n);

  for(int i = 0; i < m; i++) {
    for(int j = 0; j < n; j++) {
      c->array[i][j] = array[i][j] - b.array[i][j];
    }
  }

  return *c;

}

Matrix & Matrix::operator=(Matrix &a) {

  deallocate();

  m = a.m;
  n = a.n;

  array = new (float *)[m];
  for(int i = 0; i < m; i++) {
    array[i] = new float[n];
    for(int j = 0; j < n; j++) array[i][j] = a.array[i][j];
  }

  return a;

}

void Matrix::allocate() {

  array = new (float *)[m];
  for(int i = 0; i < m; i++) {
    array[i] = new float[n];
  }

}

void Matrix::deallocate() {

  for(int i = 0; i < m; i++) {
    if(array[i] != NULL) delete [] array[i];
  }
  if(array != NULL) delete [] array;

  m = -1;
  n = -1;

  array = NULL;

}
