using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace SuSCommander
{
	/// <summary>
	/// Summary description for CommanderSettings.
	/// </summary>
	public class CommanderSettings : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Label defaultDBPathLabel;
		private System.Windows.Forms.TextBox dbPathTextbox;
		private System.Windows.Forms.Label defaultLogPathLabel;
		private System.Windows.Forms.TextBox logFilePathTextbox;
		private System.Windows.Forms.Label wanConfigLabel;
		private System.Windows.Forms.TextBox wanConfigTextbox;
		private System.Windows.Forms.Button dbPathSelector;
		private System.Windows.Forms.Button logPathSelector;
		private System.Windows.Forms.Button wanPathSelector;
		private System.Windows.Forms.Button saveButton;
		private System.Windows.Forms.Button cancelButton;
		private System.Windows.Forms.FolderBrowserDialog pathBrowser;
		private System.Windows.Forms.OpenFileDialog fileDialog;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public string dbPath;
		public string logPath;
		public string wanPath;

		public CommanderSettings()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.defaultDBPathLabel = new System.Windows.Forms.Label();
			this.dbPathTextbox = new System.Windows.Forms.TextBox();
			this.defaultLogPathLabel = new System.Windows.Forms.Label();
			this.logFilePathTextbox = new System.Windows.Forms.TextBox();
			this.wanConfigLabel = new System.Windows.Forms.Label();
			this.wanConfigTextbox = new System.Windows.Forms.TextBox();
			this.dbPathSelector = new System.Windows.Forms.Button();
			this.logPathSelector = new System.Windows.Forms.Button();
			this.wanPathSelector = new System.Windows.Forms.Button();
			this.saveButton = new System.Windows.Forms.Button();
			this.cancelButton = new System.Windows.Forms.Button();
			this.fileDialog = new System.Windows.Forms.OpenFileDialog();
			this.pathBrowser = new System.Windows.Forms.FolderBrowserDialog();
			this.SuspendLayout();
			// 
			// defaultDBPathLabel
			// 
			this.defaultDBPathLabel.Location = new System.Drawing.Point(16, 8);
			this.defaultDBPathLabel.Name = "defaultDBPathLabel";
			this.defaultDBPathLabel.Size = new System.Drawing.Size(128, 23);
			this.defaultDBPathLabel.TabIndex = 0;
			this.defaultDBPathLabel.Text = "Default Database Path:";
			this.defaultDBPathLabel.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// dbPathTextbox
			// 
			this.dbPathTextbox.Location = new System.Drawing.Point(24, 32);
			this.dbPathTextbox.Name = "dbPathTextbox";
			this.dbPathTextbox.Size = new System.Drawing.Size(344, 20);
			this.dbPathTextbox.TabIndex = 1;
			this.dbPathTextbox.Text = "c:\\wan.mdb";
			// 
			// defaultLogPathLabel
			// 
			this.defaultLogPathLabel.Location = new System.Drawing.Point(16, 72);
			this.defaultLogPathLabel.Name = "defaultLogPathLabel";
			this.defaultLogPathLabel.Size = new System.Drawing.Size(120, 23);
			this.defaultLogPathLabel.TabIndex = 2;
			this.defaultLogPathLabel.Text = "Default Log File Path:";
			this.defaultLogPathLabel.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// logFilePathTextbox
			// 
			this.logFilePathTextbox.Location = new System.Drawing.Point(24, 96);
			this.logFilePathTextbox.Name = "logFilePathTextbox";
			this.logFilePathTextbox.Size = new System.Drawing.Size(344, 20);
			this.logFilePathTextbox.TabIndex = 3;
			this.logFilePathTextbox.Text = "C:\\Documents and Settings\\exception\\Desktop\\SusParser\\Log Files";
			// 
			// wanConfigLabel
			// 
			this.wanConfigLabel.Location = new System.Drawing.Point(16, 136);
			this.wanConfigLabel.Name = "wanConfigLabel";
			this.wanConfigLabel.Size = new System.Drawing.Size(128, 23);
			this.wanConfigLabel.TabIndex = 4;
			this.wanConfigLabel.Text = "Wan Configuration File:";
			this.wanConfigLabel.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// wanConfigTextbox
			// 
			this.wanConfigTextbox.Location = new System.Drawing.Point(24, 160);
			this.wanConfigTextbox.Name = "wanConfigTextbox";
			this.wanConfigTextbox.Size = new System.Drawing.Size(344, 20);
			this.wanConfigTextbox.TabIndex = 5;
			this.wanConfigTextbox.Text = "C:\\Documents and Settings\\exception\\Desktop\\SusParser\\bin\\Debug\\wan.cfg";
			// 
			// dbPathSelector
			// 
			this.dbPathSelector.Location = new System.Drawing.Point(384, 32);
			this.dbPathSelector.Name = "dbPathSelector";
			this.dbPathSelector.TabIndex = 6;
			this.dbPathSelector.Text = "Browse";
			this.dbPathSelector.Click += new System.EventHandler(this.dbPathSelector_Click);
			// 
			// logPathSelector
			// 
			this.logPathSelector.Location = new System.Drawing.Point(384, 96);
			this.logPathSelector.Name = "logPathSelector";
			this.logPathSelector.TabIndex = 7;
			this.logPathSelector.Text = "Browse";
			this.logPathSelector.Click += new System.EventHandler(this.logPathSelector_Click);
			// 
			// wanPathSelector
			// 
			this.wanPathSelector.Location = new System.Drawing.Point(384, 160);
			this.wanPathSelector.Name = "wanPathSelector";
			this.wanPathSelector.TabIndex = 8;
			this.wanPathSelector.Text = "Browse";
			this.wanPathSelector.Click += new System.EventHandler(this.wanPathSelector_Click);
			// 
			// saveButton
			// 
			this.saveButton.Location = new System.Drawing.Point(128, 208);
			this.saveButton.Name = "saveButton";
			this.saveButton.TabIndex = 9;
			this.saveButton.Text = "Save";
			this.saveButton.Click += new System.EventHandler(this.saveButton_Click);
			// 
			// cancelButton
			// 
			this.cancelButton.Location = new System.Drawing.Point(256, 208);
			this.cancelButton.Name = "cancelButton";
			this.cancelButton.TabIndex = 10;
			this.cancelButton.Text = "Cancel";
			this.cancelButton.Click += new System.EventHandler(this.cancelButton_Click);
			// 
			// CommanderSettings
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(480, 245);
			this.Controls.Add(this.cancelButton);
			this.Controls.Add(this.saveButton);
			this.Controls.Add(this.wanPathSelector);
			this.Controls.Add(this.logPathSelector);
			this.Controls.Add(this.dbPathSelector);
			this.Controls.Add(this.wanConfigTextbox);
			this.Controls.Add(this.wanConfigLabel);
			this.Controls.Add(this.logFilePathTextbox);
			this.Controls.Add(this.defaultLogPathLabel);
			this.Controls.Add(this.dbPathTextbox);
			this.Controls.Add(this.defaultDBPathLabel);
			this.Name = "CommanderSettings";
			this.Text = "Commander Settings";
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Gets the path where the database is stored
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void dbPathSelector_Click(object sender, System.EventArgs e)
		{
			fileDialog = new OpenFileDialog();

			if(fileDialog.ShowDialog() == DialogResult.OK)
			{
				dbPathTextbox.Text = fileDialog.FileName;
				dbPath = fileDialog.FileName;
				Console.WriteLine(dbPath);
			}
			else
				Console.WriteLine("bljgklagjalkd");
		}

		/// <summary>
		/// Gets the path where the log files are stored
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void logPathSelector_Click(object sender, System.EventArgs e)
		{
			pathBrowser = new FolderBrowserDialog();

			if(pathBrowser.ShowDialog() == DialogResult.OK)
			{
				logFilePathTextbox.Text = pathBrowser.SelectedPath;
				logPath = pathBrowser.SelectedPath;
				Console.WriteLine(logPath);
			}
		}

		/// <summary>
		/// Gets the path to the wan file
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void wanPathSelector_Click(object sender, System.EventArgs e)
		{
			fileDialog = new OpenFileDialog();

			if(fileDialog.ShowDialog() == DialogResult.OK)
			{
				wanConfigTextbox.Text = fileDialog.FileName;
				wanPath = fileDialog.FileName;
				Console.WriteLine(wanPath);
			}
		}

		/// <summary>
		/// Closes dialog for processing by parent
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void saveButton_Click(object sender, System.EventArgs e)
		{
			dbPath = dbPathTextbox.Text;
			logPath = logFilePathTextbox.Text;
			wanPath = wanConfigTextbox.Text;

			if(dbPathTextbox.Text == "" || logFilePathTextbox.Text == "" || wanConfigTextbox.Text == "")
				Console.WriteLine("Invalid settings");
			else
			{
				Console.WriteLine(dbPath + "\n" + logPath + "\n" + wanPath);

				DialogResult = DialogResult.OK;
			}
		}

		/// <summary>
		/// Closes dialog with no processing by parent
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cancelButton_Click(object sender, System.EventArgs e)
		{
			DialogResult = DialogResult.Cancel;
		}
	}
}
