using System;

namespace SuSCommander
{
	/// <summary>
	/// The Date class contains a compare method to decide if a
	/// date is less than or greater than another game.
	/// </summary>
	public class Date
	{
		//public variables
		public int day, month, year;
		public String color = "FFFFFF";
		public int numDaysInYear = 365;

		/**
		  *The default constructor. Sets all of the date fields to zero
		*/
		public Date() 
		{
			day = month = year = 0;
		}

		/**
		  *Custom constructor. User-specified values for each date field
		  *are set
		  *@param newMonth the value the month field in the date will be set to
		  *@param newDay   the value the day field in the date will be set to
		  *@param newYear  the value the year field will be set to
		*/
		public Date(int newMonth, int newDay, int newYear) 
		{
			day = newDay;
			month = newMonth;
			year = newYear;
		}

		/**
		  *Comparison statement. Compares implicit and explicit paramters
		  *@param otherDate the date to compare to
		*/
		public int compareTo(Date otherDate) 
		{
			//constants to return whether the implicit parameter is less, equal,
			//or greater than the explicit
			int EQUAL = 0;
			int SMALLER = -1;
			int GREATER = 1;

			//compare year
			if(year == otherDate.year) 
			{
				//compare months
				if(month == otherDate.month) 
				{
					//compare days
					if(day == otherDate.day)
						return EQUAL;
					else if(day < otherDate.day)
						return SMALLER;
					else
						return GREATER;
				}
				else if(month < otherDate.month)
					return SMALLER;
				else
					return GREATER;
			}
			else if(year < otherDate.year)
				return SMALLER;
			else
				return GREATER;
		}

		/**
		  *toString method for returning a date in string format (month-day-year)
		*/
		public String toString() 
		{
			String sMonth, sDay;
			if(month < 10)
				sMonth = "0" + month;
			else
				sMonth = month + "";
			if(day < 10)
				sDay = "0" + day;
			else
				sDay = day + "";
			return "" + sMonth + "-" + sDay + "-" + year;
		}

		/**
		  *getDaysOutOfYear gets the number of days since jan 1...used to determine
		  *the number of days between dates
		*/
		public int getDaysOutOfYear()
		{
			int dayCount = 0;
			int[] months = new int[12];
			months[0] = 31;
			months[1] = 28;
			months[2] = 31;
			months[3] = 30;
			months[4] = 31;
			months[5] = 30;
			months[6] = 31;
			months[7] = 31;
			months[8] = 30;
			months[9] = 31;
			months[10] = 30;
			months[11] = 31;

			//check for leap year
			if(year%4 == 0)
			{
				months[1] = 29;
			}

			for(int i = 0; i < month; i++)
				dayCount += months[i];

			dayCount -= ((months[month - 1]) - day);
			return dayCount;
		}

		public int isLeapYear(int tempYear)
		{
			if(tempYear%4 == 0)
				numDaysInYear = 366;
			else
				numDaysInYear = 365;

			return numDaysInYear;
		}

		/**
		  *dateDiff returns the number of days between two dates
		*/
		public int dateDiff(Date a, Date b)
		{
			//System.out.print(a + "\t" + b + "\t");
			//init difference to 0 (dates are the same)
			int difference = 0;

			//if the years are different
			if(a.year != b.year)
			{
				//var to hold the number of days until the new year
				int restOfYear = 0;
				//if date A's year is > than b's year
				if(a.year > b.year)
				{
					//calculate the num of days between b's date and the new year
					for(int i = 1; i <= (a.year - b.year); i++)
						difference = difference + isLeapYear(b.year+i);
					//calculate the num of days into the year for A
					difference = difference + a.getDaysOutOfYear();
					//return the difference
					//System.out.print(difference + "\n");
					return difference;
				}
				else
				{
					//calculate the num of days between a's date and the new year
					for(int i = 1; i <= (b.year - a.year); i++)
						difference = difference + isLeapYear(a.year+i);
					//calculate the num of days into the year for b
					difference = difference + b.getDaysOutOfYear();
					//return the difference
					//System.out.print(difference + "\n");
					return difference;

				}
			}
			else
			{
				int daysForA = a.getDaysOutOfYear();
				int daysForB = b.getDaysOutOfYear();
				if(daysForA == daysForB)
				{
					//System.out.print("0\n");
					return 0;
				}
				else if(daysForA > daysForB)
				{
					//System.out.print((daysForA - daysForB) + "\n");
					return daysForA - daysForB;
				}
				else if(daysForB > daysForA)
				{
					//System.out.print((daysForB - daysForA) + "\n");
					return daysForB - daysForA;
				}
				else
					return -1;
			}
		}
	}
}
