using System;

namespace SuSCommander
{
	/// <summary>
	/// Summary description for IPAddress.
	/// </summary>
	public class IPAddress
	{
		//the octets of the ip address
		public int segOne;
		public int segTwo;
		public int segThree;
		public int segFour;

		/*
			date variables to keep track of the newest update
			in the cumulative file
		*/
		public Date updateTime;

		/**
			* The default constructor of the IPAddress class.
			* This sets all of the octets to 0 and written to
			* false
		*/
		public IPAddress()	
		{
			//set each octet to zero
			segOne = 0;
			segTwo = 0;
			segThree = 0;
			segFour = 0;
			updateTime = new Date(0, 0, 0);
		}

		/**
			* A custom constructor for specifying setting each
			* octet to a specific value
			* @param w for the first octet
			* @param x for the second octet
			* @param y for the third octet
			* @param z for the final octet
		*/
		public IPAddress(int w, int x, int y, int z) 
		{
			//assign the user-specified values to each octet
			segOne = w;
			segTwo = x;
			segThree = y;
			segFour = z;
			updateTime = new Date(0, 0, 0);
		}

		/**
			* The toString method is used when printing out the
			* IP address to a console or file. It creates a String
			* object which contains the octets of the IP Address.
			* @return String The final IP Address in the form of a String
		*/
		public String toString() 
		{
			return (segOne + "." + segTwo + "." + segThree + "." + segFour);
		}

		/**
			* The compareTo method compares two IP addresses and
			* returns whether the IP address is smaller, equal, or
			* larger than the one it is being compared to.
			* @return int -1 if the ip is smaller
			* @return int 0 if the ip is equal
			* @return int 1 if the ip is larger
		*/
		public int compareTo(Object ip)	
		{
			/*
				constant integers that range from -1 to 1 which
				represents equality
			*/
			int SMALLER = -1;
			int EQUAL = 0;
			int LARGER = 1;

			//cast the generic object to an IPAddress object
			IPAddress otherIP = (IPAddress)ip;

			/*
				if the first octets of each IP address are equal
				check the next octet
			*/
			if(segOne - otherIP.segOne == 0) 
			{
				/*
					if the second octets of each IP address are equal
					check the next octet
				*/
				if(segTwo - otherIP.segTwo == 0) 
				{
					/*
						if the third octets of each IP address are equal
						check the last octet
					*/
					if(segThree - otherIP.segThree == 0) 
					{
						/*
							if the last octets are equal, the IP address are
							the same. Return EQUAL
						*/
						if(segFour - otherIP.segFour == 0)
							return EQUAL;
							/*
								if the difference of the last octets is negative,
								the IP addresses are not the same. Return SMALLER
							*/
						else if(segFour - otherIP.segFour < 0)
							return SMALLER;
							/*
								if the difference of the last octets is positive,
								the IP addresses are not the same. Return LARGER
							*/
						else
							return LARGER;
					}
						/*
							if the difference of the second octets is negative,
							the IP addresses are not the same. Return SMALLER
						*/
					else if(segThree - otherIP.segThree < 0)
						return SMALLER;
						/*
							if the difference of the second octets is positive,
							the IP addresses are not the same. Return LARGER
						*/
					else
						return LARGER;
				}
					/*
						if the difference of the second octets is negative,
						the IP addresses are not the same. Return SMALLER
					*/
				else if(segTwo - otherIP.segTwo < 0)
					return SMALLER;
					/*
						if the difference of the second octets is positive,
						the IP addresses are not the same. Return LARGER
					*/
				else
					return LARGER;
			}
				/*
					if the difference of the first octets is negative,
					the IP addresses are not the same. Return SMALLER
				*/
			else if(segOne - otherIP.segOne < 0)
				return SMALLER;
				/*
					if the difference of the first octets is positive,
					the IP addresses are not the same. Return LARGER
				*/
			else
				return LARGER;
		}
	}
}
