using System;
using System.IO;
using System.Data;
using System.Data.OleDb;
using System.Text.RegularExpressions;

namespace SuSCommander
{
	/// <summary>
	/// The parser class does the actual parsing of the log files. It then takes
	/// that information and enters it into the designated data table.
	/// </summary>
	public class Parser
	{
		private DataTable table;
		private OleDbDataAdapter adapter;
		
		//Regular Expressions
		
		//								y    d	m
		//date in the following format: ####-##-##
		Regex date = new Regex(@"(\d)(\d)(\d)(\d)-(\d)(\d)-(\d)(\d)");
		
		//								h  m  s
		//time in the following format: ##:##:##
		Regex time = new Regex(@"(\d)(\d):(\d)(\d):(\d)(\d)");
		
		//ip in the following format: ###.###.###.###
		Regex ip = new Regex(@"(\d)(\d)(\d)%2E(\d{3}|\d{2})%2E(\d{3}|\d{2})%2E(\d{3}|\d{2}|\d{1})");

		public string logFileDate = "";
		public string updateTime = "";
		public string srcIP = "";
		public string cIP = "";
		public Parser()
		{
	
		}


		public int parseLine(string line)
		{
			if(line.Substring(0, 1) == "#")
			{
				//Console.WriteLine("Commented Line");
				return -1;
			}
			if(line.IndexOf("GET") == -1)
			{
				//Console.WriteLine("Not a get command");
				return -1;
			}

			logFileDate = (Regex.Match(line, @"(\d)(\d)(\d)(\d)-(\d)(\d)-(\d)(\d)")).Value;
			updateTime = (Regex.Match(line, @"(\d)(\d):(\d)(\d):(\d)(\d)")).Value;
			MatchCollection ips = Regex.Matches(line, @"(\d)(\d)(\d)\.(\d{3}|\d{2})\.(\d{3}|\d{2})\.(\d{3}|\d{2}|\d{1})");
			if(ips.Count < 2)
			{
				//Console.WriteLine("There weren't two IP's");
				return -1;
			}
			srcIP = ips[0].Value;
			cIP = ips[1].Value;
			
			//Console.WriteLine(logFileDate + " " + updateTime + " " + srcIP + " " + cIP);

			return 1;
		}
	}
}
