using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.IO;
using System.Data;
using System.Data.OleDb;
using System.Net;

namespace SuSCommander
{
	/// <summary>
	/// Summary description for Parser.
	/// </summary>
	public class ParserUI : System.Windows.Forms.Form
	{
		private System.Windows.Forms.FolderBrowserDialog folderBrowser;
		private System.Windows.Forms.ListBox fileList;
		private DataTable table;
		private OleDbDataAdapter adapter;
		private System.Windows.Forms.StatusBar parserStatusbar;
		private System.Windows.Forms.Button folderBrowserButton;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.TextBox defaultPathTextbox;
		private System.Windows.Forms.Button parseFilesButton;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.Button selectAllButton;
		private System.Windows.Forms.Button deSelectAllButton;
		private System.Windows.Forms.Button closeButton;
		private System.Windows.Forms.ProgressBar overallProgress;
		private System.Windows.Forms.ProgressBar currentProgress;
		private System.Windows.Forms.CheckBox resolveHostnameCheckbox;
		private System.Windows.Forms.GroupBox optionsCollection;
		private System.Windows.Forms.CheckBox replaceAllCheckbox;
		private string defaultPath = "";
		private System.Windows.Forms.CheckBox locationUpdateCheckbox;
		private Location[] locations;

		public ParserUI(DataTable dTable, OleDbDataAdapter dAdapter, ArrayList locs)
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
			table = dTable;
			adapter = dAdapter;
			locations = new Location[locs.Count];
			for(int i = 0; i < locs.Count; i++)
				locations[i] = (Location)(locs[i]);		
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.folderBrowserButton = new System.Windows.Forms.Button();
			this.fileList = new System.Windows.Forms.ListBox();
			this.folderBrowser = new System.Windows.Forms.FolderBrowserDialog();
			this.parserStatusbar = new System.Windows.Forms.StatusBar();
			this.defaultPathTextbox = new System.Windows.Forms.TextBox();
			this.label1 = new System.Windows.Forms.Label();
			this.parseFilesButton = new System.Windows.Forms.Button();
			this.selectAllButton = new System.Windows.Forms.Button();
			this.deSelectAllButton = new System.Windows.Forms.Button();
			this.closeButton = new System.Windows.Forms.Button();
			this.overallProgress = new System.Windows.Forms.ProgressBar();
			this.currentProgress = new System.Windows.Forms.ProgressBar();
			this.resolveHostnameCheckbox = new System.Windows.Forms.CheckBox();
			this.optionsCollection = new System.Windows.Forms.GroupBox();
			this.locationUpdateCheckbox = new System.Windows.Forms.CheckBox();
			this.replaceAllCheckbox = new System.Windows.Forms.CheckBox();
			this.optionsCollection.SuspendLayout();
			this.SuspendLayout();
			// 
			// folderBrowserButton
			// 
			this.folderBrowserButton.Location = new System.Drawing.Point(408, 40);
			this.folderBrowserButton.Name = "folderBrowserButton";
			this.folderBrowserButton.Size = new System.Drawing.Size(72, 23);
			this.folderBrowserButton.TabIndex = 1;
			this.folderBrowserButton.Text = "Browse";
			this.folderBrowserButton.Click += new System.EventHandler(this.folderBrowserButton_Click);
			// 
			// fileList
			// 
			this.fileList.Location = new System.Drawing.Point(0, 0);
			this.fileList.Name = "fileList";
			this.fileList.SelectionMode = System.Windows.Forms.SelectionMode.MultiSimple;
			this.fileList.Size = new System.Drawing.Size(136, 264);
			this.fileList.TabIndex = 2;
			// 
			// parserStatusbar
			// 
			this.parserStatusbar.Location = new System.Drawing.Point(0, 279);
			this.parserStatusbar.Name = "parserStatusbar";
			this.parserStatusbar.Size = new System.Drawing.Size(488, 22);
			this.parserStatusbar.TabIndex = 3;
			this.parserStatusbar.Text = "File List Generated";
			// 
			// defaultPathTextbox
			// 
			this.defaultPathTextbox.Location = new System.Drawing.Point(144, 40);
			this.defaultPathTextbox.Name = "defaultPathTextbox";
			this.defaultPathTextbox.Size = new System.Drawing.Size(256, 20);
			this.defaultPathTextbox.TabIndex = 4;
			this.defaultPathTextbox.Text = "";
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(144, 16);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(120, 16);
			this.label1.TabIndex = 5;
			this.label1.Text = "Default Log Directory";
			this.label1.TextAlign = System.Drawing.ContentAlignment.BottomLeft;
			// 
			// parseFilesButton
			// 
			this.parseFilesButton.Location = new System.Drawing.Point(216, 240);
			this.parseFilesButton.Name = "parseFilesButton";
			this.parseFilesButton.Size = new System.Drawing.Size(120, 23);
			this.parseFilesButton.TabIndex = 8;
			this.parseFilesButton.Text = "Import Selected Files";
			this.parseFilesButton.Click += new System.EventHandler(this.parseFilesButton_Click);
			// 
			// selectAllButton
			// 
			this.selectAllButton.Location = new System.Drawing.Point(144, 72);
			this.selectAllButton.Name = "selectAllButton";
			this.selectAllButton.Size = new System.Drawing.Size(64, 23);
			this.selectAllButton.TabIndex = 9;
			this.selectAllButton.Text = "Select All";
			this.selectAllButton.Click += new System.EventHandler(this.selectAllButton_Click);
			// 
			// deSelectAllButton
			// 
			this.deSelectAllButton.Location = new System.Drawing.Point(216, 72);
			this.deSelectAllButton.Name = "deSelectAllButton";
			this.deSelectAllButton.Size = new System.Drawing.Size(80, 23);
			this.deSelectAllButton.TabIndex = 10;
			this.deSelectAllButton.Text = "De-Select All";
			this.deSelectAllButton.Click += new System.EventHandler(this.deSelectAllButton_Click);
			// 
			// closeButton
			// 
			this.closeButton.Location = new System.Drawing.Point(384, 240);
			this.closeButton.Name = "closeButton";
			this.closeButton.TabIndex = 11;
			this.closeButton.Text = "Close";
			this.closeButton.Click += new System.EventHandler(this.closeButton_Click);
			// 
			// overallProgress
			// 
			this.overallProgress.Location = new System.Drawing.Point(360, 280);
			this.overallProgress.Name = "overallProgress";
			this.overallProgress.Size = new System.Drawing.Size(100, 16);
			this.overallProgress.TabIndex = 12;
			// 
			// currentProgress
			// 
			this.currentProgress.Location = new System.Drawing.Point(256, 280);
			this.currentProgress.Name = "currentProgress";
			this.currentProgress.Size = new System.Drawing.Size(100, 16);
			this.currentProgress.TabIndex = 13;
			// 
			// resolveHostnameCheckbox
			// 
			this.resolveHostnameCheckbox.Location = new System.Drawing.Point(16, 24);
			this.resolveHostnameCheckbox.Name = "resolveHostnameCheckbox";
			this.resolveHostnameCheckbox.Size = new System.Drawing.Size(128, 24);
			this.resolveHostnameCheckbox.TabIndex = 14;
			this.resolveHostnameCheckbox.Text = "Resolve Hostnames";
			// 
			// optionsCollection
			// 
			this.optionsCollection.Controls.Add(this.locationUpdateCheckbox);
			this.optionsCollection.Controls.Add(this.replaceAllCheckbox);
			this.optionsCollection.Controls.Add(this.resolveHostnameCheckbox);
			this.optionsCollection.Location = new System.Drawing.Point(144, 112);
			this.optionsCollection.Name = "optionsCollection";
			this.optionsCollection.Size = new System.Drawing.Size(336, 100);
			this.optionsCollection.TabIndex = 15;
			this.optionsCollection.TabStop = false;
			this.optionsCollection.Text = "Parse Options";
			// 
			// locationUpdateCheckbox
			// 
			this.locationUpdateCheckbox.Location = new System.Drawing.Point(16, 64);
			this.locationUpdateCheckbox.Name = "locationUpdateCheckbox";
			this.locationUpdateCheckbox.Size = new System.Drawing.Size(120, 24);
			this.locationUpdateCheckbox.TabIndex = 16;
			this.locationUpdateCheckbox.Text = "Re-Enter Locations";
			// 
			// replaceAllCheckbox
			// 
			this.replaceAllCheckbox.Location = new System.Drawing.Point(176, 24);
			this.replaceAllCheckbox.Name = "replaceAllCheckbox";
			this.replaceAllCheckbox.Size = new System.Drawing.Size(112, 24);
			this.replaceAllCheckbox.TabIndex = 15;
			this.replaceAllCheckbox.Text = "Full Replacement";
			// 
			// ParserUI
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(488, 301);
			this.Controls.Add(this.optionsCollection);
			this.Controls.Add(this.currentProgress);
			this.Controls.Add(this.overallProgress);
			this.Controls.Add(this.closeButton);
			this.Controls.Add(this.deSelectAllButton);
			this.Controls.Add(this.selectAllButton);
			this.Controls.Add(this.parseFilesButton);
			this.Controls.Add(this.label1);
			this.Controls.Add(this.defaultPathTextbox);
			this.Controls.Add(this.parserStatusbar);
			this.Controls.Add(this.fileList);
			this.Controls.Add(this.folderBrowserButton);
			this.Name = "ParserUI";
			this.SizeGripStyle = System.Windows.Forms.SizeGripStyle.Hide;
			this.Text = "Log File Selector";
			this.optionsCollection.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Browses for the folder where the log files are kept
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void folderBrowserButton_Click(object sender, System.EventArgs e)
		{
			DialogResult result = folderBrowser.ShowDialog();

			if(result == DialogResult.OK)
			{
				defaultPathTextbox.Text = folderBrowser.SelectedPath;
				defaultPath = folderBrowser.SelectedPath;
				DirectoryInfo di = new DirectoryInfo(folderBrowser.SelectedPath);
				FileInfo[] fi = di.GetFiles("*.log");

				foreach(FileInfo file in fi)
				{
					fileList.Items.Add(file.Name);     
				}
			}
		}

		/// <summary>
		/// Selects all of the log files
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void selectAllButton_Click(object sender, System.EventArgs e)
		{
			for(int i = 0; i < fileList.Items.Count; i++)
				fileList.SetSelected(i, true);		
		}

		/// <summary>
		/// De-selects all of the log files
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void deSelectAllButton_Click(object sender, System.EventArgs e)
		{
			for(int i = 0; i < fileList.Items.Count; i++)
				fileList.SetSelected(i, false);		
		}

		/// <summary>
		/// Creates the parser and iterates through each of the selected files
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void parseFilesButton_Click(object sender, System.EventArgs e)
		{			
			if(fileList.SelectedItems.Count > 1)
			{
				//parserStatusbar.Text = "More than 1 selected";
				overallProgress.Maximum = fileList.SelectedItems.Count;
				overallProgress.Minimum = 0;
				for(int i = 0; i < fileList.Items.Count; i++)
				{
					if(fileList.GetSelected(i))
					{
						parseFile((string)(fileList.Items[i]));
						overallProgress.Increment(1);
					}

				}

			}
			else if(fileList.SelectedItems.Count == 1)
			{
				overallProgress.Maximum = 1;
				overallProgress.Minimum = 0;
				parseFile((string)(fileList.SelectedItem));
				overallProgress.Increment(1);
			}
			else
			{
				parserStatusbar.Text = "Please select one or more log files";
				//no file selected
			}
			currentProgress.Value = 0;
			overallProgress.Value = 0;
			parserStatusbar.Text = "Selected Files Successfully Imported";
		}

		/// <summary>
		/// Closes the window
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void closeButton_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		/// <summary>
		/// Reads in the files.
		/// </summary>
		/// <param name="file"></param>
		private void parseFile(string file)
		{
			//get the total number of lines in the current text file. This is used for the local progress bar
			int lineCount = 0;
			StreamReader lineReader = new StreamReader(defaultPath + "\\" + file);
			while(lineReader.ReadLine() != null)
			{
				lineCount++;
			}
			lineReader.Close();
			//Console.WriteLine("Number of lines: " + lineCount);
			currentProgress.Maximum = lineCount;
			currentProgress.Minimum = 0;
			currentProgress.Value = 0;


			parserStatusbar.Text = "Parsing File: " + file;
			Parser parser = new Parser();
				
			StreamReader reader = new StreamReader(defaultPath + "\\" + file);
			//Console.WriteLine("Reading File: file");
			string tempLine = reader.ReadLine();
			int count = 0;
			//main loop. This iterates through all of the lines of text in the log files
			while(tempLine != null)
			{
				//Console.WriteLine("In master loop");

				//draw the spinning thingy so you know that the program hasn't halted....
				int remainder = count % 4;
				switch(remainder)
				{
					case 0:
						parserStatusbar.Text = "Parsing File: " + file + "    |";
						break;
					case 1:
						parserStatusbar.Text = "Parsing File: " + file + "    /";
						break;
					case 2:
						parserStatusbar.Text = "Parsing File: " + file + "    --";
						break;
					case 3:
						parserStatusbar.Text = "Parsing File: " + file + "    \\";
						break;
				}
				//if information was extracted from the line of text successfully.
				int success = parser.parseLine(tempLine);
				//parserStatusbar.Text = tempLine;
				if(success != -1)
				{
					//test to see if the ip is already entered in the database
					DataRow testRow = table.Rows.Find(parser.srcIP);
					if(testRow != null)
					{
						//Console.WriteLine("Row already in the db");
						//if the user want's to update the location of entries, do so
						if(locationUpdateCheckbox.Checked)
						{
							string[] ip = parser.srcIP.Split('.');
							IPAddress currentIP = new IPAddress(Int32.Parse(ip[0]), Int32.Parse(ip[1]), Int32.Parse(ip[2]), Int32.Parse(ip[3]));

							for(int i = 0; i < locations.Length; i++)
							{
								//if the ip falls in the range of the current location, set it's name
								if((currentIP.compareTo(locations[i].floor) == 1 && currentIP.compareTo(locations[i].ceiling) == -1) || currentIP.compareTo(locations[i].floor) == 0 || currentIP.compareTo(locations[i].ceiling) == 0)
								{
									//newRow["RegionName"] = locations[i].name;
									testRow["RegionName"] = locations[i].name;
									//Console.WriteLine(locations[i].name);
									break;
								}
								else
									testRow["RegionName"] = "";
							}
							adapter.Update(table);
						}
						//Console.WriteLine("getting date, time, etc..");
						//the ip was already in the db. compare dates to see if the log file is newer
						string[] splitCurrent = ((string)(testRow["UpdateDate"])).Split('-');
						Date current = new Date(Convert.ToInt32(splitCurrent[1]), Convert.ToInt32(splitCurrent[2]), Convert.ToInt32(splitCurrent[0]));
						string[] splitNewDate = (parser.logFileDate).Split('-');
						Date newDate = new Date(Convert.ToInt32(splitNewDate[1]), Convert.ToInt32(splitNewDate[2]), Convert.ToInt32(splitNewDate[0]));
						if(newDate.compareTo(current) == 1)
						{
							//Console.WriteLine("Date is newer in the file");
							//the ip in the log file is newer. Update the updatedate in the database
							try
							{
								testRow["UpdateDate"] = parser.logFileDate;
								testRow["UpdateTime"] = parser.updateTime;
								adapter.Update(table);
							}
							catch(Exception e)
							{
							}
							//Console.WriteLine(testRow["UpdateDate"] + " changed to " + parser.logFileDate);
							
							currentProgress.Increment(1);
							parser.logFileDate = "";
							parser.updateTime = "";
							parser.srcIP = "";
							parser.cIP = "";
							tempLine = reader.ReadLine();
							continue;
						}
					}
					try
					{
						//at this point, the entry wasn't in the database. Time to check which location it
						//belongs to and add it to the database.
						//Console.WriteLine("Entry wasn't in the table already");
						//create a new row and assign the extracted values to each column
						DataRow newRow = table.NewRow();
						newRow["IPAddress"] = parser.srcIP;

						//determine the correct location for the ip by looping through each location
						//and comparing the ip with the range of that particular location.
						string[] ip = parser.srcIP.Split('.');
						IPAddress currentIP = new IPAddress(Int32.Parse(ip[0]), Int32.Parse(ip[1]), Int32.Parse(ip[2]), Int32.Parse(ip[3]));
						for(int i = 0; i < locations.Length; i++)
						{
							//if the ip falls in the range of the current location, set it's name
							if((currentIP.compareTo(locations[i].floor) == 1 && currentIP.compareTo(locations[i].ceiling) == -1) || currentIP.compareTo(locations[i].floor) == 0 || currentIP.compareTo(locations[i].ceiling) == 0)
							{
								//Console.WriteLine("IP Belongs to" + locations[i].name);
								//newRow["RegionName"] = locations[i].name;
								newRow["RegionName"] = locations[i].name;
								//Console.WriteLine(locations[i].name);
								break;
							}
							else
							{
								//Console.WriteLine("IP Belongs to Misc");
								newRow["RegionName"] = "Misc";
							}
						}
						
						newRow["ComputerName"] = "";
						newRow["UpdateDate"] = parser.logFileDate;
						newRow["UpdateTime"] = parser.updateTime;
						newRow["SUSIP"] = parser.cIP;
						//add the new row to the table
						table.Rows.Add(newRow);
						//update the table
						adapter.Update(table);
						//Console.WriteLine("Entry is now either updated, or added to the database");
					}
					catch(System.Data.OleDb.OleDbException dbException)
					{
						Console.WriteLine(dbException);
					}
					catch(System.Data.ConstraintException constraintException)
					{
						Console.WriteLine(constraintException);
					}
				}
				currentProgress.Increment(1);

				parser.logFileDate = "";
				parser.updateTime = "";
				parser.srcIP = "";
				parser.cIP = "";
				tempLine = reader.ReadLine();
				count++;
			}
			count = 0;
			reader.Close();
			parserStatusbar.Text = "Finished Parsing";
		}

	}
}
