using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace SuSCommander
{
	/// <summary>
	/// Summary description for ReportDialog.
	/// </summary>
	public class ReportDialog : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Button closeButton;
		private System.Windows.Forms.Button generateReportButton;
		private System.Windows.Forms.ListBox fieldList;
		private System.Windows.Forms.Label fieldLabel;
		private System.Windows.Forms.Button selectAllButton;
		private System.Windows.Forms.Button deSelectAllButton;
		private System.Windows.Forms.GroupBox searchCriteriaGroup;
		private System.Windows.Forms.ComboBox selectField;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.TextBox searchTextbox;
		private System.Windows.Forms.Label forLabel;
		private System.Windows.Forms.Label startDateLabel;
		private System.Windows.Forms.Label endDateLabel;
		private System.Windows.Forms.DateTimePicker startDatePicker;
		private System.Windows.Forms.DateTimePicker endDatePicker;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.Label errorLabel;


		public string query;
		public ReportDialog(string[] fields)
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
			errorLabel.Hide();

			fieldList.Items.AddRange(fields);
			selectField.Items.AddRange(fields);
			selectField.SelectedIndex = 0;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.closeButton = new System.Windows.Forms.Button();
			this.generateReportButton = new System.Windows.Forms.Button();
			this.fieldList = new System.Windows.Forms.ListBox();
			this.fieldLabel = new System.Windows.Forms.Label();
			this.selectAllButton = new System.Windows.Forms.Button();
			this.deSelectAllButton = new System.Windows.Forms.Button();
			this.searchCriteriaGroup = new System.Windows.Forms.GroupBox();
			this.endDatePicker = new System.Windows.Forms.DateTimePicker();
			this.startDatePicker = new System.Windows.Forms.DateTimePicker();
			this.endDateLabel = new System.Windows.Forms.Label();
			this.startDateLabel = new System.Windows.Forms.Label();
			this.searchTextbox = new System.Windows.Forms.TextBox();
			this.forLabel = new System.Windows.Forms.Label();
			this.label1 = new System.Windows.Forms.Label();
			this.selectField = new System.Windows.Forms.ComboBox();
			this.errorLabel = new System.Windows.Forms.Label();
			this.searchCriteriaGroup.SuspendLayout();
			this.SuspendLayout();
			// 
			// closeButton
			// 
			this.closeButton.Location = new System.Drawing.Point(216, 232);
			this.closeButton.Name = "closeButton";
			this.closeButton.TabIndex = 0;
			this.closeButton.Text = "Close";
			this.closeButton.Click += new System.EventHandler(this.closeButton_Click);
			// 
			// generateReportButton
			// 
			this.generateReportButton.Location = new System.Drawing.Point(224, 80);
			this.generateReportButton.Name = "generateReportButton";
			this.generateReportButton.Size = new System.Drawing.Size(104, 23);
			this.generateReportButton.TabIndex = 1;
			this.generateReportButton.Text = "Generate Report";
			this.generateReportButton.Click += new System.EventHandler(this.generateReportButton_Click);
			// 
			// fieldList
			// 
			this.fieldList.Location = new System.Drawing.Point(8, 24);
			this.fieldList.Name = "fieldList";
			this.fieldList.SelectionMode = System.Windows.Forms.SelectionMode.MultiSimple;
			this.fieldList.Size = new System.Drawing.Size(120, 134);
			this.fieldList.TabIndex = 2;
			// 
			// fieldLabel
			// 
			this.fieldLabel.Location = new System.Drawing.Point(16, 8);
			this.fieldLabel.Name = "fieldLabel";
			this.fieldLabel.Size = new System.Drawing.Size(100, 16);
			this.fieldLabel.TabIndex = 3;
			this.fieldLabel.Text = "Return Fields";
			this.fieldLabel.TextAlign = System.Drawing.ContentAlignment.BottomCenter;
			// 
			// selectAllButton
			// 
			this.selectAllButton.Location = new System.Drawing.Point(8, 168);
			this.selectAllButton.Name = "selectAllButton";
			this.selectAllButton.Size = new System.Drawing.Size(120, 23);
			this.selectAllButton.TabIndex = 4;
			this.selectAllButton.Text = "Select All";
			this.selectAllButton.Click += new System.EventHandler(this.selectAllButton_Click);
			// 
			// deSelectAllButton
			// 
			this.deSelectAllButton.Location = new System.Drawing.Point(8, 200);
			this.deSelectAllButton.Name = "deSelectAllButton";
			this.deSelectAllButton.Size = new System.Drawing.Size(120, 23);
			this.deSelectAllButton.TabIndex = 5;
			this.deSelectAllButton.Text = "De-Select All";
			this.deSelectAllButton.Click += new System.EventHandler(this.deSelectAllButton_Click);
			// 
			// searchCriteriaGroup
			// 
			this.searchCriteriaGroup.Controls.Add(this.errorLabel);
			this.searchCriteriaGroup.Controls.Add(this.endDatePicker);
			this.searchCriteriaGroup.Controls.Add(this.startDatePicker);
			this.searchCriteriaGroup.Controls.Add(this.endDateLabel);
			this.searchCriteriaGroup.Controls.Add(this.startDateLabel);
			this.searchCriteriaGroup.Controls.Add(this.searchTextbox);
			this.searchCriteriaGroup.Controls.Add(this.forLabel);
			this.searchCriteriaGroup.Controls.Add(this.label1);
			this.searchCriteriaGroup.Controls.Add(this.selectField);
			this.searchCriteriaGroup.Controls.Add(this.generateReportButton);
			this.searchCriteriaGroup.Location = new System.Drawing.Point(136, 24);
			this.searchCriteriaGroup.Name = "searchCriteriaGroup";
			this.searchCriteriaGroup.Size = new System.Drawing.Size(352, 200);
			this.searchCriteriaGroup.TabIndex = 6;
			this.searchCriteriaGroup.TabStop = false;
			this.searchCriteriaGroup.Text = "Search Criteria";
			// 
			// endDatePicker
			// 
			this.endDatePicker.CustomFormat = "YYYY-MM-DD";
			this.endDatePicker.Format = System.Windows.Forms.DateTimePickerFormat.Short;
			this.endDatePicker.Location = new System.Drawing.Point(88, 96);
			this.endDatePicker.Name = "endDatePicker";
			this.endDatePicker.Size = new System.Drawing.Size(88, 20);
			this.endDatePicker.TabIndex = 7;
			// 
			// startDatePicker
			// 
			this.startDatePicker.CustomFormat = "YYYY-MM-DD";
			this.startDatePicker.Format = System.Windows.Forms.DateTimePickerFormat.Short;
			this.startDatePicker.Location = new System.Drawing.Point(88, 64);
			this.startDatePicker.Name = "startDatePicker";
			this.startDatePicker.Size = new System.Drawing.Size(88, 20);
			this.startDatePicker.TabIndex = 6;
			// 
			// endDateLabel
			// 
			this.endDateLabel.Location = new System.Drawing.Point(16, 96);
			this.endDateLabel.Name = "endDateLabel";
			this.endDateLabel.Size = new System.Drawing.Size(64, 23);
			this.endDateLabel.TabIndex = 5;
			this.endDateLabel.Text = "End Date";
			this.endDateLabel.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// startDateLabel
			// 
			this.startDateLabel.Location = new System.Drawing.Point(16, 64);
			this.startDateLabel.Name = "startDateLabel";
			this.startDateLabel.Size = new System.Drawing.Size(64, 16);
			this.startDateLabel.TabIndex = 4;
			this.startDateLabel.Text = "Start Date";
			this.startDateLabel.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// searchTextbox
			// 
			this.searchTextbox.Location = new System.Drawing.Point(224, 16);
			this.searchTextbox.Name = "searchTextbox";
			this.searchTextbox.Size = new System.Drawing.Size(120, 20);
			this.searchTextbox.TabIndex = 3;
			this.searchTextbox.Text = "";
			// 
			// forLabel
			// 
			this.forLabel.Location = new System.Drawing.Point(192, 16);
			this.forLabel.Name = "forLabel";
			this.forLabel.Size = new System.Drawing.Size(24, 23);
			this.forLabel.TabIndex = 2;
			this.forLabel.Text = "For";
			this.forLabel.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(8, 16);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(48, 23);
			this.label1.TabIndex = 1;
			this.label1.Text = "Search";
			this.label1.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// selectField
			// 
			this.selectField.Location = new System.Drawing.Point(56, 16);
			this.selectField.Name = "selectField";
			this.selectField.Size = new System.Drawing.Size(121, 21);
			this.selectField.TabIndex = 0;
			// 
			// errorLabel
			// 
			this.errorLabel.ForeColor = System.Drawing.Color.Red;
			this.errorLabel.Location = new System.Drawing.Point(72, 144);
			this.errorLabel.Name = "errorLabel";
			this.errorLabel.Size = new System.Drawing.Size(200, 23);
			this.errorLabel.TabIndex = 8;
			this.errorLabel.Text = "Please Enter A Search Term";
			this.errorLabel.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// ReportDialog
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(496, 261);
			this.Controls.Add(this.searchCriteriaGroup);
			this.Controls.Add(this.deSelectAllButton);
			this.Controls.Add(this.selectAllButton);
			this.Controls.Add(this.fieldLabel);
			this.Controls.Add(this.fieldList);
			this.Controls.Add(this.closeButton);
			this.Name = "ReportDialog";
			this.Text = "Report Settings";
			this.searchCriteriaGroup.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Closes the window with a cancel status
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void closeButton_Click(object sender, System.EventArgs e)
		{
			DialogResult = DialogResult.Cancel;
			this.Hide();
		}

		/// <summary>
		/// creates the sql query that is used by the parent window to create the report
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void generateReportButton_Click(object sender, System.EventArgs e)
		{
			if(searchTextbox.Text == "")
			{
				errorLabel.Text = "Please Enter A Search Term";
				errorLabel.Show();
				return;
			}
			else if(fieldList.SelectedItems.Count == 0)
			{
				errorLabel.Text = "Please Select One Or More Return Fields";
				errorLabel.Show();
				return;
			}
			else
				errorLabel.Hide();

			string startDate = formatDate((startDatePicker.Value).Day, (startDatePicker.Value).Month, (startDatePicker.Value).Year);
			string endDate = formatDate((endDatePicker.Value).Day, (endDatePicker.Value).Month, (endDatePicker.Value).Year);


			query = "";
			query = "SELECT Location." + fieldList.SelectedItems[0];

			for(int i = 1; i< fieldList.SelectedItems.Count; i++)
				query = query + ", Location." + fieldList.SelectedItems[i];

			query = query + " FROM Location WHERE Location." + selectField.Text + " = '" + searchTextbox.Text + "' AND Location.UpdateDate >= '" + startDate + "' AND Location.UpdateDate <= '" + endDate + "'";

			DialogResult = DialogResult.OK;
			this.Hide();
		}

		/// <summary>
		/// Returns the date in the appropriate format that the database uses
		/// </summary>
		/// <param name="day">Number of the day of the month</param>
		/// <param name="month">Current month number</param>
		/// <param name="year">Current year</param>
		/// <returns></returns>
		private string formatDate(int day, int month, int year)
		{
			string date = year + "-";
			if(month < 10)
				date = date + "0" + month + "-";
			else
				date = date + month + "-";
			if(day < 10)
				date = date + "0" + day;
			else
				date = date + day;

			return date;
		}

		/// <summary>
		/// Selects all of the fields
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void selectAllButton_Click(object sender, System.EventArgs e)
		{
			for(int i = 0; i < fieldList.Items.Count; i++)
				fieldList.SetSelected(i, true);
		}

		/// <summary>
		/// De-selects all the fields
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void deSelectAllButton_Click(object sender, System.EventArgs e)
		{
			for(int i = 0; i < fieldList.Items.Count; i++)
				fieldList.SetSelected(i, false);
		}
	}
}
