using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.IO;
using System.Data;
using System.Data.OleDb;
using Microsoft.Win32;

namespace SuSCommander
{
	/// <summary>
	/// Main form for the SuSCommander program
	/// </summary>
	public class SuSCommander : System.Windows.Forms.Form
	{
		private System.Windows.Forms.StatusBar statusBar;
		private System.Windows.Forms.TreeView wanView;
		private System.Windows.Forms.DataGrid grid;
		private System.Windows.Forms.MenuItem fileMenu;
		private System.Windows.Forms.MenuItem exitMenuItem;
		private System.Windows.Forms.MenuItem configurationMenu;
		private System.Windows.Forms.MenuItem wanConfigurationMenuItem;
		private System.Windows.Forms.MenuItem helpMenu;
		private System.Windows.Forms.MenuItem topicsMenuItem;
		private System.Windows.Forms.MainMenu mainMenu;
		private System.Windows.Forms.MenuItem commanderSettingsMenuItem;
		private System.Windows.Forms.MenuItem parserMenuItem;
		private DataTable table;
		private OleDbDataAdapter adapter;
		private OleDbCommandBuilder commandBuilder;
		private System.Windows.Forms.Panel panel1;
		private System.Windows.Forms.Splitter splitter1;

		private OleDbConnection connection = new OleDbConnection();
		public ArrayList locations = new ArrayList();
		private System.Windows.Forms.Panel panel2;
		private System.Windows.Forms.MenuItem saveToWebpageMenuItem;
		private System.Windows.Forms.MenuItem menuItem1;
		private System.ComponentModel.IContainer components;


		//variables to store the registry settings
		private string dbPath = "";
		private string logPath = "";
		private string wanPath = "";
		private string lastLogDate = "";
		private string wizard = "";
		private string version = "";
		private System.Windows.Forms.MenuItem generateReportMenu;
		private System.Windows.Forms.ToolBar mainToolbar;
		private System.Windows.Forms.ToolBarButton wanConfigButton;
		private System.Windows.Forms.ToolBarButton parserButton;
		private System.Windows.Forms.ToolBarButton settingsButton;
		private System.Windows.Forms.ImageList imageList;
		private System.Windows.Forms.TextBox searchTextbox;
		private System.Windows.Forms.Button searchButton;
		private System.Windows.Forms.ToolBarButton reportGenerationButton;
		private RegistryKey rkey = Registry.LocalMachine;

		private	string[] fields = new string[6];
		/// <summary>
		/// Default constructor. Initializes the data and checks for saved setting information
		/// </summary>
		public SuSCommander()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//startupCheck will determine if the program is being run for the first time
			//and take action accordingly.
			startupCheck();

			//let the user know that everything has been loaded	
			statusBar.Text = "Data loaded";

			fields[0] = "IPAddress";
			fields[1] = "RegionName";
			fields[2] = "ComputerName";
			fields[3] = "UpdateDate";
			fields[4] = "UpdateTime";
			fields[5] = "SUSIP";

		}

		/// <summary>
		/// populateGrid connects to the specified Access Database and pulls information from it.
		/// </summary>
		private void populateGrid()
		{
			//create the sql statement and open the database using it
			string query = "SELECT * FROM LOCATION Where Location.RegionName = '" + wanView.SelectedNode.Text + "'" + buildQuery(wanView.SelectedNode);
			queryDatabase(query);
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(SuSCommander));
			this.mainMenu = new System.Windows.Forms.MainMenu();
			this.fileMenu = new System.Windows.Forms.MenuItem();
			this.saveToWebpageMenuItem = new System.Windows.Forms.MenuItem();
			this.exitMenuItem = new System.Windows.Forms.MenuItem();
			this.configurationMenu = new System.Windows.Forms.MenuItem();
			this.wanConfigurationMenuItem = new System.Windows.Forms.MenuItem();
			this.commanderSettingsMenuItem = new System.Windows.Forms.MenuItem();
			this.menuItem1 = new System.Windows.Forms.MenuItem();
			this.parserMenuItem = new System.Windows.Forms.MenuItem();
			this.generateReportMenu = new System.Windows.Forms.MenuItem();
			this.helpMenu = new System.Windows.Forms.MenuItem();
			this.topicsMenuItem = new System.Windows.Forms.MenuItem();
			this.wanView = new System.Windows.Forms.TreeView();
			this.statusBar = new System.Windows.Forms.StatusBar();
			this.grid = new System.Windows.Forms.DataGrid();
			this.panel1 = new System.Windows.Forms.Panel();
			this.panel2 = new System.Windows.Forms.Panel();
			this.splitter1 = new System.Windows.Forms.Splitter();
			this.mainToolbar = new System.Windows.Forms.ToolBar();
			this.wanConfigButton = new System.Windows.Forms.ToolBarButton();
			this.parserButton = new System.Windows.Forms.ToolBarButton();
			this.settingsButton = new System.Windows.Forms.ToolBarButton();
			this.reportGenerationButton = new System.Windows.Forms.ToolBarButton();
			this.imageList = new System.Windows.Forms.ImageList(this.components);
			this.searchTextbox = new System.Windows.Forms.TextBox();
			this.searchButton = new System.Windows.Forms.Button();
			((System.ComponentModel.ISupportInitialize)(this.grid)).BeginInit();
			this.panel1.SuspendLayout();
			this.panel2.SuspendLayout();
			this.SuspendLayout();
			// 
			// mainMenu
			// 
			this.mainMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					 this.fileMenu,
																					 this.configurationMenu,
																					 this.menuItem1,
																					 this.helpMenu});
			// 
			// fileMenu
			// 
			this.fileMenu.Index = 0;
			this.fileMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					 this.saveToWebpageMenuItem,
																					 this.exitMenuItem});
			this.fileMenu.Text = "File";
			// 
			// saveToWebpageMenuItem
			// 
			this.saveToWebpageMenuItem.Index = 0;
			this.saveToWebpageMenuItem.Text = "Export";
			this.saveToWebpageMenuItem.Click += new System.EventHandler(this.saveToWebpageMenuItem_Click);
			// 
			// exitMenuItem
			// 
			this.exitMenuItem.Index = 1;
			this.exitMenuItem.Text = "Exit";
			this.exitMenuItem.Click += new System.EventHandler(this.exitMenuItem_Click);
			// 
			// configurationMenu
			// 
			this.configurationMenu.Index = 1;
			this.configurationMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																							  this.wanConfigurationMenuItem,
																							  this.commanderSettingsMenuItem});
			this.configurationMenu.Text = "Configuration";
			// 
			// wanConfigurationMenuItem
			// 
			this.wanConfigurationMenuItem.Index = 0;
			this.wanConfigurationMenuItem.Text = "Wan Configuration";
			this.wanConfigurationMenuItem.Click += new System.EventHandler(this.wanConfigurationMenuItem_Click);
			// 
			// commanderSettingsMenuItem
			// 
			this.commanderSettingsMenuItem.Index = 1;
			this.commanderSettingsMenuItem.Text = "Commander Settings";
			this.commanderSettingsMenuItem.Click += new System.EventHandler(this.commanderSettingsMenuItem_Click);
			// 
			// menuItem1
			// 
			this.menuItem1.Index = 2;
			this.menuItem1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					  this.parserMenuItem,
																					  this.generateReportMenu});
			this.menuItem1.Text = "Tools";
			// 
			// parserMenuItem
			// 
			this.parserMenuItem.Index = 0;
			this.parserMenuItem.Text = "Parser";
			this.parserMenuItem.Click += new System.EventHandler(this.parserMenuItem_Click);
			// 
			// generateReportMenu
			// 
			this.generateReportMenu.Index = 1;
			this.generateReportMenu.Text = "Generate Report";
			this.generateReportMenu.Click += new System.EventHandler(this.generateReportMenu_Click);
			// 
			// helpMenu
			// 
			this.helpMenu.Index = 3;
			this.helpMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					 this.topicsMenuItem});
			this.helpMenu.Text = "Help";
			// 
			// topicsMenuItem
			// 
			this.topicsMenuItem.Index = 0;
			this.topicsMenuItem.Text = "About";
			this.topicsMenuItem.Click += new System.EventHandler(this.topicsMenuItem_Click);
			// 
			// wanView
			// 
			this.wanView.Dock = System.Windows.Forms.DockStyle.Left;
			this.wanView.ImageIndex = -1;
			this.wanView.Indent = 15;
			this.wanView.Location = new System.Drawing.Point(0, 0);
			this.wanView.Name = "wanView";
			this.wanView.SelectedImageIndex = -1;
			this.wanView.Size = new System.Drawing.Size(175, 496);
			this.wanView.TabIndex = 0;
			this.wanView.AfterSelect += new System.Windows.Forms.TreeViewEventHandler(this.wanView_AfterSelect);
			// 
			// statusBar
			// 
			this.statusBar.Location = new System.Drawing.Point(0, 547);
			this.statusBar.Name = "statusBar";
			this.statusBar.Size = new System.Drawing.Size(872, 22);
			this.statusBar.TabIndex = 2;
			// 
			// grid
			// 
			this.grid.AllowNavigation = false;
			this.grid.BorderStyle = System.Windows.Forms.BorderStyle.None;
			this.grid.CaptionVisible = false;
			this.grid.DataMember = "";
			this.grid.Dock = System.Windows.Forms.DockStyle.Fill;
			this.grid.HeaderForeColor = System.Drawing.SystemColors.ControlText;
			this.grid.Location = new System.Drawing.Point(0, 0);
			this.grid.Name = "grid";
			this.grid.PreferredColumnWidth = 125;
			this.grid.ReadOnly = true;
			this.grid.RowHeadersVisible = false;
			this.grid.RowHeaderWidth = 100;
			this.grid.Size = new System.Drawing.Size(689, 496);
			this.grid.TabIndex = 3;
			// 
			// panel1
			// 
			this.panel1.Controls.Add(this.panel2);
			this.panel1.Controls.Add(this.splitter1);
			this.panel1.Controls.Add(this.wanView);
			this.panel1.Location = new System.Drawing.Point(0, 48);
			this.panel1.Name = "panel1";
			this.panel1.Size = new System.Drawing.Size(872, 496);
			this.panel1.TabIndex = 4;
			// 
			// panel2
			// 
			this.panel2.Controls.Add(this.grid);
			this.panel2.Dock = System.Windows.Forms.DockStyle.Fill;
			this.panel2.Location = new System.Drawing.Point(183, 0);
			this.panel2.Name = "panel2";
			this.panel2.Size = new System.Drawing.Size(689, 496);
			this.panel2.TabIndex = 5;
			// 
			// splitter1
			// 
			this.splitter1.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.splitter1.Location = new System.Drawing.Point(175, 0);
			this.splitter1.Name = "splitter1";
			this.splitter1.Size = new System.Drawing.Size(8, 496);
			this.splitter1.TabIndex = 4;
			this.splitter1.TabStop = false;
			// 
			// mainToolbar
			// 
			this.mainToolbar.Buttons.AddRange(new System.Windows.Forms.ToolBarButton[] {
																						   this.wanConfigButton,
																						   this.parserButton,
																						   this.settingsButton,
																						   this.reportGenerationButton});
			this.mainToolbar.ButtonSize = new System.Drawing.Size(36, 36);
			this.mainToolbar.DropDownArrows = true;
			this.mainToolbar.ImageList = this.imageList;
			this.mainToolbar.Location = new System.Drawing.Point(0, 0);
			this.mainToolbar.Name = "mainToolbar";
			this.mainToolbar.ShowToolTips = true;
			this.mainToolbar.Size = new System.Drawing.Size(872, 48);
			this.mainToolbar.TabIndex = 5;
			this.mainToolbar.ButtonClick += new System.Windows.Forms.ToolBarButtonClickEventHandler(this.mainToolbar_ButtonClick);
			// 
			// wanConfigButton
			// 
			this.wanConfigButton.ImageIndex = 0;
			this.wanConfigButton.Text = "wan";
			this.wanConfigButton.ToolTipText = "Wan Configuration";
			// 
			// parserButton
			// 
			this.parserButton.ImageIndex = 1;
			this.parserButton.Text = "parser";
			this.parserButton.ToolTipText = "Parser";
			// 
			// settingsButton
			// 
			this.settingsButton.ImageIndex = 2;
			this.settingsButton.Text = "settings";
			this.settingsButton.ToolTipText = "Settings";
			// 
			// reportGenerationButton
			// 
			this.reportGenerationButton.ImageIndex = 3;
			this.reportGenerationButton.Text = "report";
			this.reportGenerationButton.ToolTipText = "Reports";
			// 
			// imageList
			// 
			this.imageList.ImageSize = new System.Drawing.Size(36, 36);
			this.imageList.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageList.ImageStream")));
			this.imageList.TransparentColor = System.Drawing.Color.Transparent;
			// 
			// searchTextbox
			// 
			this.searchTextbox.Location = new System.Drawing.Point(640, 16);
			this.searchTextbox.Name = "searchTextbox";
			this.searchTextbox.Size = new System.Drawing.Size(144, 20);
			this.searchTextbox.TabIndex = 6;
			this.searchTextbox.Text = "";
			// 
			// searchButton
			// 
			this.searchButton.Location = new System.Drawing.Point(792, 16);
			this.searchButton.Name = "searchButton";
			this.searchButton.TabIndex = 7;
			this.searchButton.Text = "Search";
			this.searchButton.Click += new System.EventHandler(this.searchButton_Click);
			// 
			// SuSCommander
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(872, 569);
			this.Controls.Add(this.searchButton);
			this.Controls.Add(this.searchTextbox);
			this.Controls.Add(this.mainToolbar);
			this.Controls.Add(this.panel1);
			this.Controls.Add(this.statusBar);
			this.Menu = this.mainMenu;
			this.Name = "SuSCommander";
			this.Text = "SUS Commander";
			((System.ComponentModel.ISupportInitialize)(this.grid)).EndInit();
			this.panel1.ResumeLayout(false);
			this.panel2.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion
		
		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new SuSCommander());
		}

		/// <summary>
		/// Method called when the parserMenuItem is clicked. This menu will
		/// create the parser gui for parsing the log files
		/// </summary>
		/// <param name="sender">The object that invoked this event</param>
		/// <param name="e">The event arguments</param>
		private void parserMenuItem_Click(object sender, System.EventArgs e)
		{
			//load the parsing window
			ParserUI parser = new ParserUI(table, adapter, locations);
			parser.ShowDialog();
		}

		/// <summary>
		/// Method called when the wanConfigurationMenuItem is clicked. This method
		/// will create the wan configuration window for customizing the wan file
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void wanConfigurationMenuItem_Click(object sender, System.EventArgs e)
		{
			WanConfiguration configuration = new WanConfiguration("wan.cfg");
			configuration.ShowDialog();
			if(configuration.DialogResult == DialogResult.OK)
			{
				wanView.Nodes.Clear();
				loadLogicalWan(configuration.fileName);
				wanView.ExpandAll();
			}
		}

		/// <summary>
		/// loadLogicalWan reads in the specified wan file and adds the information
		/// to the treeview. It then sets the root node in the tree to the currently
		/// selected item
		/// </summary>
		/// <param name="fileName">The wan configuration file</param>
		private void loadLogicalWan(string fileName)
		{
			//clear the tree and lock it for updating
			wanView.Nodes.Clear();
			wanView.BeginUpdate();

			//create the reader and read in the first line
			StreamReader reader = new StreamReader(fileName);
			string templine = reader.ReadLine();
			//create the root node and add it to the tree
			TreeNode currentNode = new TreeNode(templine);
			wanView.Nodes.Add(currentNode);
			currentNode = wanView.Nodes[0];
			templine = reader.ReadLine();

			//while there is more data in the wan file, keep reading it
			while(templine != null)
			{
				//skip blank lines
				if(templine.Length < 1)
				{
					templine = reader.ReadLine();
					continue;
				}
				//skip comments (denoted with a '#' sign at the begining of the line)
				else if((templine.Substring(0, 1) == "#"))
				{
					templine = reader.ReadLine();
					continue;
				}

				//'{' denote the start of a branch in the tree
				if(templine.IndexOf("{") >= 0)
				{
					templine = reader.ReadLine();
					string location = "";
					string name = "";
					if(templine.IndexOf("(") == -1)
						name = templine.TrimStart('\t');
					else
					{
						location = templine.TrimStart('\t');
						location = location.Substring(0, location.IndexOf("(") -1);

						name = location;
						location = templine.TrimStart('\t');
						int startIndex = location.IndexOf("(") + 1;
						int length = location.Length - startIndex - 1;
						string[] ipOctets = (location.Substring(startIndex, length)).Split(' ');
						Location tempLocal = new Location(name, new IPAddress(Int32.Parse(ipOctets[0]), Int32.Parse(ipOctets[1]), Int32.Parse(ipOctets[2]), Int32.Parse(ipOctets[3])), new IPAddress(Int32.Parse(ipOctets[0]), Int32.Parse(ipOctets[1]), Int32.Parse(ipOctets[2]), Int32.Parse(ipOctets[4])));
						locations.Add(tempLocal);
					}
					TreeNode tempNode = new TreeNode(name);
					currentNode.Nodes.Add(tempNode);
					currentNode = currentNode.LastNode;

					templine = reader.ReadLine();
					continue;
				}
				//'}' denote the end of a branch. when this comes up
				//the current node is pulled up one level
				else if(templine.IndexOf("}") >= 0)
				{
					currentNode = currentNode.Parent;
					templine = reader.ReadLine();
					continue;
				}
				//otherwise, it is an entry so read it in
				else
				{
					//Console.WriteLine(templine.TrimStart('\t'));
					string location = "";
					string name = "";
					//if the location doesn't have an ip range, set it's name
					if(templine.IndexOf("(") == -1)
						name = templine.TrimStart('\t');
					//if it does have a range, read it in and populate the data for that location
					else
					{
						location = templine.TrimStart('\t');
						location = location.Substring(0, location.IndexOf("(") -1);
						name = location;
						location = templine.TrimStart('\t');
						int startIndex = location.IndexOf("(") + 1;
						int length = location.Length - startIndex - 1;
						string[] ipOctets = (location.Substring(startIndex, length)).Split(' ');
						Location tempLocal = new Location(name, new IPAddress(Int32.Parse(ipOctets[0]), Int32.Parse(ipOctets[1]), Int32.Parse(ipOctets[2]), Int32.Parse(ipOctets[3])), new IPAddress(Int32.Parse(ipOctets[0]), Int32.Parse(ipOctets[1]), Int32.Parse(ipOctets[2]), Int32.Parse(ipOctets[4])));
						locations.Add(tempLocal);
					}
					TreeNode tempNode = new TreeNode(name);
					currentNode.Parent.Nodes.Add(tempNode);
					currentNode = currentNode.NextNode;
				}
				templine = reader.ReadLine();
			}
			reader.Close();

			//unlock the control, select the root, and expand the tree
			wanView.EndUpdate();
			wanView.SelectedNode = wanView.Nodes[0];
			wanView.ExpandAll();
		}

		/// <summary>
		/// Updates the grid so that it reflects the selection in the treeview
		/// </summary>
		/// <param name="sender">The object that triggered this event</param>
		/// <param name="e">Event arguments</param>
		private void wanView_AfterSelect(object sender, System.Windows.Forms.TreeViewEventArgs e)
		{
			populateGrid();
		}

		/// <summary>
		/// Get the filename for the file
		/// </summary>
		/// <param name="sender">the object that triggered the event</param>
		/// <param name="e">the event arguments</param>
		private void saveToWebpageMenuItem_Click(object sender, System.EventArgs e)
		{
			SaveFileDialog saveDialog = new SaveFileDialog();
			saveDialog.AddExtension = true;
			saveDialog.Filter = "HTML (*.html)|*.html|Text File (*.txt)|*.txt";
			saveDialog.FilterIndex = 0;
			if(saveDialog.ShowDialog() == DialogResult.OK)
			{
				string extension = saveDialog.FileName;
				extension = extension.Substring(extension.LastIndexOf(".") + 1);
				if(extension.ToLower() == "html")
				{
					Console.WriteLine("HTML");
					saveHTML(saveDialog.FileName);
				}
				else
				{
					Console.WriteLine("Text");
					saveText(saveDialog.FileName);
				}
			}
		}

		/// <summary>
		/// Save the file to a webpage
		/// </summary>
		/// <param name="fileName">the file that will become a webpage</param>
		private void saveHTML(string fileName)
		{
			try
			{
				//create the writer and write the html header information
				StreamWriter writer = new StreamWriter(fileName);
				writer.WriteLine("<html>\n<head>\n<title>" + wanView.SelectedNode.Text + " Report</title>\n</head>\n><body>\n");
				writer.WriteLine("<h2><u>" + wanView.SelectedNode.Text + " Report:</u></h2>");
				writer.WriteLine("<table border=1>");
				
				//write each row to the file
				for(int j = 0; j < table.Rows.Count; j++)
				{
					DataRow row = table.Rows[j];
					writer.WriteLine("<tr>");
					for(int i = 0; i < 6; i++)
					{
						if((string)row[i] == "")
							writer.WriteLine("<td>&nbsp;</td>");
						else
							writer.WriteLine("<td>" + row[i] + "</td>");
					}
					writer.WriteLine("</tr>");
				}
				//write the footer information to the file
				writer.WriteLine("</body>\n</html>");
				//close the stream
				writer.Close();
			}
			catch(Exception e)
			{
				Console.WriteLine("Error Writing To File");
			}
		}

		private void saveText(string fileName)
		{
			try
			{
				//create the writer
				StreamWriter writer = new StreamWriter(fileName);
				writer.WriteLine(wanView.SelectedNode.Text + " Report");
				writer.WriteLine("\n\n");
				
				//write each row to the file
				for(int j = 0; j < table.Rows.Count; j++)
				{
					DataRow row = table.Rows[j];
					for(int i = 0; i < 6; i++)
					{
						if((string)row[i] == "")
							writer.Write("\t");
						else
							writer.Write(row[i] + "\t");
					}
					writer.WriteLine("\n");
				}
				//close the stream
				writer.Close();
			}
			catch(Exception e)
			{
				Console.WriteLine("Error Writing To File");
			}
		}

		/// <summary>
		/// Funtion that recursively builds the sql query from the treeview
		/// </summary>
		/// <param name="node">The current treenode</param>
		/// <returns>The conditional clause of an sql query based on the treeview</returns>
		private string buildQuery(TreeNode node)
		{
			IEnumerator ie = node.Nodes.GetEnumerator();

			String query = "";
			
			while (ie.MoveNext()) 
			{
				TreeNode ctn = (TreeNode) ie.Current;
				//Console.WriteLine(ctn.Text + " " + ctn.Nodes.Count);
				query = query + " OR Location.RegionName = '" + ctn.Text + "'";

				for(int i = 0; i < ctn.Nodes.Count; i++)
					query = query + buildQuery(ctn.Nodes[i]);

			}
			return query;
		}

		/// <summary>
		/// Closes the program
		/// </summary>
		/// <param name="sender">object that triggered the event</param>
		/// <param name="e">event arguments</param>
		private void exitMenuItem_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		/// <summary>
		/// Checks for registry settings. If there are none, it creates a window
		/// that allows the user to specify the correct settings. if it is there,
		/// it loads those settings
		/// </summary>
		private void startupCheck()
		{
			//scan the registry for the SuSCommander key
			rkey = Registry.LocalMachine;
			rkey = rkey.OpenSubKey("Software", true);
			rkey = rkey.OpenSubKey("SuSCommander", true);
			//if the key doesn't exist, create the configuration window
			if(rkey == null)
			{
				Console.WriteLine("No Registry File");
				runStartupWizard();
			}
			//otherwise, read in the info
			else
			{
				//rkey = rkey.OpenSubKey("SuSCommander", true);

				dbPath = rkey.GetValue("dbPath").ToString();
				logPath = rkey.GetValue("logPath").ToString();
				wanPath = rkey.GetValue("wanPath").ToString();
				//lastLogDate = rkey.GetValue("lastLogDate").ToString();
				//version = rkey.GetValue("version").ToString();
				
				//create the wan (which in turn populates the data)
				loadLogicalWan(wanPath);
			}
		}

		/// <summary>
		/// Load the options window
		/// </summary>
		private void runStartupWizard()
		{
			CommanderSettings settings = new CommanderSettings();
			if(settings.ShowDialog() == DialogResult.OK)
			{
				dbPath = settings.dbPath;
				logPath = settings.logPath;
				wanPath = settings.wanPath;

				saveRegistrySettings();
				loadLogicalWan(wanPath);
				
			}
		}

		/// <summary>
		/// Load the options window
		/// </summary>
		/// <param name="sender">object that triggered the event</param>
		/// <param name="e">event arguments</param>
		private void commanderSettingsMenuItem_Click(object sender, System.EventArgs e)
		{
			CommanderSettings settings = new CommanderSettings();
			if(settings.ShowDialog() == DialogResult.OK)
			{
				dbPath = settings.dbPath;
				logPath = settings.logPath;
				wanPath = settings.wanPath;

				saveRegistrySettings();
				loadLogicalWan(wanPath);
			}
		}

		/// <summary>
		/// Saves the current settings to the registry
		/// </summary>
		private void saveRegistrySettings()
		{
			//scan for SuSCommander registry key
			rkey = Registry.LocalMachine;
			rkey = rkey.OpenSubKey("Software", true);
			//if it doesn't exist, create it and fill in the data
			if(rkey.GetValue("SuSCommander") == null)
			{
				rkey.CreateSubKey("SuSCommander");
				rkey = rkey.OpenSubKey("SuSCommander", true);
				rkey.SetValue("dbPath", dbPath);
				rkey.SetValue("logPath", logPath);
				rkey.SetValue("wanpath", wanPath);
			}
			//otherwise, overwrite the data
			else
			{
				rkey = rkey.OpenSubKey("SuSCommander", true);
				rkey.SetValue("dbPath", dbPath);
				rkey.SetValue("logPath", logPath);
				rkey.SetValue("wanpath", wanPath);
			}
		}

		/// <summary>
		/// Generates a report that can be printed out
		/// </summary>
		/// <param name="sender">object that triggered the event</param>
		/// <param name="e">event arguments</param>
		private void generateReportMenu_Click(object sender, System.EventArgs e)
		{
			ReportDialog rpDialog = new ReportDialog(fields);
			
			if(rpDialog.ShowDialog() == DialogResult.OK)
			{
				Console.WriteLine("Report String: ");
				Console.WriteLine(rpDialog.query);
				string query = rpDialog.query;
				queryDatabase(query);
			}
		}

		private void queryDatabase(string query)
		{
			try
			{
				if(connection.State == ConnectionState.Open)
					connection.Close();
				connection.ConnectionString = @"Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" + dbPath;
				connection.Open();

				//Console.WriteLine(query);

				//create an adapter, pull the information, and populate the table
				adapter = new OleDbDataAdapter(query, connection);
				commandBuilder = new OleDbCommandBuilder(adapter);
				table = new DataTable();
				adapter.Fill(table);
				//set the datagrid source to the table so it displays the information
				grid.DataSource = table;
				//assing a primary key to the table
				DataColumn[] pkColumn = new DataColumn[1];
				pkColumn[0] = table.Columns[0];
				table.PrimaryKey = pkColumn;
				//close the connection
				connection.Close();
			}
			catch(Exception e)
			{
				Console.WriteLine(e);
			}
		}

		private void searchButton_Click(object sender, System.EventArgs e)
		{
			string searchParameter = searchTextbox.Text;
			string sql;
			if(wanView.SelectedNode.Nodes.Count == 0)
				sql = "SELECT * FROM Location WHERE Location.RegionName = '" + wanView.SelectedNode.Text + "' AND (Location.IPAddress = '" + searchParameter + "' OR Location.RegionName = '" + searchParameter + "' OR Location.ComputerName = '" + searchParameter + "' OR Location.UpdateDate = '" + searchParameter + "' OR Location.UpdateTime = '" + searchParameter + "' OR Location.SUSIP = '" + searchParameter + "')";
			else
				sql = "SELECT * FROM Location WHERE (Location.RegionName = '" + wanView.SelectedNode.Text + "'" + buildQuery(wanView.SelectedNode) + ") AND (Location.IPAddress = '" + searchParameter + "' OR Location.RegionName = '" + searchParameter + "' OR Location.ComputerName = '" + searchParameter + "' OR Location.UpdateDate = '" + searchParameter + "' OR Location.UpdateTime = '" + searchParameter + "' OR Location.SUSIP = '" + searchParameter + "')";
			Console.WriteLine(sql);

			queryDatabase(sql);
		}

		private void topicsMenuItem_Click(object sender, System.EventArgs e)
		{
			Topics topicsDialog = new Topics();
			topicsDialog.Show();
		}

		private void mainToolbar_ButtonClick(object sender, System.Windows.Forms.ToolBarButtonClickEventArgs e)
		{
			string buttonName = e.Button.Text;

			switch(buttonName)
			{
				case "wan":
					WanConfiguration configuration = new WanConfiguration("wan.cfg");
					configuration.ShowDialog();
					if(configuration.DialogResult == DialogResult.OK)
					{
						wanView.Nodes.Clear();
						loadLogicalWan(configuration.fileName);
						wanView.ExpandAll();
					}
					break;
				case "parser":
					//load the parsing window
					ParserUI parser = new ParserUI(table, adapter, locations);
					parser.ShowDialog();
					break;
				case "settings":
					CommanderSettings settings = new CommanderSettings();
					if(settings.ShowDialog() == DialogResult.OK)
					{
						dbPath = settings.dbPath;
						logPath = settings.logPath;
						wanPath = settings.wanPath;

						saveRegistrySettings();
						loadLogicalWan(wanPath);
					}
					break;
				case "report":
					ReportDialog rpDialog = new ReportDialog(fields);
			
					if(rpDialog.ShowDialog() == DialogResult.OK)
					{
						Console.WriteLine("Report String: ");
						Console.WriteLine(rpDialog.query);
						string query = rpDialog.query;
						queryDatabase(query);
					}
					break;
			}
		}
	}
}
