using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.IO;

namespace SuSCommander
{
	/// <summary>
	/// Summary description for WanConfiguration.
	/// </summary>
	public class WanConfiguration : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.OpenFileDialog openConfiguration;
		private System.Windows.Forms.Button openConfigButton;
		public System.Windows.Forms.TreeView wanView;
		private System.Windows.Forms.Button addLocationButton;
		private System.Windows.Forms.TextBox locationName;
		private System.Windows.Forms.Button deleteSelectedButton;
		private System.Windows.Forms.Button saveConfigurationButton;
		private System.Windows.Forms.Button closeButton;
		private System.Windows.Forms.Label currentFileLabel;
		private System.Windows.Forms.Label currentFile;
		private System.Windows.Forms.GroupBox locationSettingsGroupBox;
		private System.Windows.Forms.TextBox octetOne;
		private System.Windows.Forms.TextBox octetTwo;
		private System.Windows.Forms.TextBox octetThree;
		private System.Windows.Forms.TextBox octetFourStart;
		private System.Windows.Forms.Label dashLabel;
		private System.Windows.Forms.Label dot;
		private System.Windows.Forms.Label dot2;
		private System.Windows.Forms.Label dot3;
		private System.Windows.Forms.TextBox octetFourEnd;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Button setIPRangeButton;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public ArrayList locations = new ArrayList();
		private System.Windows.Forms.SaveFileDialog saveConfiguration;
		private Location currentLocation = null;
		public string fileName;
		private System.Windows.Forms.Button okButton;
		private int indentCount = 0;
		public bool savePath = false;

		public WanConfiguration(string file)
		{
			//
			// Required for Windows Form Designer support
			//
			fileName = file;
			InitializeComponent();
			loadLogicalWan(fileName);
			currentFile.Text = fileName;
			locationSettingsGroupBox.Hide();
			if(locations.Count > 0)
				currentLocation = (Location)(locations[0]);
			else
				currentLocation = null;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.wanView = new System.Windows.Forms.TreeView();
			this.addLocationButton = new System.Windows.Forms.Button();
			this.locationName = new System.Windows.Forms.TextBox();
			this.label3 = new System.Windows.Forms.Label();
			this.deleteSelectedButton = new System.Windows.Forms.Button();
			this.saveConfigurationButton = new System.Windows.Forms.Button();
			this.openConfigButton = new System.Windows.Forms.Button();
			this.closeButton = new System.Windows.Forms.Button();
			this.openConfiguration = new System.Windows.Forms.OpenFileDialog();
			this.currentFileLabel = new System.Windows.Forms.Label();
			this.currentFile = new System.Windows.Forms.Label();
			this.locationSettingsGroupBox = new System.Windows.Forms.GroupBox();
			this.setIPRangeButton = new System.Windows.Forms.Button();
			this.label1 = new System.Windows.Forms.Label();
			this.octetFourEnd = new System.Windows.Forms.TextBox();
			this.dot3 = new System.Windows.Forms.Label();
			this.dot2 = new System.Windows.Forms.Label();
			this.dot = new System.Windows.Forms.Label();
			this.dashLabel = new System.Windows.Forms.Label();
			this.octetFourStart = new System.Windows.Forms.TextBox();
			this.octetThree = new System.Windows.Forms.TextBox();
			this.octetTwo = new System.Windows.Forms.TextBox();
			this.octetOne = new System.Windows.Forms.TextBox();
			this.saveConfiguration = new System.Windows.Forms.SaveFileDialog();
			this.okButton = new System.Windows.Forms.Button();
			this.locationSettingsGroupBox.SuspendLayout();
			this.SuspendLayout();
			// 
			// wanView
			// 
			this.wanView.ImageIndex = -1;
			this.wanView.Location = new System.Drawing.Point(0, 0);
			this.wanView.Name = "wanView";
			this.wanView.SelectedImageIndex = -1;
			this.wanView.Size = new System.Drawing.Size(160, 248);
			this.wanView.TabIndex = 0;
			this.wanView.AfterSelect += new System.Windows.Forms.TreeViewEventHandler(this.wanView_AfterSelect);
			// 
			// addLocationButton
			// 
			this.addLocationButton.Location = new System.Drawing.Point(304, 88);
			this.addLocationButton.Name = "addLocationButton";
			this.addLocationButton.Size = new System.Drawing.Size(88, 23);
			this.addLocationButton.TabIndex = 2;
			this.addLocationButton.Text = "Add Location";
			this.addLocationButton.Click += new System.EventHandler(this.addLocationButton_Click);
			// 
			// locationName
			// 
			this.locationName.Location = new System.Drawing.Point(168, 88);
			this.locationName.Name = "locationName";
			this.locationName.Size = new System.Drawing.Size(128, 20);
			this.locationName.TabIndex = 6;
			this.locationName.Text = "";
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(168, 64);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(100, 16);
			this.label3.TabIndex = 11;
			this.label3.Text = "Location";
			this.label3.TextAlign = System.Drawing.ContentAlignment.BottomLeft;
			// 
			// deleteSelectedButton
			// 
			this.deleteSelectedButton.Location = new System.Drawing.Point(168, 224);
			this.deleteSelectedButton.Name = "deleteSelectedButton";
			this.deleteSelectedButton.Size = new System.Drawing.Size(128, 23);
			this.deleteSelectedButton.TabIndex = 13;
			this.deleteSelectedButton.Text = "Remove Selected Item";
			this.deleteSelectedButton.Click += new System.EventHandler(this.deleteSelectedButton_Click);
			// 
			// saveConfigurationButton
			// 
			this.saveConfigurationButton.Location = new System.Drawing.Point(440, 56);
			this.saveConfigurationButton.Name = "saveConfigurationButton";
			this.saveConfigurationButton.Size = new System.Drawing.Size(112, 23);
			this.saveConfigurationButton.TabIndex = 15;
			this.saveConfigurationButton.Text = "Save Changes";
			this.saveConfigurationButton.Click += new System.EventHandler(this.saveConfigurationButton_Click);
			// 
			// openConfigButton
			// 
			this.openConfigButton.Location = new System.Drawing.Point(440, 24);
			this.openConfigButton.Name = "openConfigButton";
			this.openConfigButton.Size = new System.Drawing.Size(112, 23);
			this.openConfigButton.TabIndex = 16;
			this.openConfigButton.Text = "Open Configuration";
			this.openConfigButton.Click += new System.EventHandler(this.openConfigButton_Click);
			// 
			// closeButton
			// 
			this.closeButton.Location = new System.Drawing.Point(480, 224);
			this.closeButton.Name = "closeButton";
			this.closeButton.TabIndex = 17;
			this.closeButton.Text = "Cancel";
			this.closeButton.Click += new System.EventHandler(this.closeButton_Click);
			// 
			// currentFileLabel
			// 
			this.currentFileLabel.Location = new System.Drawing.Point(168, 0);
			this.currentFileLabel.Name = "currentFileLabel";
			this.currentFileLabel.TabIndex = 19;
			this.currentFileLabel.Text = "Current File:";
			this.currentFileLabel.TextAlign = System.Drawing.ContentAlignment.BottomLeft;
			// 
			// currentFile
			// 
			this.currentFile.Location = new System.Drawing.Point(168, 32);
			this.currentFile.Name = "currentFile";
			this.currentFile.TabIndex = 20;
			this.currentFile.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// locationSettingsGroupBox
			// 
			this.locationSettingsGroupBox.Controls.Add(this.setIPRangeButton);
			this.locationSettingsGroupBox.Controls.Add(this.label1);
			this.locationSettingsGroupBox.Controls.Add(this.octetFourEnd);
			this.locationSettingsGroupBox.Controls.Add(this.dot3);
			this.locationSettingsGroupBox.Controls.Add(this.dot2);
			this.locationSettingsGroupBox.Controls.Add(this.dot);
			this.locationSettingsGroupBox.Controls.Add(this.dashLabel);
			this.locationSettingsGroupBox.Controls.Add(this.octetFourStart);
			this.locationSettingsGroupBox.Controls.Add(this.octetThree);
			this.locationSettingsGroupBox.Controls.Add(this.octetTwo);
			this.locationSettingsGroupBox.Controls.Add(this.octetOne);
			this.locationSettingsGroupBox.Location = new System.Drawing.Point(168, 120);
			this.locationSettingsGroupBox.Name = "locationSettingsGroupBox";
			this.locationSettingsGroupBox.Size = new System.Drawing.Size(320, 96);
			this.locationSettingsGroupBox.TabIndex = 21;
			this.locationSettingsGroupBox.TabStop = false;
			this.locationSettingsGroupBox.Text = "Location Settings";
			// 
			// setIPRangeButton
			// 
			this.setIPRangeButton.Location = new System.Drawing.Point(272, 56);
			this.setIPRangeButton.Name = "setIPRangeButton";
			this.setIPRangeButton.Size = new System.Drawing.Size(40, 24);
			this.setIPRangeButton.TabIndex = 10;
			this.setIPRangeButton.Text = "Set";
			this.setIPRangeButton.Click += new System.EventHandler(this.setIPRangeButton_Click);
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(8, 24);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(56, 16);
			this.label1.TabIndex = 9;
			this.label1.Text = "IP Range";
			this.label1.TextAlign = System.Drawing.ContentAlignment.BottomLeft;
			// 
			// octetFourEnd
			// 
			this.octetFourEnd.Location = new System.Drawing.Point(216, 56);
			this.octetFourEnd.Name = "octetFourEnd";
			this.octetFourEnd.Size = new System.Drawing.Size(32, 20);
			this.octetFourEnd.TabIndex = 8;
			this.octetFourEnd.Text = "";
			// 
			// dot3
			// 
			this.dot3.Font = new System.Drawing.Font("Microsoft Sans Serif", 20F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dot3.Location = new System.Drawing.Point(136, 64);
			this.dot3.Name = "dot3";
			this.dot3.Size = new System.Drawing.Size(16, 23);
			this.dot3.TabIndex = 7;
			this.dot3.Text = ".";
			this.dot3.TextAlign = System.Drawing.ContentAlignment.BottomLeft;
			// 
			// dot2
			// 
			this.dot2.Font = new System.Drawing.Font("Microsoft Sans Serif", 20F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dot2.Location = new System.Drawing.Point(88, 64);
			this.dot2.Name = "dot2";
			this.dot2.Size = new System.Drawing.Size(16, 23);
			this.dot2.TabIndex = 6;
			this.dot2.Text = ".";
			this.dot2.TextAlign = System.Drawing.ContentAlignment.BottomLeft;
			// 
			// dot
			// 
			this.dot.Font = new System.Drawing.Font("Microsoft Sans Serif", 20F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dot.ImageAlign = System.Drawing.ContentAlignment.BottomCenter;
			this.dot.Location = new System.Drawing.Point(40, 72);
			this.dot.Name = "dot";
			this.dot.Size = new System.Drawing.Size(16, 16);
			this.dot.TabIndex = 5;
			this.dot.Text = ".";
			this.dot.TextAlign = System.Drawing.ContentAlignment.BottomCenter;
			// 
			// dashLabel
			// 
			this.dashLabel.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dashLabel.Location = new System.Drawing.Point(192, 56);
			this.dashLabel.Name = "dashLabel";
			this.dashLabel.Size = new System.Drawing.Size(24, 23);
			this.dashLabel.TabIndex = 4;
			this.dashLabel.Text = "To";
			this.dashLabel.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// octetFourStart
			// 
			this.octetFourStart.Location = new System.Drawing.Point(152, 56);
			this.octetFourStart.Name = "octetFourStart";
			this.octetFourStart.Size = new System.Drawing.Size(32, 20);
			this.octetFourStart.TabIndex = 3;
			this.octetFourStart.Text = "";
			// 
			// octetThree
			// 
			this.octetThree.Location = new System.Drawing.Point(104, 56);
			this.octetThree.Name = "octetThree";
			this.octetThree.Size = new System.Drawing.Size(32, 20);
			this.octetThree.TabIndex = 2;
			this.octetThree.Text = "";
			// 
			// octetTwo
			// 
			this.octetTwo.Location = new System.Drawing.Point(56, 56);
			this.octetTwo.Name = "octetTwo";
			this.octetTwo.Size = new System.Drawing.Size(32, 20);
			this.octetTwo.TabIndex = 1;
			this.octetTwo.Text = "";
			// 
			// octetOne
			// 
			this.octetOne.Location = new System.Drawing.Point(8, 56);
			this.octetOne.Name = "octetOne";
			this.octetOne.Size = new System.Drawing.Size(32, 20);
			this.octetOne.TabIndex = 0;
			this.octetOne.Text = "";
			// 
			// okButton
			// 
			this.okButton.Location = new System.Drawing.Point(400, 224);
			this.okButton.Name = "okButton";
			this.okButton.TabIndex = 22;
			this.okButton.Text = "OK";
			this.okButton.Click += new System.EventHandler(this.okButton_Click);
			// 
			// WanConfiguration
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(560, 253);
			this.Controls.Add(this.okButton);
			this.Controls.Add(this.locationSettingsGroupBox);
			this.Controls.Add(this.currentFile);
			this.Controls.Add(this.currentFileLabel);
			this.Controls.Add(this.closeButton);
			this.Controls.Add(this.openConfigButton);
			this.Controls.Add(this.saveConfigurationButton);
			this.Controls.Add(this.deleteSelectedButton);
			this.Controls.Add(this.label3);
			this.Controls.Add(this.locationName);
			this.Controls.Add(this.addLocationButton);
			this.Controls.Add(this.wanView);
			this.Name = "WanConfiguration";
			this.Text = "WanConfiguration";
			this.locationSettingsGroupBox.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion


		/// <summary>
		/// Opens a configuration file
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void openConfigButton_Click(object sender, System.EventArgs e)
		{
			openConfiguration = new OpenFileDialog();
			openConfiguration.Title = "Open Wan Configuration";
			//openConfiguration.InitialDirectory = @defaultPath;
			openConfiguration.Filter = "Wan Files (*.cfg)|*.cfg";
			openConfiguration.FilterIndex = 0;
			openConfiguration.RestoreDirectory = true;

			if(openConfiguration.ShowDialog() == DialogResult.OK)
			{

				string fileName = openConfiguration.FileName;
				loadLogicalWan(fileName);
			}
		}

		/// <summary>
		/// loads the wan file
		/// </summary>
		/// <param name="fileName"></param>
		private void loadLogicalWan(string fileName)
		{
			wanView.Nodes.Clear();
			wanView.BeginUpdate();
			StreamReader reader = new StreamReader(fileName);

			string templine = reader.ReadLine();

			TreeNode currentNode = new TreeNode(templine);
			wanView.Nodes.Add(currentNode);
			currentNode = wanView.Nodes[0];
			templine = reader.ReadLine();

			while(templine != null)
			{
				if(templine.Length < 1)
				{
					templine = reader.ReadLine();
					continue;
				}
				else if((templine.Substring(0, 1) == "#"))
				{
					templine = reader.ReadLine();
					continue;
				}

				if(templine.IndexOf("{") >= 0)
				{
					templine = reader.ReadLine();
					string location = "";
					string name = "";
					if(templine.IndexOf("(") == -1)
						name = templine.TrimStart('\t');
					else
					{
						location = templine.TrimStart('\t');
						location = location.Substring(0, location.IndexOf("(") -1);

						name = location;
						location = templine.TrimStart('\t');
						int startIndex = location.IndexOf("(") + 1;
						int length = location.Length - startIndex - 1;
						string[] ipOctets = (location.Substring(startIndex, length)).Split(' ');
						Location tempLocal = new Location(name, new IPAddress(Int32.Parse(ipOctets[0]), Int32.Parse(ipOctets[1]), Int32.Parse(ipOctets[2]), Int32.Parse(ipOctets[3])), new IPAddress(Int32.Parse(ipOctets[0]), Int32.Parse(ipOctets[1]), Int32.Parse(ipOctets[2]), Int32.Parse(ipOctets[4])));
						locations.Add(tempLocal);
					}
					TreeNode tempNode = new TreeNode(name);
					currentNode.Nodes.Add(tempNode);
					currentNode = currentNode.LastNode;

					templine = reader.ReadLine();
					continue;
				}
				else if(templine.IndexOf("}") >= 0)
				{
					currentNode = currentNode.Parent;
					templine = reader.ReadLine();
					continue;
				}
				else
				{
					//Console.WriteLine(templine.TrimStart('\t'));
					string location = "";
					string name = "";
					if(templine.IndexOf("(") == -1)
						name = templine.TrimStart('\t');
					else
					{
						location = templine.TrimStart('\t');
						location = location.Substring(0, location.IndexOf("(") -1);
						name = location;
						location = templine.TrimStart('\t');
						int startIndex = location.IndexOf("(") + 1;
						int length = location.Length - startIndex - 1;
						string[] ipOctets = (location.Substring(startIndex, length)).Split(' ');
						Location tempLocal = new Location(name, new IPAddress(Int32.Parse(ipOctets[0]), Int32.Parse(ipOctets[1]), Int32.Parse(ipOctets[2]), Int32.Parse(ipOctets[3])), new IPAddress(Int32.Parse(ipOctets[0]), Int32.Parse(ipOctets[1]), Int32.Parse(ipOctets[2]), Int32.Parse(ipOctets[4])));
						locations.Add(tempLocal);
					}
					TreeNode tempNode = new TreeNode(name);
					currentNode.Parent.Nodes.Add(tempNode);
					currentNode = currentNode.NextNode;
				}
				templine = reader.ReadLine();
			}
			reader.Close();

			wanView.EndUpdate();
			wanView.ExpandAll();
		}

		/// <summary>
		/// Closes the window
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void closeButton_Click(object sender, System.EventArgs e)
		{
			this.DialogResult = DialogResult.Cancel;
			this.Hide();
		}

		/// <summary>
		/// Updates the view when a node is selected
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void wanView_AfterSelect(object sender, System.Windows.Forms.TreeViewEventArgs e)
		{
			string locationName = e.Node.Text;
			for(int i = 0; i < locations.Count; i++)
			{
				//Console.WriteLine(locationName + " | " + ((Location)(locations[i])).name);
				if(locationName == ((Location)(locations[i])).name)
				{
					currentLocation = (Location)locations[i];
					break;
				}
				else if(i == locations.Count -1)
				{
					currentLocation = null;
					locationSettingsGroupBox.Hide();
				}
			}
			if(currentLocation == null)
				return;
			string[] ip = (currentLocation.floor.toString()).Split('.');
			octetOne.Text = ip[0];
			octetTwo.Text = ip[1];
			octetThree.Text = ip[2];
			octetFourStart.Text = ip[3];
			ip = (currentLocation.ceiling.toString()).Split('.');
			octetFourEnd.Text = ip[3];
			locationSettingsGroupBox.Show();
		}

		/// <summary>
		/// Sets the ip range
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void setIPRangeButton_Click(object sender, System.EventArgs e)
		{
			if(currentLocation == null)
				return;

			if(octetOne.Text == "" || octetTwo.Text == "" || octetThree.Text == "" || octetFourStart.Text == "" || octetFourEnd.Text == "")
				return;

			currentLocation.floor = new IPAddress(Int32.Parse(octetOne.Text), Int32.Parse(octetTwo.Text), Int32.Parse(octetThree.Text), Int32.Parse(octetFourStart.Text));
			currentLocation.ceiling = new IPAddress(Int32.Parse(octetOne.Text), Int32.Parse(octetTwo.Text), Int32.Parse(octetThree.Text), Int32.Parse(octetFourEnd.Text));
		}

		/// <summary>
		/// Used to add a location to the tree
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void addLocationButton_Click(object sender, System.EventArgs e)
		{
			if(locationName.Text == "")
				return;
			
			LocationRangeEntry entry = new LocationRangeEntry();
			entry.ShowDialog();
			if(entry.DialogResult == DialogResult.OK)
			{
				if(entry.noIPRangeCheckbox.Checked)
				{
					TreeNode tempNode = new TreeNode(locationName.Text);
					wanView.SelectedNode.Nodes.Add(tempNode);
					wanView.ExpandAll();
					locationName.Text = "";
				}
				else
				{
					Location newLocation = new Location(locationName.Text, new IPAddress(0, 0, 0, 0), new IPAddress(0, 0, 0, 0));
					newLocation.floor = new IPAddress(Int32.Parse(entry.octetOne.Text), Int32.Parse(entry.octetTwo.Text), Int32.Parse(entry.octetThree.Text), Int32.Parse(entry.octetFourStart.Text));
					newLocation.ceiling = new IPAddress(Int32.Parse(entry.octetOne.Text), Int32.Parse(entry.octetTwo.Text), Int32.Parse(entry.octetThree.Text), Int32.Parse(entry.octetFourEnd.Text));
					locations.Add(newLocation);
					TreeNode tempNode = new TreeNode(locationName.Text);
					wanView.SelectedNode.Nodes.Add(tempNode);
					wanView.ExpandAll();
					locationName.Text = "";
				}
			}
			return;
		}

		/// <summary>
		/// Deletes a node and its children if there are some
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void deleteSelectedButton_Click(object sender, System.EventArgs e)
		{
			string name = wanView.SelectedNode.Text;
			for(int i = 0; i < locations.Count; i++)
				if(name == ((Location)(locations[i])).name)
					locations.RemoveAt(i);
			wanView.SelectedNode.Remove();
			return;
		}

		/// <summary>
		/// Opens a Save Dialog
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void saveConfigurationButton_Click(object sender, System.EventArgs e)
		{
			saveConfiguration = new SaveFileDialog();
			saveConfiguration.Filter = "Wan Configuration (*.cfg)|*.cfg";
			if(saveConfiguration.ShowDialog() == DialogResult.OK)
			{
				fileName = saveConfiguration.FileName;
				StreamWriter writer = new StreamWriter(fileName);
				writer.WriteLine(wanView.Nodes[0].Text);
				writer.WriteLine("{");
				indentCount++;
				saveConfig(wanView.Nodes[0], writer);
				indentCount = 0;
				writer.Close();
			}
		}

		/// <summary>
		/// Saves the actual information from the wan tree
		/// </summary>
		/// <param name="tn"></param>
		/// <param name="writer"></param>
		private void saveConfig(TreeNode tn, StreamWriter writer)
		{
			IEnumerator ie = tn.Nodes.GetEnumerator();

			string parentnode = "";

			parentnode = tn.Text;

			while (ie.MoveNext()) 
			{
				TreeNode ctn = (TreeNode) ie.Current;

				if (ctn.GetNodeCount(true) == 0) 
				{
					Location tempLocal = null;
					for(int i = 0; i < locations.Count; i++)
					{
						if(ctn.Text == ((Location)(locations[i])).name)
						{
							tempLocal = (Location)locations[i];
							break;
						}
					}
					
					for(int i = 0; i < indentCount; i++)
						writer.Write("\t");

					if(tempLocal == null)
						writer.Write(ctn.Text + "\n");
					else
					{
						writer.Write(ctn.Text + " (");
						writer.Write(tempLocal.floor.segOne + " ");
						writer.Write(tempLocal.floor.segTwo + " ");
						writer.Write(tempLocal.floor.segThree + " ");
						writer.Write(tempLocal.floor.segFour + " ");
						writer.Write(tempLocal.ceiling.segFour + ")\n");
					}
				} 
				else 
				{
					for(int i = 0; i < indentCount; i++)
						writer.Write("\t");

					writer.Write(ctn.Text + "\n");
					for(int i = 0; i < indentCount; i++)
						writer.Write("\t");
					writer.Write("{\n");
					indentCount++;
				}
				if (ctn.GetNodeCount(true) > 0) 
				{
					saveConfig(ctn, writer);
				}
			}

			for(int i = 0; i < indentCount -1; i++)
				writer.Write("\t");
			writer.Write("}\n");
			indentCount--;

		}

		/// <summary>
		/// Closes the window with an ok status
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void okButton_Click(object sender, System.EventArgs e)
		{
			this.DialogResult = DialogResult.OK;
			this.Hide();
		}
	}
}
