
import javax.servlet.http.*;
import javax.servlet.*;
import java.io.*;
import java.util.*;

public class CPIInterviewStateMachineServlet extends javax.servlet.http.HttpServlet
{

 private String partial_path = "info/iphac/";
 private ServletContext server;

 public void init(ServletConfig config) throws ServletException
 {
  super.init(config);
  server = config.getServletContext();
 }

 public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException
 {
  String action = req.getParameter("action");
  if (action == null || action == "")
   action = "start";

  String language = req.getParameter("language");
  if (language == null || language == "")
   language = "en_US";

  String release = req.getParameter("release");
  if (release == null || release == "")
   release = "v1r2s";

  String next_page = req.getParameter("next_page");
  if (next_page == null || next_page == "")
   next_page = "CPIsummary.jsp";

  RequestDispatcher rd = server.getRequestDispatcher("/"+release+"/"+language+"/"+partial_path+next_page);
  log("forwarding: "+"/"+release+"/"+language+"/"+partial_path+next_page);
  rd.forward(req, res);
 }

 public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException
 {
  doGet(req,res);
 }

}
