// File: CollideArgs.cs
// Author: Sonhui Schweitzer
// Date: January 25th, 2005
// Project: CS470 Applied Software Developement Project
using System;
using System.Collections;
using Microsoft.DirectX;

namespace BreakOut
{
	public class CollideArgs
	{
		private ArrayList m_oEntities;
		private ArrayList m_oNormals;

		public CollideArgs()
		{
			m_oEntities = new ArrayList();
			m_oNormals = new ArrayList();
		}

		public void AddCollider( Entity oEntity , Vector2 oNormal )
		{
			m_oEntities.Add( oEntity );
			m_oNormals.Add( oNormal );
		}

		public void RemoveCollider( int iIndex )
		{
			m_oEntities.RemoveAt( iIndex );
			m_oNormals.RemoveAt( iIndex );
		}

		public Entity GetEntity( int iIndex )
		{
			return ( Entity )m_oEntities[ iIndex ];
		}

		public Vector2 GetNormal( int iIndex )
		{
			return ( Vector2 )m_oNormals[ iIndex ];
		}

		public int Count { get { return m_oEntities.Count; } }
	}
}
