// File: PaddleSizePowerUp.cs
// Author: Sonhui Schweitzer
// Date: January 25th, 2005
// Project: CS470 Applied Software Developement Project
using System;
using Microsoft.DirectX;
using Direct3D=Microsoft.DirectX.Direct3D;
using DirectSound=Microsoft.DirectX.DirectSound;

namespace BreakOut
{
	class PaddleSizePowerUp : PowerUp
	{
		private float m_fSizeMultiplier;

		public PaddleSizePowerUp( Vector2 oLocation , System.Drawing.Color oColor , float fSizeMultiplier , string oTextureName ) : base( oLocation )
		{
			m_oName = oTextureName;
			Color = oColor;
			m_fSizeMultiplier = fSizeMultiplier;
		}

		public override void ApplyPowerUp( Game oGame )
		{
			for ( int i = 0 ; i < oGame.GetPaddleCount() ; ++i )
			{
				oGame.GetPaddle( i ).Size *= m_fSizeMultiplier;
			}
		}
	}
}
