// File: Void.cs
// Author: Sonhui Schweitzer
// Date: January 25th, 2005
// Project: CS470 Applied Software Developement Project
using System;
using Microsoft.DirectX;
using Direct3D=Microsoft.DirectX.Direct3D;
using DirectSound=Microsoft.DirectX.DirectSound;

namespace BreakOut
{
	public class Void : Entity
	{
		private Line m_oBounds;

		public Void( Vector2 oPoint1 , Vector2 oPoint2 )
		{
			m_oBounds = new Line( oPoint1 , oPoint2 );
		}

		~Void()
		{
		}

		public static Direct3D.VertexBuffer CreateVB( Direct3D.Device oDevice )
		{
			return null;
		}

		public virtual void Render( Direct3D.Device oDevice , Game oGame )
		{
		}

		public virtual void Collide( Game oGame , CollideArgs oArgs )
		{
			for ( int i = 0 ; i < oArgs.Count ; ++i )
			{
				if ( oArgs.GetEntity( i ) is Ball )
				{
					oGame.RemoveBall( ( Ball )oArgs.GetEntity( i ) );
					oGame.PlaySound( "Lost" );
					return;
				}
			}
		}

		public virtual float Update( Game oGame , float fDeltaTime )
		{
			return 0.0f;
		}

		public virtual Bounds GetBounds()
		{
			return m_oBounds;
		}
	}
}
