// File: Wall.cs
// Author: Sonhui Schweitzer
// Date: January 25th, 2005
// Project: CS470 Applied Software Developement Project
using System;
using System.Drawing;
using Microsoft.DirectX;
using Microsoft.DirectX.Direct3D;
using Microsoft.DirectX.DirectSound;
using Direct3D=Microsoft.DirectX.Direct3D;
using DirectSound=Microsoft.DirectX.DirectSound;

namespace BreakOut
{
	public class Wall : Entity
	{
		private Line m_oBounds;
		private bool m_bOuterWall;

		public Wall( Vector2 oPoint1 , Vector2 oPoint2 , bool bOuterWall )
		{
			m_oBounds = new Line( oPoint1 , oPoint2 );
			m_bOuterWall = bOuterWall;
		}

		public static Direct3D.VertexBuffer CreateVB( Direct3D.Device oDevice )
		{
			Direct3D.VertexBuffer oVB = new Direct3D.VertexBuffer( typeof( Direct3D.CustomVertex.PositionColoredTextured ) , 6 , oDevice , 0 , Direct3D.CustomVertex.PositionColoredTextured.Format , Microsoft.DirectX.Direct3D.Pool.Default );
			return oVB;
		}

		public virtual void Render( Direct3D.Device oDevice , Game oGame )
		{
			Direct3D.VertexBuffer oVB = oGame.GetVB( "Wall" );
			Direct3D.Texture oTexture = oGame.GetTexture( "Wall" );
			if ( ( oVB != null ) && ( oTexture != null ) )
			{
				Vector2 oWallVector = Vector2.Subtract( m_oBounds.EndPoint , m_oBounds.StartPoint );
				Vector2 oPerp = -Vector2.Normalize( new Vector2( oWallVector.Y , -oWallVector.X ) );
				oPerp *= 0.08f;
				Vector2 oPara = new Vector2( oPerp.Y , -oPerp.X );
				float fEdgeSize = 0.04f;
				GraphicsStream oStream = oVB.Lock( 0 , 0 , 0 );
				Direct3D.CustomVertex.PositionColoredTextured[] aVertices = new Direct3D.CustomVertex.PositionColoredTextured[ 6 ];
				if ( m_bOuterWall )
				{
					aVertices[ 0 ].X = m_oBounds.StartPoint.X;
					aVertices[ 0 ].Y = m_oBounds.StartPoint.Y;
					aVertices[ 0 ].Z = 0.0f;
					aVertices[ 0 ].Color = new Direct3D.ColorValue( 1.0f , 1.0f , 1.0f , 1.0f ).ToArgb();
					aVertices[ 0 ].Tu = fEdgeSize;
					aVertices[ 0 ].Tv = fEdgeSize;

					Vector2 oVector = m_oBounds.StartPoint + oPara + oPerp;
					aVertices[ 1 ].X = oVector.X;
					aVertices[ 1 ].Y = oVector.Y;
					aVertices[ 1 ].Z = 0.0f;
					aVertices[ 1 ].Color = new Direct3D.ColorValue( 1.0f , 1.0f , 1.0f , 1.0f ).ToArgb();
					aVertices[ 1 ].Tu = 0.5f;
					aVertices[ 1 ].Tv = 1.0f - fEdgeSize;

					oVector = m_oBounds.StartPoint + oPara;
					aVertices[ 2 ].X = oVector.X;
					aVertices[ 2 ].Y = oVector.Y;
					aVertices[ 2 ].Z = 0.0f;
					aVertices[ 2 ].Color = new Direct3D.ColorValue( 1.0f , 1.0f , 1.0f , 1.0f ).ToArgb();
					aVertices[ 2 ].Tu = 0.5f;
					aVertices[ 2 ].Tv = fEdgeSize;

					oVector = m_oBounds.EndPoint + ( -oPara ) + oPerp;
					aVertices[ 3 ].X = oVector.X;
					aVertices[ 3 ].Y = oVector.Y;
					aVertices[ 3 ].Z = 0.0f;
					aVertices[ 3 ].Color = new Direct3D.ColorValue( 1.0f , 1.0f , 1.0f , 1.0f ).ToArgb();
					aVertices[ 3 ].Tu = 0.5f;
					aVertices[ 3 ].Tv = 1.0f - fEdgeSize;

					oVector = m_oBounds.EndPoint + ( -oPara );
					aVertices[ 4 ].X = oVector.X;
					aVertices[ 4 ].Y = oVector.Y;
					aVertices[ 4 ].Z = 0.0f;
					aVertices[ 4 ].Color = new Direct3D.ColorValue( 1.0f , 1.0f , 1.0f , 1.0f ).ToArgb();
					aVertices[ 4 ].Tu = 0.5f;
					aVertices[ 4 ].Tv = fEdgeSize;

					aVertices[ 5 ].X = m_oBounds.EndPoint.X;
					aVertices[ 5 ].Y = m_oBounds.EndPoint.Y;
					aVertices[ 5 ].Z = 0.0f;
					aVertices[ 5 ].Color = new Direct3D.ColorValue( 1.0f , 1.0f , 1.0f , 1.0f ).ToArgb();
					aVertices[ 5 ].Tu = 1.0f - fEdgeSize;
					aVertices[ 5 ].Tv = fEdgeSize;
				}
				else
				{
					Vector2 oVector = m_oBounds.StartPoint + ( -oPara ) + oPerp;
					aVertices[ 0 ].X = oVector.X;
					aVertices[ 0 ].Y = oVector.Y;
					aVertices[ 0 ].Z = 0.0f;
					aVertices[ 0 ].Color = new Direct3D.ColorValue( 1.0f , 1.0f , 1.0f , 1.0f ).ToArgb();
					aVertices[ 0 ].Tu = fEdgeSize;
					aVertices[ 0 ].Tv = fEdgeSize;

					oVector = m_oBounds.StartPoint;
					aVertices[ 1 ].X = oVector.X;
					aVertices[ 1 ].Y = oVector.Y;
					aVertices[ 1 ].Z = 0.0f;
					aVertices[ 1 ].Color = new Direct3D.ColorValue( 1.0f , 1.0f , 1.0f , 1.0f ).ToArgb();
					aVertices[ 1 ].Tu = 0.25f;
					aVertices[ 1 ].Tv = 1.0f - fEdgeSize;

					oVector = m_oBounds.StartPoint + oPerp;
					aVertices[ 2 ].X = oVector.X;
					aVertices[ 2 ].Y = oVector.Y;
					aVertices[ 2 ].Z = 0.0f;
					aVertices[ 2 ].Color = new Direct3D.ColorValue( 1.0f , 1.0f , 1.0f , 1.0f ).ToArgb();
					aVertices[ 2 ].Tu = 0.25f;
					aVertices[ 2 ].Tv = fEdgeSize;

					oVector = m_oBounds.EndPoint;
					aVertices[ 3 ].X = oVector.X;
					aVertices[ 3 ].Y = oVector.Y;
					aVertices[ 3 ].Z = 0.0f;
					aVertices[ 3 ].Color = new Direct3D.ColorValue( 1.0f , 1.0f , 1.0f , 1.0f ).ToArgb();
					aVertices[ 3 ].Tu = 0.75f;
					aVertices[ 3 ].Tv = 1.0f - fEdgeSize;

					oVector = m_oBounds.EndPoint + oPerp;
					aVertices[ 4 ].X = oVector.X;
					aVertices[ 4 ].Y = oVector.Y;
					aVertices[ 4 ].Z = 0.0f;
					aVertices[ 4 ].Color = new Direct3D.ColorValue( 1.0f , 1.0f , 1.0f , 1.0f ).ToArgb();
					aVertices[ 4 ].Tu = 0.75f;
					aVertices[ 4 ].Tv = fEdgeSize;

					oVector = m_oBounds.EndPoint + oPara + oPerp;
					aVertices[ 5 ].X = oVector.X;
					aVertices[ 5 ].Y = oVector.Y;
					aVertices[ 5 ].Z = 0.0f;
					aVertices[ 5 ].Color = new Direct3D.ColorValue( 1.0f , 1.0f , 1.0f , 1.0f ).ToArgb();
					aVertices[ 5 ].Tu = 1.0f - fEdgeSize;
					aVertices[ 5 ].Tv = fEdgeSize;
				}

				oStream.Write( aVertices );
				oVB.Unlock();

				oDevice.Transform.World = Matrix.Identity;

				oDevice.SetStreamSource( 0 , oVB , 0 );
				oDevice.VertexFormat = Direct3D.CustomVertex.PositionColoredTextured.Format;

				oDevice.SetTexture( 0 , oTexture );
				oDevice.RenderState.AlphaBlendEnable = true;
				oDevice.RenderState.SourceBlend = Direct3D.Blend.SourceAlpha;
				oDevice.RenderState.DestinationBlend = Direct3D.Blend.InvSourceAlpha;
				oDevice.SamplerState[ 0 ].MinFilter = Direct3D.TextureFilter.Linear;
				oDevice.SamplerState[ 0 ].MagFilter = Direct3D.TextureFilter.Linear;
				oDevice.SamplerState[ 0 ].MipFilter = Direct3D.TextureFilter.Point;
				oDevice.TextureState[ 0 ].ColorOperation = Direct3D.TextureOperation.Modulate;
				oDevice.TextureState[ 0 ].ColorArgument1 = Direct3D.TextureArgument.TextureColor;
				oDevice.TextureState[ 0 ].ColorArgument2 = Direct3D.TextureArgument.Diffuse;
				oDevice.TextureState[ 0 ].AlphaOperation = Direct3D.TextureOperation.Modulate;
				oDevice.TextureState[ 0 ].AlphaArgument1 = Direct3D.TextureArgument.TextureColor;
				oDevice.TextureState[ 0 ].AlphaArgument2 = Direct3D.TextureArgument.Diffuse;
				oDevice.DrawPrimitives( Direct3D.PrimitiveType.TriangleStrip , 0 , 4 );
				oDevice.RenderState.AlphaBlendEnable = false;
			}
		}

		public virtual void Collide( Game oGame , CollideArgs oArgs )
		{
		}

		public virtual float Update( Game oGame , float fDeltaTime )
		{
			return 0.0f;
		}

		public virtual Bounds GetBounds()
		{
			return m_oBounds;
		}
	}
}
