class UnitsController < ApplicationController
  before_filter :login_required
  layout "standard-layout"
  def index
    list
    render :action => 'list'
  end

  def test(file)
    ERB.new(IO.readlines(file).join '').result
  end

  def list
    @unit_pages, @units = paginate :units, :per_page => 10
  end

  def show
    @unit = Unit.find(params[:id])
  end

  def new
    @unit = Unit.new
  end

  def create
    @unit = Unit.new(params[:unit])
    if @unit.save
      flash[:notice] = 'Unit was successfully created.'
      redirect_to :action => 'list'
    else
      render :action => 'new'
    end
  end

  def edit
    @unit = Unit.find(params[:id])
  end

  def update
    @unit = Unit.find(params[:id])
    if @unit.update_attributes(params[:unit])
      flash[:notice] = 'Unit was successfully updated.'
      redirect_to :action => 'show', :id => @unit
    else
      render :action => 'edit'
    end
  end

  def destroy
    Unit.find(params[:id]).destroy
f lash[:notice] = 'Unit was successfully Destroyed.'
    redirect_to :action => 'list'
  end
end
