CREATE TABLE `categories` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(50) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `cuisines` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(50) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `ingredients` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(40) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `inventories` (
  `id` int(11) NOT NULL auto_increment,
  `user_id` int(11) NOT NULL,
  `ingredient_id` int(11) NOT NULL,
  `unit_id` int(11) NOT NULL,
  `quantity` int(11) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `ratings` (
  `id` int(11) NOT NULL auto_increment,
  `user_id` int(11) NOT NULL,
  `recipe_id` int(11) NOT NULL,
  `rating` int(11) NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `recipe_ingredients` (
  `id` int(11) NOT NULL auto_increment,
  `recipe_id` int(11) NOT NULL,
  `ingredient_id` int(11) NOT NULL,
  `quantity` int(11) NOT NULL,
  `unit_id` int(11) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `recipes` (
  `id` int(11) NOT NULL auto_increment,
  `title` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `created_at` date NOT NULL,
  `instructions` text,
  `subcategory_id` int(11) NOT NULL,
  `cuisine_id` int(11) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `subcategories` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(50) NOT NULL,
  `category_id` int(11) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `units` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(40) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `users` (
  `id` int(11) NOT NULL auto_increment,
  `login` varchar(40) NOT NULL,
  `password` varchar(40) NOT NULL,
  `first_name` varchar(30) NOT NULL,
  `last_name` varchar(30) NOT NULL,
  `email` varchar(60) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records 
-- ----------------------------
ALTER TABLE `inventories` ADD CONSTRAINT `fk_ingredients_inventories` 
    FOREIGN KEY (`ingredient_id`) REFERENCES `ingredients` (`id`);

ALTER TABLE `inventories` ADD CONSTRAINT `fk_inventories_units` 
    FOREIGN KEY (`user_id`) REFERENCES `users` (`id`);

ALTER TABLE `inventories` ADD CONSTRAINT `fk_units_inventories` 
    FOREIGN KEY (`unit_id`) REFERENCES `units` (`id`);

ALTER TABLE `ratings` ADD CONSTRAINT `fk_recipe_ratings` 
    FOREIGN KEY (`recipe_id`) REFERENCES `recipes` (`id`);

ALTER TABLE `ratings` ADD CONSTRAINT `fk_users_ratings` 
    FOREIGN KEY (`user_id`) REFERENCES `users` (`id`);

ALTER TABLE `recipe_ingredients` ADD CONSTRAINT `fk_units_recipe_ingredients` 
    FOREIGN KEY (`unit_id`) REFERENCES `units` (`id`);

ALTER TABLE `recipe_ingredients` ADD CONSTRAINT `fk_ingredients_recipes` 
    FOREIGN KEY (`ingredient_id`) REFERENCES `ingredients` (`id`);

ALTER TABLE `recipe_ingredients` ADD CONSTRAINT `fk_recipes_recipes_ingredients` 
    FOREIGN KEY (`recipe_id`) REFERENCES `recipes` (`id`);

ALTER TABLE `recipes` ADD CONSTRAINT `fk_recipe_cuisinetype` 
    FOREIGN KEY (`cuisine_id`) REFERENCES `cuisines` (`id`);

ALTER TABLE `recipes` ADD CONSTRAINT `fk_subcategories_recipes` 
    FOREIGN KEY (`subcategory_id`) REFERENCES `subcategories` (`id`);

ALTER TABLE `subcategories` ADD CONSTRAINT `fk_categories_subcategories` 
    FOREIGN KEY (`category_id`) REFERENCES `categories` (`id`);

INSERT INTO `users` VALUES ('1', 'ben', 'c8e007be5150c4cf702d9e1751f709f3fced4f3c', 'Ben', 'Smith', 'ben@test.net');
INSERT INTO `users` VALUES ('2', 'daniel', 'c8e007be5150c4cf702d9e1751f709f3fced4f3c', 'Daniel', 'Jones', 'daniel@test.com');
INSERT INTO `users` VALUES ('3', 'ben', '1c5d922776a691ca772d8d95b4e3701c101946aa', 'Bob', 'Gomley', 'bob@gomley.net');
INSERT INTO `units` VALUES ('1', 'grams');
INSERT INTO `categories` VALUES ('1', 'soups');
INSERT INTO `categories` VALUES ('2', 'baked goods');
INSERT INTO `cuisines` VALUES ('1', 'italian');
INSERT INTO `cuisines` VALUES ('2', 'french');
INSERT INTO `ingredients` VALUES ('1', 'flour');
INSERT INTO `ingredients` VALUES ('2', 'sugar');
INSERT INTO `ingredients` VALUES ('3', 'corn');
INSERT INTO `ingredients` VALUES ('4', 'chicken');
INSERT INTO `ingredients` VALUES ('5', 'beef');
INSERT INTO `ingredients` VALUES ('6', 'rice');
INSERT INTO `ingredients` VALUES ('7', 'soy sauce');
INSERT INTO `ingredients` VALUES ('8', 'crayon');
INSERT INTO `ingredients` VALUES ('9', 'blue');
INSERT INTO `subcategories` VALUES ('1', 'broth soups', '1');
INSERT INTO `recipes` VALUES ('1', 'Chicken soup', 'Yummiest Soup', '2006-04-25', '', '1', '1');
INSERT INTO `recipes` VALUES ('2', 'Another soup', 'Not so yummy', '2006-04-25', null, '1', '1');
INSERT INTO `recipes` VALUES ('3', 'caserole', 'just a caserole', '2006-04-25', null, '1', '2');
INSERT INTO `recipe_ingredients` VALUES ('1', '1', '1', '1', '1');
INSERT INTO `recipe_ingredients` VALUES ('2', '1', '2', '1', '1');
INSERT INTO `recipe_ingredients` VALUES ('3', '1', '3', '1', '1');
INSERT INTO `recipe_ingredients` VALUES ('4', '1', '4', '1', '1');
INSERT INTO `recipe_ingredients` VALUES ('5', '2', '4', '1', '1');
INSERT INTO `recipe_ingredients` VALUES ('6', '3', '3', '1', '1');
INSERT INTO `recipe_ingredients` VALUES ('7', '3', '5', '1', '1');
INSERT INTO `inventories` VALUES ('1', '1', '1', '1', '1');
INSERT INTO `inventories` VALUES ('2', '1', '2', '1', '1');
INSERT INTO `inventories` VALUES ('3', '1', '3', '1', '1');
INSERT INTO `inventories` VALUES ('4', '1', '4', '1', '1');
INSERT INTO `inventories` VALUES ('5', '2', '1', '1', '1');
INSERT INTO `inventories` VALUES ('6', '2', '2', '1', '1');
INSERT INTO `inventories` VALUES ('7', '3', '3', '1', '1');
INSERT INTO `inventories` VALUES ('8', '3', '5', '1', '1');

