CREATE TABLE `categories` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(50) NOT NULL,
  `parent_id` varchar(50) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
CREATE UNIQUE INDEX IUX_categories_1 ON `categories` (`id`,`parent_id`);

CREATE TABLE `cuisines` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(50) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `ingredients` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(40) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `inventories` (
  `id` int(11) NOT NULL auto_increment,
  `user_id` int(11) NOT NULL,
  `ingredient_id` int(11) NOT NULL,
  `unit_id` int(11) NOT NULL,
  `quantity` int(11) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `ratings` (
  `id` int(11) NOT NULL auto_increment,
  `user_id` int(11) NOT NULL,
  `recipe_id` int(11) NOT NULL,
  `rating` int(11) NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `recipe_ingredients` (
  `id` int(11) NOT NULL auto_increment,
  `recipe_id` int(11) NOT NULL,
  `ingredient_id` int(11) NOT NULL,
  `unit_id` int(11) NOT NULL,
  `quantity` int(11) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `recipes` (
  `id` int(11) NOT NULL auto_increment,
  `title` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `created_at` date NOT NULL,
  `instructions` text,
  `category_id` int(11) NOT NULL,
  `cuisine_id` int(11) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `units` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(40) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `users` (
  `id` int(11) NOT NULL auto_increment,
  `login` varchar(40) NOT NULL,
  `password` varchar(40) NOT NULL,
  `first_name` varchar(30) NOT NULL,
  `last_name` varchar(30) NOT NULL,
  `email` varchar(60) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records 
-- ----------------------------
ALTER TABLE `inventories` ADD CONSTRAINT `fk_ingredients_inventories` 
    FOREIGN KEY (`ingredient_id`) REFERENCES `ingredients` (`id`);

ALTER TABLE `inventories` ADD CONSTRAINT `fk_inventories_units` 
    FOREIGN KEY (`user_id`) REFERENCES `users` (`id`);

ALTER TABLE `inventories` ADD CONSTRAINT `fk_units_inventories` 
    FOREIGN KEY (`unit_id`) REFERENCES `units` (`id`);

ALTER TABLE `ratings` ADD CONSTRAINT `fk_recipe_ratings` 
    FOREIGN KEY (`recipe_id`) REFERENCES `recipes` (`id`);

ALTER TABLE `ratings` ADD CONSTRAINT `fk_users_ratings` 
    FOREIGN KEY (`user_id`) REFERENCES `users` (`id`);

ALTER TABLE `recipe_ingredients` ADD CONSTRAINT `fk_units_recipe_ingredients` 
    FOREIGN KEY (`unit_id`) REFERENCES `units` (`id`);

ALTER TABLE `recipe_ingredients` ADD CONSTRAINT `fk_ingredients_recipes` 
    FOREIGN KEY (`ingredient_id`) REFERENCES `ingredients` (`id`);

ALTER TABLE `recipe_ingredients` ADD CONSTRAINT `fk_recipes_recipes_ingredients` 
    FOREIGN KEY (`recipe_id`) REFERENCES `recipes` (`id`);

ALTER TABLE `recipes` ADD CONSTRAINT `fk_recipe_cuisinetype` 
    FOREIGN KEY (`cuisine_id`) REFERENCES `cuisines` (`id`);

ALTER TABLE `recipes` ADD CONSTRAINT `fk_categories_recipes` 
    FOREIGN KEY (`category_id`) REFERENCES `categories` (`id`);
