#pragma once
#include <string>

namespace ChaosEngine
{
	class IAudio
	{
	public:
		virtual ~IAudio( void ) { };
		virtual void Update( void ) = 0;
		virtual void LoadSound( const std::string& oSoundName , bool bLooping , const std::string& oFilename ) = 0;
		virtual void CreateSoundSource( const std::string& oSoundSourceName , const std::string& oSoundName , float* pPosition ) = 0;
		virtual void DestroySoundSource( const std::string& oSoundSourceName ) = 0;
		virtual void SetListenerPosition( float* pPosition , float* pForward , float* pUp ) = 0;
		virtual void SetSoundSourcePosition( const std::string& oSoundSourceName , float* pPosition ) = 0;
		virtual void SetMasterVolume( float fVolume ) = 0;
	};
};
