#pragma once
#include <string>
#include "IInputEventHandler.h"

namespace ChaosEngine
{
	class IInput
	{
	private:

	public:
		virtual ~IInput( void ) { };

		virtual void Startup( void ) = 0;
		virtual bool IsReady( void ) = 0;
		virtual void Shutdown( void ) = 0;
		virtual void SetInputEventHandler( IInputEventHandler* pHandler ) = 0;
		virtual void Aquire( void ) = 0;
		virtual bool IsAquired( void ) = 0;
		virtual void UnAquire( void ) = 0;
		virtual void Poll( void ) = 0;
	};
};