#pragma once

#include <string>
#include <sstream>
#include <algorithm>
#include <hash_map>
#include "IGraphics.h"
#include "IAudio.h"
#include "IInput.h"
#include "IPhysics.h"
#include "StateManager.h"
#include "Log.h"
#include "Entities.h"

namespace ChaosEngine
{
	// the system class manages the current state of the system and provides access to the subsytems as well as 
	// propagating the subsystem events to the current system state
	class System : public IPhysicsEventHandler, public IInputEventHandler
	{
	private:
		typedef stdext::hash_map< std::string , Entity* > EntityHash;

		IGraphics* m_pGraphics;
		IAudio* m_pAudio;
		IInput* m_pInput;
		IPhysics* m_pPhysics;
		StateManager* m_pStateManager;

		EntityHash m_oEntities;

	public:
		System( void );
		~System( void );

		// Subsystem accessors and mutators
		void SetGraphics( IGraphics* pGraphics );
		IGraphics* GetGraphics( void );
		void SetAudio( IAudio* pAudio );
		IAudio* GetAudio( void );
		void SetInput( IInput* pInput );
		IInput* GetInput( void );
		void SetPhysics( IPhysics* pPhysics );
		IPhysics* GetPhysics( void );

		// State management functions
		void AddState( IBaseState* pState );
		void ChangeState( const std::string& oNewStateName );

		// Object management functions
		void AddEntity( const std::string& oEntityName , Entity* pEntity );
		Entity* GetEntity( const std::string& oEntityName );
		void RemoveEntity( const std::string& oEntityName );

		// System Event handlers
		virtual void Update( float fDeltaTime );

		// Physics Event Handler
		virtual bool ShouldCreateContact( const std::string& oBody1Name , const std::string& oBody2Name );
		virtual void Collision( const std::string& oGeometry1Name , const std::string& oGeometry2Name );

		// Input Event Handler
		virtual void KeyDown( const std::string& oKeyName );
		virtual void KeyUp( const std::string& oKeyName );
		virtual void ButtonDown( const std::string& oButtonName );
		virtual void ButtonUp( const std::string& oButtonName );
		virtual void MouseMoved( float* pAxisDeltas );
	};
};
