#pragma once
#include <string>

namespace ChaosEngine
{
	class IGraphics
	{
	public:
		virtual ~IGraphics( void ) { };

		virtual void CreateSphere( const std::string& oName , const std::string& oMaterialName , float* pPosition , float* pOrientation , float fRadius ) = 0;
		virtual void CreateBox( const std::string& oName , const std::string& oMaterialName , float* pPosition , float* pOrientation , float* pSideLengths ) = 0;
		virtual void SetObjectPosition( const std::string& oName , float* pPosition ) = 0;
		virtual void SetObjectOrientation( const std::string& oName , float* pOrientation ) = 0;
		virtual void DestroyObject( const std::string& oName ) = 0;

		virtual void CreateMaterial( const std::string& oMaterialName , float* pColor ) = 0;
		virtual void DestroyMaterial( const std::string& oMaterialName ) = 0;

		virtual void SetLight( float* pPosition , float* pDirection , float* pColor ) = 0;
		virtual void SetCamera( float* pPosition , float* pOrientation ) = 0;

		virtual void GetCameraDirection( float* pDirection , float* pUp ) = 0;

		virtual void DrawString( float* pPosition , const std::string& oString ) = 0;
	};
};
