#pragma once
#include <string>
#include <fstream>

namespace ChaosEngine
{
	class Log
	{
	private:
		static std::ofstream* m_pFileStream;
		static int m_iLogMessageLevel;

	public:
		enum MessageLevel
		{
			Information,
			Warning,
			Error,
			Debug
		};

		static void Close( void );
		static void Open( const std::string& oFilename );
		static void SetLevel( int iMessageLevel );
		static void WriteMessage( const std::string& oMessage , int iMessageLevel );
	};
};
