
#include "D3DGraphics.h"
#include "FMODAudio.h"
#include "DIInput.h"
#include "ODEPhysics.h"
#include "System.h"
#include "InitializingState.h"
#include "Log.h"

int WINAPI WinMain( HINSTANCE , HINSTANCE , LPSTR , int )
{
    // Enable run-time memory check for debug builds.
#if defined(DEBUG) | defined(_DEBUG)
    _CrtSetDbgFlag( _CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF );
#endif

	using namespace ChaosEngine;

	Log::Open( std::string( "Log.txt" ) );
	Log::WriteMessage( std::string( "Application Started" ) , Log::Information );
	Log::WriteMessage( std::string( "" ) , Log::Information );
	// create the main environment which holds worlds and GUIs
	System* pSystem = new System();

	// perform platform specific initialization of the sub systems
	pSystem->SetGraphics( new D3DGraphics( pSystem ) );
	pSystem->SetAudio( new FMODAudio( pSystem ) );
	DIInput* pInput = new DIInput( pSystem );
	pInput->SetInstanceHandle( DXUTGetHINSTANCE() );
	pInput->SetWindowHandle( DXUTGetHWND() );
	pSystem->SetInput( pInput );
	pSystem->SetPhysics( new ODEPhysics( pSystem ) );

	// create and add the start state of the system
	pSystem->AddState( new InitializingState( pSystem ) );

	// set the system in motion, returning only when the application is ready to exit
	DXUTMainLoop();

	// clean up the system
	if ( pSystem != NULL ) { delete pSystem; pSystem = NULL; }

	Log::WriteMessage( std::string( "Application Exiting" ) , Log::Information );
	Log::WriteMessage( std::string( "" ) , Log::Information );
	Log::Close();
	return DXUTGetExitCode();
};



//extern "C"
//{
//	#include <lua.h>
//    #include <lualib.h>
//    #include <lauxlib.h>
//}

//#define WIN32_LEAN_AND_MEAN
//#include <windows.h>
//#include "StateManager.h"
//#include <iostream>
//
//bool g_bExit = false;
//
//class LoadingState : public IBaseState
//{
//private:
//	StateManager* m_pManager;
//public:
//	LoadingState( StateManager* pManager ) : m_pManager( pManager ) { };
//	virtual void OnEnter( const std::string& szPrevious ) { };
//	virtual void Update()
//	{
//		std::cout << "Loading some shit...." << std::endl;
//		std::cout << "Ok, done loading change into running state..." << std::endl;
//		m_pManager->ChangeState( "Running" );
//	};
//	virtual void OnExit( const std::string& szNext ) { };
//	virtual void OnOverride( const std::string& szNext ) { };
//	virtual void OnResume( const std::string& szPrevious ) { };
//};
//
//class RunningState : public IBaseState
//{
//private:
//	StateManager* m_pManager;
//	bool m_bPaused;
//public:
//	RunningState( StateManager* pManager ) : m_pManager( pManager ) , m_bPaused( false ) { };
//	virtual void OnEnter( const std::string& szPrevious ) { };
//	virtual void Update()
//	{
//		if ( !m_bPaused )
//		{
//			std::cout << "Enter Command: ";
//			std::string oLine;
//			std::getline( std::cin , oLine );
//			if ( oLine == "quit" )
//			{
//				g_bExit = true;
//			}
//			else if ( oLine == "gameover" )
//			{
//				m_pManager->ChangeState( "Loading" );
//			}
//			else if ( oLine == "menu" )
//			{
//				m_pManager->PushState( "Menu" );
//			}
//		}
//	};
//	virtual void OnExit( const std::string& szNext ) { };
//	virtual void OnOverride( const std::string& szNext ) { m_bPaused = true; };
//	virtual void OnResume( const std::string& szPrevious ) { m_bPaused = false; };
//};
//
//class MenuState : public IBaseState
//{
//private:
//	StateManager* m_pManager;
//public:
//	MenuState( StateManager* pManager ) : m_pManager( pManager ) { };
//	virtual void OnEnter( const std::string& szPrevious ) { };
//	virtual void Update()
//	{
//		std::cout << "Enter Menu Command: ";
//		std::string oLine;
//		std::getline( std::cin , oLine );
//		if ( oLine == "list" )
//		{
//			std::cout << "leave - leave the menu and go back to the game" << std::endl;
//		}
//		else if ( oLine == "leave" )
//		{
//			m_pManager->PopState();
//		}
//	};
//	virtual void OnExit( const std::string& szNext ) { };
//	virtual void OnOverride( const std::string& szNext ) { };
//	virtual void OnResume( const std::string& szPrevious ) { };
//};
//
//int main( int argc , char** argv )
//{
//	StateManager oManager;
//	oManager.Init();
//	oManager.RegisterState( "Loading" , new LoadingState( &oManager ) );
//	oManager.RegisterState( "Running" , new RunningState( &oManager ) );
//	oManager.RegisterState( "Menu" , new MenuState( &oManager ) );
//	oManager.ChangeState( "Loading" );
//	while ( !g_bExit )
//	{
//		oManager.Update( 1.0f );
//	}
//	oManager.Term();
//};

//#define WIN32_LEAN_AND_MEAN
//#include <windows.h>
//#include "StateManager.h"
//#include <iostream>
//#include <map>
//#include <vector>
//
//class Control
//{
//private:
//	std::string m_oName;
//	std::vector< std::string > m_oGraphicsAssets;
//	std::vector< std::string > m_oAudioAssets;
//	std::vector< std::string > m_o
//public:
//	Control( Dialog* m_pDialog )
//	{
//	};
//
//	std::string GetName( void )
//	{
//		return m_oName;
//	}
//
//	void Render( void )
//	{
//	}
//};
//
//class Dialog
//{
//private:
//	std::map< std::string , Control* > m_oControls;
//public:
//	Dialog( void )
//	{
//	};
//
//	void AddControl( Control* pControl )
//	{
//		m_oControls[ pControl->GetName() ] = pControl;
//	}
//
//	// events
//
//	void Render( void )
//	{
//		for ( std::map< std::string , Control* >::const_iterator oIterator = m_oControls.begin() ; oIterator != m_oControls.end() ; oIterator++ )
//		{
//			oIterator->second->Render();
//		}
//	}
//};
//
//int main( int argc , char** argv )
//{
//	std::map< std::string , Entity* > oMap;
//	oMap[ "Hmm" ] = new Entity();
//};
