#pragma once
#include <string>
#include <algorithm>
#include "State.h"
#include "System.h"

namespace ChaosEngine
{
	// the running state polls input, steps the physics system, and updates the game objects
	// when the running state detects the game over condition is changes to the unloading state
	class RunningState : public State
	{
	private:
		float m_oCameraPosition[ 3 ];
		float m_oCameraOrientation[ 3 ];
		float m_oCameraVelocity[ 3 ];
		bool m_bMovingForward;
		bool m_bMovingBackward;
		bool m_bDown;
	public:
		RunningState( System* pSystem );
		virtual ~RunningState( void );
		virtual void OnEnter( const std::string& oPrevious );
		virtual void Update( float fDeltaTime );
		virtual void OnExit( const std::string& oNext );
		virtual void OnOverride( const std::string& oNext );
		virtual void OnResume( const std::string& oPrevious );
		virtual void KeyDown( const std::string& oKeyName );
		virtual void KeyUp( const std::string& oKeyName );
		virtual void ButtonDown( const std::string& oButtonName );
		virtual void ButtonUp( const std::string& oButtonName );
		virtual void MouseMoved( float* pAxisDeltas );
		virtual bool ShouldCreateContact( const std::string& oBody1Name , const std::string& oBody2Name );
		virtual void Collision( const std::string& oGeometry1Name , const std::string& oGeometry2Name );
	};
};
