using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using MhsModelCSharp;
using Mhs=MhsModelCSharp;

namespace MhsApplication
{
	/// <summary>
	/// Summary description for PlantPatchWizard.
	/// </summary>
	public class PlantPatchWizard : System.Windows.Forms.UserControl
	{
		private System.Windows.Forms.Label lblWizardInstructions;
		private System.Windows.Forms.LinkLabel llblWizardNext;
		private System.Windows.Forms.LinkLabel llblWizardSkip;
		private System.Windows.Forms.LinkLabel llblWizardBack;
		private System.Windows.Forms.Panel pnlWizardLinkLabels;

		private int cygIdx = -1;
		private PlantPatch plantpatch = null;
		private bool[,] stepTracker = new bool[Mhs.ModelParameters.NUM_CYGS_PER_PLANTPATCH,3];

		/// <summary> 
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public PlantPatchWizard()
		{
			// This call is required by the Windows.Forms Form Designer.
			InitializeComponent();

			// TODO: Add any initialization after the InitializeComponent call

		}

		public string DisplayText 
		{
			set { this.lblWizardInstructions.Text = value; }
		}

		/// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Component Designer generated code
		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.lblWizardInstructions = new System.Windows.Forms.Label();
			this.llblWizardNext = new System.Windows.Forms.LinkLabel();
			this.llblWizardSkip = new System.Windows.Forms.LinkLabel();
			this.llblWizardBack = new System.Windows.Forms.LinkLabel();
			this.pnlWizardLinkLabels = new System.Windows.Forms.Panel();
			this.pnlWizardLinkLabels.SuspendLayout();
			this.SuspendLayout();
			// 
			// lblWizardInstructions
			// 
			this.lblWizardInstructions.Dock = System.Windows.Forms.DockStyle.Fill;
			this.lblWizardInstructions.Font = new System.Drawing.Font("Microsoft Sans Serif", 20.25F);
			this.lblWizardInstructions.Location = new System.Drawing.Point(0, 0);
			this.lblWizardInstructions.Name = "lblWizardInstructions";
			this.lblWizardInstructions.Size = new System.Drawing.Size(560, 48);
			this.lblWizardInstructions.TabIndex = 6;
			// 
			// llblWizardNext
			// 
			this.llblWizardNext.Dock = System.Windows.Forms.DockStyle.Left;
			this.llblWizardNext.Font = new System.Drawing.Font("Microsoft Sans Serif", 10F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.llblWizardNext.Location = new System.Drawing.Point(144, 0);
			this.llblWizardNext.Name = "llblWizardNext";
			this.llblWizardNext.Size = new System.Drawing.Size(72, 16);
			this.llblWizardNext.TabIndex = 9;
			this.llblWizardNext.TabStop = true;
			this.llblWizardNext.Text = "Next >>";
			this.llblWizardNext.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.llblWizardNext.Visible = false;
			// 
			// llblWizardSkip
			// 
			this.llblWizardSkip.Dock = System.Windows.Forms.DockStyle.Left;
			this.llblWizardSkip.Font = new System.Drawing.Font("Microsoft Sans Serif", 10F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.llblWizardSkip.Location = new System.Drawing.Point(72, 0);
			this.llblWizardSkip.Name = "llblWizardSkip";
			this.llblWizardSkip.Size = new System.Drawing.Size(72, 16);
			this.llblWizardSkip.TabIndex = 8;
			this.llblWizardSkip.TabStop = true;
			this.llblWizardSkip.Text = "Skip Level";
			this.llblWizardSkip.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			this.llblWizardSkip.Visible = false;
			// 
			// llblWizardBack
			// 
			this.llblWizardBack.Dock = System.Windows.Forms.DockStyle.Left;
			this.llblWizardBack.Font = new System.Drawing.Font("Microsoft Sans Serif", 10F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.llblWizardBack.Location = new System.Drawing.Point(0, 0);
			this.llblWizardBack.Name = "llblWizardBack";
			this.llblWizardBack.Size = new System.Drawing.Size(72, 16);
			this.llblWizardBack.TabIndex = 7;
			this.llblWizardBack.TabStop = true;
			this.llblWizardBack.Text = "<< Back";
			this.llblWizardBack.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			this.llblWizardBack.Visible = false;
			// 
			// pnlWizardLinkLabels
			// 
			this.pnlWizardLinkLabels.Controls.Add(this.llblWizardNext);
			this.pnlWizardLinkLabels.Controls.Add(this.llblWizardSkip);
			this.pnlWizardLinkLabels.Controls.Add(this.llblWizardBack);
			this.pnlWizardLinkLabels.Dock = System.Windows.Forms.DockStyle.Bottom;
			this.pnlWizardLinkLabels.Location = new System.Drawing.Point(0, 32);
			this.pnlWizardLinkLabels.Name = "pnlWizardLinkLabels";
			this.pnlWizardLinkLabels.Size = new System.Drawing.Size(560, 16);
			this.pnlWizardLinkLabels.TabIndex = 10;
			// 
			// PlantPatchWizard
			// 
			this.Controls.Add(this.pnlWizardLinkLabels);
			this.Controls.Add(this.lblWizardInstructions);
			this.Name = "PlantPatchWizard";
			this.Size = new System.Drawing.Size(560, 48);
			this.pnlWizardLinkLabels.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		private void NextStep()
		{
		}

		private void PreviousStep()
		{
			if( plantpatch != null )
			{
				if( cygIdx > -1 )
				{
					// do nothing if at the beginning
					if( cygIdx == 0 && 
						plantpatch.Cygs[0].BasePointIsSet == false)
					{
						return;
					}

					// if somewhere in the middle go back one

					// all three already set, go to next one
					if( plantpatch.Cygs[cygIdx].BasePointIsSet &&
						plantpatch.Cygs[cygIdx].TipPointIsSet &&
						plantpatch.Cygs[cygIdx].BaseDiameterIsSet )
					{
						// go back to tip point
					}
					else if(	plantpatch.Cygs[cygIdx].BasePointIsSet &&
						plantpatch.Cygs[cygIdx].TipPointIsSet )
					{
						// go back to base point
					}
					else if(	plantpatch.Cygs[cygIdx].BasePointIsSet )
					{
					}
				}
			}
		}


		private bool IsNextStepComplete()
		{
			// find the next step
			// if it has been done once then return true
			// this would indicate that the next button
			// makes sense to show and click
			return false;
		}

		private void SkipLevel()
		{
		}

	}
}
