#include "StdAfx.h"
#include "D3dPictureBox.h"

D3dPictureBox::D3dPictureBox()
{
	SetStyle( static_cast<ControlStyles>(	ControlStyles::DoubleBuffer |
											ControlStyles::AllPaintingInWmPaint |
											ControlStyles::UserPaint |
											ControlStyles::Opaque |
											ControlStyles::ResizeRedraw), 
		true);

	D3dInit();
}

void D3dPictureBox::Dispose(bool doIt)
{
	__super::Dispose(doIt);
}

void D3dPictureBox::D3dInit()
{
	try
	{
		PresentParameters *presentParams = new PresentParameters();
		presentParams->Windowed = true;
		presentParams->SwapEffect = SwapEffect::Discard;
		presentParams->BackBufferFormat = Format::Unknown;	// default for windowed mode,
															// so not needed. Oh well!
		PresentParameters * m_param __gc [] = {presentParams};
		m_device = new Device(	0,
								DeviceType::Hardware,
								this,
								CreateFlags::SoftwareVertexProcessing,
								m_param);
		m_device->RenderState->Lighting = false;
		m_device->RenderState->ShadeMode = ShadeMode::Gouraud;
		m_device->RenderState->ZBufferEnable = false;
		m_device->RenderState->CullMode = Cull::CounterClockwise;
		m_device->Transform->Projection = Matrix::Identity;
		m_device->Transform->View = Matrix::Identity;
		m_device->Transform->World = Matrix::Identity;
		//// More on all this in week 2, 3 and 4.
		//// Begining in the week 2 class examples we will discover
		//// a "problem" with this and how to solve it.
		//// Hint: see Real-Time Rendering chapter 3.5
		//System.Drawing.Size clientarea = this.ClientSize;
		//Matrix world2ndc = new Matrix();
		//Vector3 scale = new Vector3(2.0f / clientarea.Width, 2.0f / clientarea.Height, 1.0f);
		//Vector3 translate = new Vector3(-1.0f, -1.0f, 0.0f);
		//world2ndc = Matrix.Transformation(Vector3.Empty, // scaling center
		//	Quaternion.Zero, // scaling rotation
		//	scale, // scaling factor
		//	Vector3.Empty, // rotation center
		//	Quatern o , // rotation i n.Zero
		//	translate); // translation
		//m_device.Transform.World = world2ndc;
		//// This is equivalent to the previous e lin :
		////m_device.SetTransform(TransformType.W rl ld ; o d, wor 2ndc)
		//return true;
	}
	catch(int)
	{
		//return false;
	}
}

void D3dPictureBox::D3dRender()
{

	m_device->Clear(ClearFlags::Target, System::Drawing::Color::Blue,1.0f,0);

				m_device->BeginScene();

				// render here
				
				m_device->EndScene();
				m_device->Present();

}


void  D3dPictureBox::OnPaint( PaintEventArgs* e )
{
	__super::OnPaint(e);
	D3dRender();
}

